/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.Mkdir;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.compiler.ant.taskdefs.Unzip;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.FileOrDirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ExtractedDirectoryPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractedDirectoryPackagingElement
extends FileOrDirectoryCopyPackagingElement<ExtractedDirectoryPackagingElement> {
    private String a;

    public ExtractedDirectoryPackagingElement() {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE);
    }

    public ExtractedDirectoryPackagingElement(String string, String string2) {
        super(PackagingElementFactoryImpl.EXTRACTED_DIRECTORY_ELEMENT_TYPE, string);
        this.a = string2;
        if (!StringUtil.startsWithChar((CharSequence)this.a, (char)'/')) {
            this.a = "/" + this.a;
        }
        if (!StringUtil.endsWithChar((CharSequence)this.a, (char)'/')) {
            this.a = this.a + "/";
        }
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext artifactEditorContext) {
        if (artifactEditorContext == null) {
            ExtractedDirectoryPackagingElement.b(0);
        }
        return new ExtractedDirectoryPresentation(this);
    }

    public String toString() {
        return "extracted:" + this.myFilePath + "!" + this.a;
    }

    @Override
    public VirtualFile findFile() {
        VirtualFile virtualFile = super.findFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile);
        if ("/".equals(this.a)) {
            return virtualFile2;
        }
        return virtualFile2 != null ? virtualFile2.findFileByRelativePath(this.a) : null;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull AntCopyInstructionCreator antCopyInstructionCreator, @NotNull ArtifactAntGenerationContext artifactAntGenerationContext, @NotNull ArtifactType artifactType) {
        if (packagingElementResolvingContext == null) {
            ExtractedDirectoryPackagingElement.b(1);
        }
        if (antCopyInstructionCreator == null) {
            ExtractedDirectoryPackagingElement.b(2);
        }
        if (artifactAntGenerationContext == null) {
            ExtractedDirectoryPackagingElement.b(3);
        }
        if (artifactType == null) {
            ExtractedDirectoryPackagingElement.b(4);
        }
        String string = artifactAntGenerationContext.getSubstitutedPath(this.myFilePath);
        String string2 = StringUtil.trimStart((String)this.a, (String)"/");
        if (string2.length() == 0) {
            return Collections.singletonList(antCopyInstructionCreator.createExtractedDirectoryInstruction(string));
        }
        String string3 = PathUtil.getFileName((String)this.myFilePath);
        String string4 = artifactAntGenerationContext.createNewTempFileProperty("temp.unpacked.path." + string3, string3);
        String string5 = BuildProperties.propertyRef((String)string4);
        artifactAntGenerationContext.runBeforeCurrentArtifact((Generator)new Mkdir(string5));
        Unzip unzip = new Unzip(string, string5);
        PatternSet patternSet = new PatternSet(null);
        patternSet.add((Generator)new Include(string2 + "**"));
        unzip.add((Generator)patternSet);
        artifactAntGenerationContext.runBeforeCurrentArtifact((Generator)unzip);
        return Collections.singletonList(antCopyInstructionCreator.createDirectoryContentCopyInstruction(string5 + "/" + string2));
    }

    @Override
    public boolean isEqualTo(@NotNull PackagingElement<?> packagingElement) {
        if (packagingElement == null) {
            ExtractedDirectoryPackagingElement.b(5);
        }
        return packagingElement instanceof ExtractedDirectoryPackagingElement && super.isEqualTo(packagingElement) && Comparing.equal((String)this.a, (String)((ExtractedDirectoryPackagingElement)packagingElement).getPathInJar());
    }

    public ExtractedDirectoryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull ExtractedDirectoryPackagingElement extractedDirectoryPackagingElement) {
        if (extractedDirectoryPackagingElement == null) {
            ExtractedDirectoryPackagingElement.b(6);
        }
        this.myFilePath = extractedDirectoryPackagingElement.getFilePath();
        this.a = extractedDirectoryPackagingElement.getPathInJar();
    }

    @Attribute(value="path-in-jar")
    public String getPathInJar() {
        return this.a;
    }

    public void setPathInJar(String string) {
        this.a = string;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/elements/ExtractedDirectoryPackagingElement";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeAntInstructions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isEqualTo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

