/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.ui.LibraryElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPackagingElement
extends ComplexPackagingElement<LibraryPackagingElement> {
    @NonNls
    public static final String LIBRARY_NAME_ATTRIBUTE = "name";
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "module-name";
    @NonNls
    public static final String LIBRARY_LEVEL_ATTRIBUTE = "level";
    private String a;
    private String c;
    private String b;

    public LibraryPackagingElement() {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
    }

    public LibraryPackagingElement(String string, String string2, String string3) {
        super((PackagingElementType)LibraryElementType.LIBRARY_ELEMENT_TYPE);
        this.a = string;
        this.c = string2;
        this.b = string3;
    }

    public List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull ArtifactType artifactType) {
        Library library;
        if (packagingElementResolvingContext == null) {
            LibraryPackagingElement.a(0);
        }
        if (artifactType == null) {
            LibraryPackagingElement.a(1);
        }
        if ((library = this.findLibrary(packagingElementResolvingContext)) != null) {
            VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
            ArrayList<FileCopyPackagingElement> arrayList = new ArrayList<FileCopyPackagingElement>();
            for (VirtualFile virtualFile : virtualFileArray) {
                String string = PathUtil.getLocalPath((VirtualFile)virtualFile);
                if (string == null) continue;
                String string2 = FileUtil.toSystemIndependentName((String)string);
                arrayList.add((FileCopyPackagingElement)(virtualFile.isDirectory() && virtualFile.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(string2) : new FileCopyPackagingElement(string2)));
            }
            return arrayList;
        }
        return null;
    }

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext packagingElementResolvingContext) {
        Library library = this.findLibrary(packagingElementResolvingContext);
        PackagingElementOutputKind packagingElementOutputKind = library != null ? LibraryPackagingElement.getKindForLibrary(library) : PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            LibraryPackagingElement.a(2);
        }
        return packagingElementOutputKind;
    }

    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext artifactEditorContext) {
        if (artifactEditorContext == null) {
            LibraryPackagingElement.a(3);
        }
        return new LibraryElementPresentation(this.c, this.a, this.b, this.findLibrary((PackagingElementResolvingContext)artifactEditorContext), artifactEditorContext);
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> packagingElement) {
        if (packagingElement == null) {
            LibraryPackagingElement.a(4);
        }
        if (!(packagingElement instanceof LibraryPackagingElement)) {
            return false;
        }
        LibraryPackagingElement libraryPackagingElement = (LibraryPackagingElement)packagingElement;
        return this.a != null && this.c != null && this.a.equals(libraryPackagingElement.getLevel()) && this.c.equals(libraryPackagingElement.getLibraryName()) && Comparing.equal((String)this.b, (String)libraryPackagingElement.getModuleName());
    }

    public LibraryPackagingElement getState() {
        return this;
    }

    public void loadState(@NotNull LibraryPackagingElement libraryPackagingElement) {
        if (libraryPackagingElement == null) {
            LibraryPackagingElement.a(5);
        }
        this.a = libraryPackagingElement.getLevel();
        this.c = libraryPackagingElement.getLibraryName();
        this.b = libraryPackagingElement.getModuleName();
    }

    @Attribute(value="level")
    public String getLevel() {
        return this.a;
    }

    public void setLevel(String string) {
        this.a = string;
    }

    @Attribute(value="name")
    public String getLibraryName() {
        return this.c;
    }

    public void setLibraryName(String string) {
        this.c = string;
    }

    @Attribute(value="module-name")
    public String getModuleName() {
        return this.b;
    }

    public void setModuleName(String string) {
        this.b = string;
    }

    public String toString() {
        return "lib:" + this.c + "(" + (this.b != null ? "module " + this.b : this.a) + ")";
    }

    @Nullable
    public Library findLibrary(@NotNull PackagingElementResolvingContext packagingElementResolvingContext) {
        if (packagingElementResolvingContext == null) {
            LibraryPackagingElement.a(6);
        }
        if (this.b == null) {
            return packagingElementResolvingContext.findLibrary(this.a, this.c);
        }
        ModulesProvider modulesProvider = packagingElementResolvingContext.getModulesProvider();
        Module module2 = modulesProvider.getModule(this.b);
        if (module2 != null) {
            for (OrderEntry orderEntry : modulesProvider.getRootModel(module2).getOrderEntries()) {
                String string;
                LibraryOrderEntry libraryOrderEntry;
                if (!(orderEntry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || (string = libraryOrderEntry.getLibraryName()) == null || !string.equals(this.c)) continue;
                return libraryOrderEntry.getLibrary();
            }
        }
        return null;
    }

    public static PackagingElementOutputKind getKindForLibrary(Library library) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (VirtualFile virtualFile : library.getFiles(OrderRootType.CLASSES)) {
            if (virtualFile.isInLocalFileSystem()) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        return new PackagingElementOutputKind(bl2, bl3);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/LibraryPackagingElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitution";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

