/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleOutputPackagingElementBase
extends PackagingElement<ModuleOutputPackagingElementState>
implements ModuleOutputPackagingElement {
    @NonNls
    public static final String MODULE_NAME_ATTRIBUTE = "name";
    protected ModulePointer myModulePointer;
    protected final Project myProject;

    public ModuleOutputPackagingElementBase(PackagingElementType packagingElementType, Project project2, ModulePointer modulePointer) {
        super(packagingElementType);
        this.myProject = project2;
        this.myModulePointer = modulePointer;
    }

    public ModuleOutputPackagingElementBase(PackagingElementType packagingElementType, Project project2) {
        super(packagingElementType);
        this.myProject = project2;
    }

    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext packagingElementResolvingContext, @NotNull AntCopyInstructionCreator antCopyInstructionCreator, @NotNull ArtifactAntGenerationContext artifactAntGenerationContext, @NotNull ArtifactType artifactType) {
        if (packagingElementResolvingContext == null) {
            ModuleOutputPackagingElementBase.a(0);
        }
        if (antCopyInstructionCreator == null) {
            ModuleOutputPackagingElementBase.a(1);
        }
        if (artifactAntGenerationContext == null) {
            ModuleOutputPackagingElementBase.a(2);
        }
        if (artifactType == null) {
            ModuleOutputPackagingElementBase.a(3);
        }
        if (this.myModulePointer != null) {
            String string = BuildProperties.propertyRef((String)this.getModuleOutputAntProperty(artifactAntGenerationContext));
            return Collections.singletonList(antCopyInstructionCreator.createDirectoryContentCopyInstruction(string));
        }
        return Collections.emptyList();
    }

    protected abstract String getModuleOutputAntProperty(ArtifactAntGenerationContext var1);

    @Nullable
    protected abstract VirtualFile getModuleOutputPath(CompilerModuleExtension var1);

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext packagingElementResolvingContext) {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES;
        if (packagingElementOutputKind == null) {
            ModuleOutputPackagingElementBase.a(4);
        }
        return packagingElementOutputKind;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> packagingElement) {
        if (packagingElement == null) {
            ModuleOutputPackagingElementBase.a(5);
        }
        return packagingElement.getClass() == this.getClass() && this.myModulePointer != null && this.myModulePointer.equals(((ModuleOutputPackagingElementBase)packagingElement).myModulePointer);
    }

    public ModuleOutputPackagingElementState getState() {
        ModuleOutputPackagingElementState moduleOutputPackagingElementState = new ModuleOutputPackagingElementState();
        if (this.myModulePointer != null) {
            moduleOutputPackagingElementState.setModuleName(this.myModulePointer.getModuleName());
        }
        return moduleOutputPackagingElementState;
    }

    public void loadState(@NotNull ModuleOutputPackagingElementState moduleOutputPackagingElementState) {
        String string;
        if (moduleOutputPackagingElementState == null) {
            ModuleOutputPackagingElementBase.a(6);
        }
        this.myModulePointer = (string = moduleOutputPackagingElementState.getModuleName()) != null ? ModulePointerManager.getInstance((Project)this.myProject).create(string) : null;
    }

    @Override
    @Nullable
    public String getModuleName() {
        return this.myModulePointer != null ? this.myModulePointer.getModuleName() : null;
    }

    @Override
    @Nullable
    public Module findModule(PackagingElementResolvingContext packagingElementResolvingContext) {
        if (this.myModulePointer != null) {
            Module module2 = this.myModulePointer.getModule();
            ModulesProvider modulesProvider = packagingElementResolvingContext.getModulesProvider();
            if (module2 != null && (modulesProvider instanceof DefaultModulesProvider || ArrayUtil.contains((Object)module2, (Object[])modulesProvider.getModules()))) {
                return module2;
            }
            return modulesProvider.getModule(this.myModulePointer.getModuleName());
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ModuleOutputPackagingElementBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAntInstructions";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModuleOutputPackagingElementState {
        private String a;

        @Attribute(value="name")
        public String getModuleName() {
            return this.a;
        }

        public void setModuleName(String string) {
            this.a = string;
        }
    }
}

