/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.FoldingHandler;
import com.intellij.psi.codeStyle.arrangement.FoldingInfo;
import com.intellij.psi.codeStyle.arrangement.Info;
import com.intellij.psi.codeStyle.arrangement.RangeHandler;
import com.intellij.psi.codeStyle.arrangement.RichTextHandler;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.testFramework.fixtures.LightPlatformCodeInsightFixtureTestCase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRearrangerTest
extends LightPlatformCodeInsightFixtureTestCase {
    private static final RichTextHandler[] l = new RichTextHandler[]{new RangeHandler(), new FoldingHandler()};
    private static final Pattern k = Pattern.compile("([^\\s]+)=([^\\s]+)");
    protected FileType fileType;
    protected Language language;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).setTemporarySettings(new CodeStyleSettings());
    }

    @Override
    protected void tearDown() throws Exception {
        CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).dropTemporarySettings();
        super.tearDown();
    }

    @NotNull
    protected CommonCodeStyleSettings getCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).getCurrentSettings().getCommonSettings(this.language);
        if (commonCodeStyleSettings == null) {
            AbstractRearrangerTest.b(0);
        }
        return commonCodeStyleSettings;
    }

    protected static ArrangementSectionRule section(StdArrangementMatchRule ... stdArrangementMatchRuleArray) {
        if (stdArrangementMatchRuleArray == null) {
            AbstractRearrangerTest.b(1);
        }
        return AbstractRearrangerTest.section(null, null, stdArrangementMatchRuleArray);
    }

    protected static ArrangementSectionRule section(@Nullable String string, @Nullable String string2, StdArrangementMatchRule ... stdArrangementMatchRuleArray) {
        if (stdArrangementMatchRuleArray == null) {
            AbstractRearrangerTest.b(2);
        }
        return ArrangementSectionRule.create((String)string, (String)string2, (StdArrangementMatchRule[])stdArrangementMatchRuleArray);
    }

    protected static StdArrangementRuleAliasToken alias(@NotNull String string, StdArrangementMatchRule ... stdArrangementMatchRuleArray) {
        if (string == null) {
            AbstractRearrangerTest.b(3);
        }
        if (stdArrangementMatchRuleArray == null) {
            AbstractRearrangerTest.b(4);
        }
        return new StdArrangementRuleAliasToken(string, string, (List)ContainerUtil.newArrayList((Object[])stdArrangementMatchRuleArray));
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken arrangementSettingsToken) {
        if (arrangementSettingsToken == null) {
            AbstractRearrangerTest.b(5);
        }
        ArrangementGroupingRule arrangementGroupingRule = AbstractRearrangerTest.group(arrangementSettingsToken, StdArrangementTokens.Order.KEEP);
        if (arrangementGroupingRule == null) {
            AbstractRearrangerTest.b(6);
        }
        return arrangementGroupingRule;
    }

    @NotNull
    protected static ArrangementGroupingRule group(@NotNull ArrangementSettingsToken arrangementSettingsToken, @NotNull ArrangementSettingsToken arrangementSettingsToken2) {
        if (arrangementSettingsToken == null) {
            AbstractRearrangerTest.b(7);
        }
        if (arrangementSettingsToken2 == null) {
            AbstractRearrangerTest.b(8);
        }
        ArrangementGroupingRule arrangementGroupingRule = new ArrangementGroupingRule(arrangementSettingsToken, arrangementSettingsToken2);
        if (arrangementGroupingRule == null) {
            AbstractRearrangerTest.b(9);
        }
        return arrangementGroupingRule;
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull ArrangementSettingsToken arrangementSettingsToken) {
        if (arrangementSettingsToken == null) {
            AbstractRearrangerTest.b(10);
        }
        StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(arrangementSettingsToken)));
        if (stdArrangementMatchRule == null) {
            AbstractRearrangerTest.b(11);
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    protected static StdArrangementMatchRule nameRule(@NotNull String string, ArrangementSettingsToken ... arrangementSettingsTokenArray) {
        if (string == null) {
            AbstractRearrangerTest.b(12);
        }
        if (arrangementSettingsTokenArray == null) {
            AbstractRearrangerTest.b(13);
        }
        if (arrangementSettingsTokenArray.length == 0) {
            StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)AbstractRearrangerTest.atom(string)));
            if (stdArrangementMatchRule == null) {
                AbstractRearrangerTest.b(14);
            }
            return stdArrangementMatchRule;
        }
        ArrangementAtomMatchCondition[] arrangementAtomMatchConditionArray = new ArrangementAtomMatchCondition[arrangementSettingsTokenArray.length + 1];
        arrangementAtomMatchConditionArray[0] = AbstractRearrangerTest.atom(string);
        for (int i2 = 0; i2 < arrangementSettingsTokenArray.length; ++i2) {
            arrangementAtomMatchConditionArray[i2 + 1] = AbstractRearrangerTest.atom(arrangementSettingsTokenArray[i2]);
        }
        ArrangementMatchCondition arrangementMatchCondition = ArrangementUtil.combine((ArrangementMatchCondition[])arrangementAtomMatchConditionArray);
        StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher(arrangementMatchCondition));
        if (stdArrangementMatchRule == null) {
            AbstractRearrangerTest.b(15);
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementSettingsToken ... arrangementSettingsTokenArray) {
        if (arrangementSettingsTokenArray == null) {
            AbstractRearrangerTest.b(16);
        }
        StdArrangementMatchRule stdArrangementMatchRule = AbstractRearrangerTest.rule(ContainerUtil.map((Object[])arrangementSettingsTokenArray, arrangementSettingsToken -> AbstractRearrangerTest.atom(arrangementSettingsToken)));
        if (stdArrangementMatchRule == null) {
            AbstractRearrangerTest.b(17);
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    protected static StdArrangementMatchRule rule(@NotNull List<ArrangementAtomMatchCondition> list2) {
        if (list2 == null) {
            AbstractRearrangerTest.b(18);
        }
        StdArrangementMatchRule stdArrangementMatchRule = AbstractRearrangerTest.rule(list2.toArray(new ArrangementAtomMatchCondition[0]));
        if (stdArrangementMatchRule == null) {
            AbstractRearrangerTest.b(19);
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    protected static StdArrangementMatchRule rule(ArrangementAtomMatchCondition ... arrangementAtomMatchConditionArray) {
        if (arrangementAtomMatchConditionArray == null) {
            AbstractRearrangerTest.b(20);
        }
        ArrangementMatchCondition arrangementMatchCondition = ArrangementUtil.combine((ArrangementMatchCondition[])arrangementAtomMatchConditionArray);
        StdArrangementMatchRule stdArrangementMatchRule = new StdArrangementMatchRule(new StdArrangementEntryMatcher(arrangementMatchCondition));
        if (stdArrangementMatchRule == null) {
            AbstractRearrangerTest.b(21);
        }
        return stdArrangementMatchRule;
    }

    @NotNull
    protected static StdArrangementMatchRule ruleWithOrder(@NotNull ArrangementSettingsToken arrangementSettingsToken, @NotNull StdArrangementMatchRule stdArrangementMatchRule) {
        if (arrangementSettingsToken == null) {
            AbstractRearrangerTest.b(22);
        }
        if (stdArrangementMatchRule == null) {
            AbstractRearrangerTest.b(23);
        }
        StdArrangementMatchRule stdArrangementMatchRule2 = new StdArrangementMatchRule(stdArrangementMatchRule.getMatcher(), arrangementSettingsToken);
        if (stdArrangementMatchRule2 == null) {
            AbstractRearrangerTest.b(24);
        }
        return stdArrangementMatchRule2;
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken arrangementSettingsToken) {
        if (arrangementSettingsToken == null) {
            AbstractRearrangerTest.b(25);
        }
        ArrangementAtomMatchCondition arrangementAtomMatchCondition = new ArrangementAtomMatchCondition(arrangementSettingsToken);
        if (arrangementAtomMatchCondition == null) {
            AbstractRearrangerTest.b(26);
        }
        return arrangementAtomMatchCondition;
    }

    protected static ArrangementAtomMatchCondition atom(@NotNull ArrangementSettingsToken arrangementSettingsToken, boolean bl2) {
        if (arrangementSettingsToken == null) {
            AbstractRearrangerTest.b(27);
        }
        return new ArrangementAtomMatchCondition(arrangementSettingsToken, (Object)bl2);
    }

    @NotNull
    protected static ArrangementAtomMatchCondition atom(@NotNull String string) {
        if (string == null) {
            AbstractRearrangerTest.b(28);
        }
        ArrangementAtomMatchCondition arrangementAtomMatchCondition = new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)string);
        if (arrangementAtomMatchCondition == null) {
            AbstractRearrangerTest.b(29);
        }
        return arrangementAtomMatchCondition;
    }

    protected void doTest(@NotNull Map<String, ?> map) {
        if (map == null) {
            AbstractRearrangerTest.b(30);
        }
        String string = (String)map.get("initial");
        String string2 = (String)map.get("expected");
        List<TextRange> list2 = (List<TextRange>)map.get("ranges");
        Info info = AbstractRearrangerTest.b(string);
        if (!AbstractRearrangerTest.a(list2) && !AbstractRearrangerTest.a(info.ranges)) {
            AbstractRearrangerTest.fail((String)("Duplicate ranges set: explicit: " + list2 + ", derived: " + info.ranges + ", text:\n" + string));
        }
        if (AbstractRearrangerTest.a(info.ranges)) {
            info.ranges = !AbstractRearrangerTest.a(list2) ? list2 : Collections.singletonList(TextRange.from((int)0, (int)string.length()));
        }
        this.myFixture.configureByText(this.fileType, info.text);
        FoldingModel foldingModel = this.myFixture.getEditor().getFoldingModel();
        for (FoldingInfo object2 : info.foldings) {
            foldingModel.runBatchFoldingOperation(() -> {
                FoldRegion foldRegion = foldingModel.addFoldRegion(foldingInfo.start, foldingInfo.end, foldingInfo.placeholder);
                if (foldRegion != null) {
                    foldRegion.setExpanded(false);
                }
            });
        }
        List list3 = (List)map.get("groups");
        if (list3 == null) {
            list3 = Collections.emptyList();
        }
        List list4 = (List)map.get("rules");
        List<ArrangementSectionRule> list5 = this.getSectionRules(list4);
        List list6 = (List)map.get("aliases");
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyleSettingsManager.getInstance((Project)this.myFixture.getProject()).getCurrentSettings().getCommonSettings(this.language);
        StdArrangementSettings stdArrangementSettings = list6 == null ? new StdArrangementSettings(list3, list5) : new StdArrangementExtendableSettings(list3, list5, (Collection)list6);
        commonCodeStyleSettings.setArrangementSettings((ArrangementSettings)stdArrangementSettings);
        ArrangementEngine arrangementEngine = (ArrangementEngine)ServiceManager.getService((Project)this.myFixture.getProject(), ArrangementEngine.class);
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> arrangementEngine.arrange(this.myFixture.getEditor(), this.myFixture.getFile(), info.ranges), null, null);
        Info info2 = AbstractRearrangerTest.b(string2);
        AbstractRearrangerTest.assertEquals((String)info2.text, (String)this.myFixture.getEditor().getDocument().getText());
        for (FoldingInfo foldingInfo : info2.foldings) {
            FoldRegion foldRegion = foldingModel.getCollapsedRegionAtOffset(foldingInfo.start);
            AbstractRearrangerTest.assertNotNull((String)("Expected to find fold region at offset " + foldingInfo.start), (Object)foldRegion);
            AbstractRearrangerTest.assertEquals((int)foldingInfo.end, (int)foldRegion.getEndOffset());
        }
    }

    protected List<ArrangementSectionRule> getSectionRules(List<?> list2) {
        List list3 = Collections.emptyList();
        if (list2 != null) {
            list3 = ContainerUtil.map(list2, object -> object instanceof ArrangementSectionRule ? (ArrangementSectionRule)object : ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{(StdArrangementMatchRule)object}));
        }
        return list3;
    }

    private static boolean a(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @NotNull
    private static Info b(@NotNull String string) {
        if (string == null) {
            AbstractRearrangerTest.b(31);
        }
        Info info = new Info();
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = 0;
        while (n2 < stringBuilder.length()) {
            RichTextHandler richTextHandler = null;
            int n3 = -1;
            for (RichTextHandler richTextHandler2 : l) {
                int n4 = stringBuilder.indexOf("<" + richTextHandler2.getMarker(), n2);
                if (n4 < 0 || richTextHandler != null && n4 >= n3) continue;
                n3 = n4;
                richTextHandler = richTextHandler2;
            }
            if (richTextHandler == null) break;
            String string2 = richTextHandler.getMarker();
            int n5 = n3 + string2.length() + 1;
            int n6 = stringBuilder.indexOf(">", n3);
            int n7 = n6 - n3 + 1;
            Map<String, String> map = AbstractRearrangerTest.a(stringBuilder.substring(n5, n6));
            String string3 = "</" + (String)string2 + ">";
            int n8 = stringBuilder.indexOf(string3);
            assert (n8 > 0);
            richTextHandler.handle(info, map, n3, n8 - n7);
            stringBuilder.delete(n8, n8 + string3.length());
            stringBuilder.delete(n3, n6 + 1);
            n2 = n8 - n7;
        }
        info.text = stringBuilder.toString();
        Info info2 = info;
        if (info2 == null) {
            AbstractRearrangerTest.b(32);
        }
        return info2;
    }

    @NotNull
    private static Map<String, String> a(@NotNull String string) {
        if (string == null) {
            AbstractRearrangerTest.b(33);
        }
        if (string.isEmpty()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                AbstractRearrangerTest.b(34);
            }
            return map;
        }
        Matcher matcher = k.matcher(string);
        LinkedHashMap linkedHashMap = ContainerUtil.newLinkedHashMap();
        while (matcher.find()) {
            linkedHashMap.put(matcher.group(1), matcher.group(2));
        }
        LinkedHashMap linkedHashMap2 = linkedHashMap;
        if (linkedHashMap2 == null) {
            AbstractRearrangerTest.b(35);
        }
        return linkedHashMap2;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/AbstractRearrangerTest";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 12: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFilter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/AbstractRearrangerTest";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 11: 
            case 17: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "rule";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "nameRule";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "ruleWithOrder";
                break;
            }
            case 26: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "atom";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAttributes";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "section";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "alias";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 10: 
            case 16: 
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "rule";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "nameRule";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "ruleWithOrder";
                break;
            }
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "atom";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

