/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment.debug;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugServerModeHandler;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebuggerLauncher;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerLauncherImpl
extends JavaDebuggerLauncher {
    private static final Logger a = Logger.getInstance(JavaDebuggerLauncherImpl.class);

    public void startDebugSession(@NotNull JavaDebugConnectionData javaDebugConnectionData, @NotNull ExecutionEnvironment executionEnvironment, @NotNull RemoteServer<?> remoteServer) throws ExecutionException {
        if (javaDebugConnectionData == null) {
            JavaDebuggerLauncherImpl.a(0);
        }
        if (executionEnvironment == null) {
            JavaDebuggerLauncherImpl.a(1);
        }
        if (remoteServer == null) {
            JavaDebuggerLauncherImpl.a(2);
        }
        Project project2 = executionEnvironment.getProject();
        DebuggerPanelsManager debuggerPanelsManager = DebuggerPanelsManager.getInstance(project2);
        final JavaDebugServerModeHandler javaDebugServerModeHandler = javaDebugConnectionData.getServerModeHandler();
        boolean bl2 = javaDebugServerModeHandler != null;
        RemoteConnection remoteConnection = new RemoteConnection(true, javaDebugConnectionData.getHost(), String.valueOf(javaDebugConnectionData.getPort()), bl2);
        RemoteServerDebugEnvironment remoteServerDebugEnvironment = new RemoteServerDebugEnvironment(project2, remoteConnection, executionEnvironment.getRunProfile());
        RemoteServerDebugUIEnvironment remoteServerDebugUIEnvironment = new RemoteServerDebugUIEnvironment(remoteServerDebugEnvironment, executionEnvironment);
        RunContentDescriptor runContentDescriptor = debuggerPanelsManager.attachVirtualMachine(remoteServerDebugUIEnvironment);
        a.assertTrue(runContentDescriptor != null);
        ProcessHandler processHandler = runContentDescriptor.getProcessHandler();
        a.assertTrue(processHandler != null);
        if (bl2) {
            javaDebugServerModeHandler.attachRemote();
            DebuggerManager.getInstance((Project)executionEnvironment.getProject()).addDebugProcessListener(processHandler, new DebugProcessListener(){

                public void processDetached(DebugProcess debugProcess, boolean bl2) {
                    try {
                        javaDebugServerModeHandler.detachRemote();
                    }
                    catch (ExecutionException executionException) {
                        a.info((Throwable)executionException);
                    }
                }
            });
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "executionEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "server";
                break;
            }
        }
        objectArray[1] = "com/intellij/remoteServer/impl/runtime/deployment/debug/JavaDebuggerLauncherImpl";
        objectArray[2] = "startDebugSession";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RemoteServerDebugEnvironment
    implements DebugEnvironment {
        private final Project b;
        private final GlobalSearchScope a;
        private final RemoteConnection c;
        private final RunProfile d;

        public RemoteServerDebugEnvironment(Project project2, RemoteConnection remoteConnection, RunProfile runProfile) {
            this.b = project2;
            this.a = SearchScopeProvider.createSearchScope((Project)project2, (RunProfile)runProfile);
            this.c = remoteConnection;
            this.d = runProfile;
        }

        @Override
        @Nullable
        public ExecutionResult createExecutionResult() throws ExecutionException {
            ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.b, false);
            RemoteDebugProcessHandler remoteDebugProcessHandler = new RemoteDebugProcessHandler(this.b);
            consoleViewImpl.attachToProcess((ProcessHandler)remoteDebugProcessHandler);
            return new DefaultExecutionResult((ExecutionConsole)consoleViewImpl, (ProcessHandler)remoteDebugProcessHandler);
        }

        @Override
        @NotNull
        public GlobalSearchScope getSearchScope() {
            GlobalSearchScope globalSearchScope = this.a;
            if (globalSearchScope == null) {
                RemoteServerDebugEnvironment.a(0);
            }
            return globalSearchScope;
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        @Override
        public RemoteConnection getRemoteConnection() {
            return this.c;
        }

        @Override
        public long getPollTimeout() {
            return 30000L;
        }

        @Override
        public String getSessionName() {
            return this.d.getName();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/debug/JavaDebuggerLauncherImpl$RemoteServerDebugEnvironment", "getSearchScope"));
        }
    }

    private static class RemoteServerDebugUIEnvironment
    implements DebugUIEnvironment {
        private final DebugEnvironment b;
        private final ExecutionEnvironment a;

        public RemoteServerDebugUIEnvironment(DebugEnvironment debugEnvironment, ExecutionEnvironment executionEnvironment) {
            this.b = debugEnvironment;
            this.a = executionEnvironment;
        }

        @Override
        public DebugEnvironment getEnvironment() {
            return this.b;
        }

        @Override
        @Nullable
        public RunContentDescriptor getReuseContent() {
            return this.a.getContentToReuse();
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.a.getRunProfile().getIcon();
        }

        @Override
        public void initActions(RunContentDescriptor runContentDescriptor, DefaultActionGroup defaultActionGroup) {
            defaultActionGroup.add((AnAction)new CloseAction(this.a.getExecutor(), runContentDescriptor, this.a.getProject()));
        }

        @Override
        @Nullable
        public RunProfile getRunProfile() {
            return this.a.getRunProfile();
        }
    }
}

