/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.process;

import com.google.common.net.HostAndPort;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.SshChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SshProcess<C extends SshChannel>
extends RemoteSshProcess {
    private static final Logger a = Logger.getInstance(SshProcess.class);
    private static final long b = 5000L;
    private boolean d;
    private long c;
    @NotNull
    private final C e;

    public SshProcess(@NotNull C c2) {
        if (c2 == null) {
            SshProcess.a(0);
        }
        this.d = false;
        this.e = c2;
    }

    @NotNull
    public C getChannel() {
        C c2 = this.e;
        if (c2 == null) {
            SshProcess.a(1);
        }
        return c2;
    }

    public InputStream getInputStream() {
        return this.getChannel().getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.getChannel().getOutputStream();
    }

    public boolean isDisconnected() {
        return this.getChannel().isClosed();
    }

    public int exitValue() {
        if (this.a()) {
            throw new IllegalThreadStateException();
        }
        return this.getChannel().getExitStatus();
    }

    private boolean a() {
        return this.getChannel().getExitStatus() < 0 && this.getChannel().isConnected();
    }

    public void destroy() {
        if (this.getChannel().isConnected()) {
            this.getChannel().disconnect();
        }
    }

    public int waitFor() throws InterruptedException {
        while (this.a()) {
            Thread.sleep(100L);
            if (!this.d || System.currentTimeMillis() - this.c <= 5000L) continue;
            a.warn("Remote process wasn't closed within timeout after Ctrl+C. Disconnecting.");
            this.destroy();
        }
        return this.exitValue();
    }

    public void addRemoteTunnel(int n2, String string, int n3) throws RemoteSdkException {
        try {
            this.e.getSshSession().addRemoteTunnel(n2, string, n3);
        }
        catch (SshTransportException sshTransportException) {
            throw new RemoteSdkException(sshTransportException.getMessage(), (Throwable)sshTransportException);
        }
    }

    public void addLocalTunnel(int n2, int n3) throws RemoteSdkException {
        try {
            this.e.getSshSession().addLocalTunnel(n2, this.e.getSshSession().getHost(), n3);
        }
        catch (SshTransportException sshTransportException) {
            throw new RemoteSdkException(sshTransportException.getMessage(), (Throwable)sshTransportException);
        }
    }

    @Nullable
    public HostAndPort getLocalTunnel(int n2) {
        return this.e.getLocalTunnel(n2);
    }

    public void removeLocalTunnel(int n2) throws RemoteSdkException {
        try {
            this.e.getSshSession().removeLocalTunnel(n2);
        }
        catch (SshTransportException sshTransportException) {
            throw new RemoteSdkException(sshTransportException.getMessage(), (Throwable)sshTransportException);
        }
    }

    public boolean sendCtrlC() {
        try {
            this.getOutputStream().write(3);
            this.getOutputStream().flush();
            this.d = true;
            this.c = System.currentTimeMillis();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @NotNull
    public SshSession getSession() {
        SshSession sshSession = this.e.getSshSession();
        if (sshSession == null) {
            SshProcess.a(2);
        }
        return sshSession;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/process/SshProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/process/SshProcess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChannel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSession";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

