/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.task.ArtifactBuildTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalProjectTaskRunner
extends ProjectTaskRunner {
    private static final Logger a = Logger.getInstance(InternalProjectTaskRunner.class);
    public static final Key<Object> EXECUTION_SESSION_ID_KEY = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY;

    public void run(@NotNull Project project2, @NotNull ProjectTaskContext projectTaskContext, @Nullable ProjectTaskNotification projectTaskNotification, @NotNull Collection<? extends ProjectTask> collection) {
        if (project2 == null) {
            InternalProjectTaskRunner.a(0);
        }
        if (projectTaskContext == null) {
            InternalProjectTaskRunner.a(1);
        }
        if (collection == null) {
            InternalProjectTaskRunner.a(2);
        }
        CompileStatusNotification compileStatusNotification = projectTaskNotification == null ? null : (bl2, n2, n3, compileContext) -> projectTaskNotification.finished(new ProjectTaskResult(bl2, n2, n3));
        Map<Class<? extends ProjectTask>, List<ProjectTask>> map = InternalProjectTaskRunner.groupBy(collection);
        InternalProjectTaskRunner.a(project2, projectTaskContext, compileStatusNotification, map);
        InternalProjectTaskRunner.a(project2, compileStatusNotification, map);
        InternalProjectTaskRunner.b(project2, projectTaskContext, compileStatusNotification, map);
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            InternalProjectTaskRunner.a(3);
        }
        return true;
    }

    public static Map<Class<? extends ProjectTask>, List<ProjectTask>> groupBy(@NotNull Collection<? extends ProjectTask> collection) {
        if (collection == null) {
            InternalProjectTaskRunner.a(4);
        }
        return collection.stream().collect(Collectors.groupingBy(projectTask -> {
            if (projectTask instanceof ModuleFilesBuildTask) {
                return ModuleFilesBuildTask.class;
            }
            if (projectTask instanceof ModuleBuildTask) {
                return ModuleBuildTask.class;
            }
            if (projectTask instanceof ArtifactBuildTask) {
                return ArtifactBuildTask.class;
            }
            return projectTask.getClass();
        }));
    }

    private static void a(@NotNull Project project2, @NotNull ProjectTaskContext projectTaskContext, @Nullable CompileStatusNotification compileStatusNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> map) {
        Collection collection;
        if (project2 == null) {
            InternalProjectTaskRunner.a(5);
        }
        if (projectTaskContext == null) {
            InternalProjectTaskRunner.a(6);
        }
        if (map == null) {
            InternalProjectTaskRunner.a(7);
        }
        if (ContainerUtil.isEmpty((Collection)(collection = (Collection)map.get(ModuleBuildTask.class)))) {
            return;
        }
        ModulesBuildSettings modulesBuildSettings = InternalProjectTaskRunner.a(collection);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        CompileScope compileScope = InternalProjectTaskRunner.a(compilerManager, projectTaskContext, modulesBuildSettings.modules, modulesBuildSettings.includeDependentModules, modulesBuildSettings.includeRuntimeDependencies);
        if (modulesBuildSettings.isIncrementalBuild) {
            compilerManager.make(compileScope, compileStatusNotification);
        } else {
            compilerManager.compile(compileScope, compileStatusNotification);
        }
    }

    private static ModulesBuildSettings a(Collection<? extends ProjectTask> collection) {
        boolean bl2;
        SmartList smartList = new SmartList();
        List list2 = ContainerUtil.newSmartList();
        List list3 = ContainerUtil.newSmartList();
        List list4 = ContainerUtil.newSmartList();
        for (ProjectTask projectTask : collection) {
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            smartList.add(moduleBuildTask.getModule());
            if (moduleBuildTask.isIncrementalBuild()) {
                list2.add(moduleBuildTask);
            }
            if (!moduleBuildTask.isIncludeDependentModules()) {
                list3.add(moduleBuildTask);
            }
            if (moduleBuildTask.isIncludeRuntimeDependencies()) continue;
            list4.add(moduleBuildTask);
        }
        boolean bl3 = list2.size() == collection.size();
        boolean bl4 = list3.size() != collection.size();
        boolean bl5 = bl2 = list4.size() != collection.size();
        if (!bl3 && !list2.isEmpty()) {
            InternalProjectTaskRunner.a(list2, "will be built ignoring incremental build setting");
        }
        if (bl4 && !list3.isEmpty()) {
            InternalProjectTaskRunner.a(list3, "will be built along with dependent modules");
        }
        if (bl2 && !list4.isEmpty()) {
            InternalProjectTaskRunner.a(list4, "will be built along with runtime dependencies");
        }
        return new ModulesBuildSettings(bl3, bl4, bl2, (Collection<Module>)smartList);
    }

    private static void a(Collection<ModuleBuildTask> collection, String string) {
        String string2 = StringUtil.join(collection, moduleBuildTask -> moduleBuildTask.getModule().getName(), (String)", ");
        a.warn("Module" + (collection.size() > 1 ? "s" : "") + " : '" + string2 + "' " + string);
    }

    private static CompileScope a(CompilerManager compilerManager, ProjectTaskContext projectTaskContext, Collection<Module> collection, boolean bl2, boolean bl3) {
        CompileScope compileScope = compilerManager.createModulesCompileScope(collection.toArray(Module.EMPTY_ARRAY), bl2, bl3);
        RunConfiguration runConfiguration = projectTaskContext.getRunConfiguration();
        if (runConfiguration != null) {
            compileScope.putUserData(CompilerManager.RUN_CONFIGURATION_KEY, (Object)runConfiguration);
            compileScope.putUserData(CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY, (Object)runConfiguration.getType().getId());
        }
        ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)compileScope, projectTaskContext.getSessionId());
        return compileScope;
    }

    private static void a(@NotNull Project project2, @Nullable CompileStatusNotification compileStatusNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> map) {
        Collection collection;
        if (project2 == null) {
            InternalProjectTaskRunner.a(8);
        }
        if (map == null) {
            InternalProjectTaskRunner.a(9);
        }
        if (!ContainerUtil.isEmpty((Collection)(collection = (Collection)map.get(ModuleFilesBuildTask.class)))) {
            VirtualFile[] virtualFileArray = (VirtualFile[])collection.stream().flatMap(projectTask -> Stream.of(((ModuleFilesBuildTask)ModuleFilesBuildTask.class.cast(projectTask)).getFiles())).toArray(VirtualFile[]::new);
            CompilerManager.getInstance((Project)project2).compile(virtualFileArray, compileStatusNotification);
        }
    }

    private static void b(@NotNull Project project2, @NotNull ProjectTaskContext projectTaskContext, @Nullable CompileStatusNotification compileStatusNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> map) {
        Collection collection;
        if (project2 == null) {
            InternalProjectTaskRunner.a(10);
        }
        if (projectTaskContext == null) {
            InternalProjectTaskRunner.a(11);
        }
        if (map == null) {
            InternalProjectTaskRunner.a(12);
        }
        if (!ContainerUtil.isEmpty((Collection)(collection = (Collection)map.get(ArtifactBuildTask.class)))) {
            SmartList smartList = new SmartList();
            SmartList smartList2 = new SmartList();
            for (ProjectTask projectTask : collection) {
                ArtifactBuildTask artifactBuildTask = (ArtifactBuildTask)projectTask;
                if (artifactBuildTask.isIncrementalBuild()) {
                    smartList.add(artifactBuildTask.getArtifact());
                    continue;
                }
                smartList2.add(artifactBuildTask.getArtifact());
            }
            InternalProjectTaskRunner.a(project2, (List<Artifact>)smartList, projectTaskContext.getSessionId(), compileStatusNotification, false);
            InternalProjectTaskRunner.a(project2, (List<Artifact>)smartList2, projectTaskContext.getSessionId(), compileStatusNotification, true);
        }
    }

    private static void a(@NotNull Project project2, @NotNull List<Artifact> list2, @Nullable Object object, @Nullable CompileStatusNotification compileStatusNotification, boolean bl2) {
        if (project2 == null) {
            InternalProjectTaskRunner.a(13);
        }
        if (list2 == null) {
            InternalProjectTaskRunner.a(14);
        }
        if (!list2.isEmpty()) {
            CompileScope compileScope = ArtifactCompileScope.createArtifactsScope(project2, list2, bl2);
            ArtifactsWorkspaceSettings.getInstance(project2).setArtifactsToBuild(list2);
            ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)compileScope, object);
            CompilerManager.getInstance((Project)project2).make(compileScope, compileStatusNotification);
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksMap";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/task/impl/InternalProjectTaskRunner";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "groupBy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runModulesBuildTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "runFilesBuildTasks";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "runArtifactsBuildTasks";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "buildArtifacts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ModulesBuildSettings {
        final boolean isIncrementalBuild;
        final boolean includeDependentModules;
        final boolean includeRuntimeDependencies;
        final Collection<Module> modules;

        public ModulesBuildSettings(boolean bl2, boolean bl3, boolean bl4, Collection<Module> collection) {
            this.isIncrementalBuild = bl2;
            this.includeDependentModules = bl3;
            this.includeRuntimeDependencies = bl4;
            this.modules = collection;
        }
    }
}

