/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtil;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.util.stream.LongStream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class CpuTimings {
    final long[] rawData;
    final long average;
    final double stdDev;
    final int attempt;

    private CpuTimings(long[] lArray, int n2) {
        this.rawData = lArray;
        this.attempt = n2;
        this.average = ArrayUtil.averageAmongMedians((long[])lArray, (int)2);
        this.stdDev = CpuTimings.a(lArray);
    }

    private static double a(long[] lArray) {
        double d2 = LongStream.of(lArray).mapToDouble(l2 -> l2).average().getAsDouble();
        double d3 = 0.0;
        for (long l3 : lArray) {
            d3 += Math.pow(d2 - (double)l3, 2.0);
        }
        return Math.sqrt(d3 / d2);
    }

    public String toString() {
        return this.average + ", sd=" + this.stdDev + ", attempt=" + this.attempt;
    }

    static CpuTimings calcStableCpuTiming() {
        int n2 = UsefulTestCase.IS_UNDER_TEAMCITY ? 100 : 10;
        int n3 = 0;
        while (true) {
            CpuTimings cpuTimings = CpuTimings.a(20, CpuTimings::b, n3);
            if (cpuTimings.stdDev < 1.8) {
                return cpuTimings;
            }
            if (n3 == n2) {
                System.out.printf("CPU Timings: %d, sd=%.2f; not stable enough, giving up%n", cpuTimings.average, cpuTimings.stdDev);
                return cpuTimings;
            }
            if (n3 > 3) {
                System.out.printf("CPU Timings: %d, sd=%.2f; unstable (getProcessCpuLoad() = %s; getSystemCpuLoad() = %s)%n", cpuTimings.average, cpuTimings.stdDev, CpuTimings.getProcessCpuLoad(), CpuTimings.getSystemCpuLoad());
            }
            System.gc();
            PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
            ++n3;
        }
    }

    private static CpuTimings a(int n2, Runnable runnable, int n3) {
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = System.currentTimeMillis();
            runnable.run();
            lArray[i2] = System.currentTimeMillis() - l2;
        }
        return new CpuTimings(lArray, n3);
    }

    private static void b() {
        BigInteger bigInteger = new BigInteger("1");
        for (int i2 = 0; i2 < 1000000; ++i2) {
            bigInteger = bigInteger.add(new BigInteger("1"));
        }
    }

    private static void a() {
        long l2 = 241L;
        for (int i2 = 0; i2 < 22222222; ++i2) {
            l2 = i2 % 10 == 3 ? l2 * 239L : l2 % 12342L;
        }
        CpuTimings.a(l2);
    }

    private static void a(long l2) {
        if (l2 % 2L == 0L) {
            throw new AssertionError((Object)"Should be an odd value");
        }
    }

    private static void c() {
        int n2;
        int[] nArray = new int[240000];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2 * 42 + 1;
        }
        n2 = 241;
        for (int i2 = 0; i2 < 5750000; ++i2) {
            n2 *= nArray[Math.abs(n2) % nArray.length];
        }
        CpuTimings.a(n2);
    }

    public static double getProcessCpuLoad() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList attributeList = mBeanServer.getAttributes(objectName, new String[]{"ProcessCpuLoad"});
            if (attributeList.isEmpty()) {
                return Double.NaN;
            }
            Attribute attribute = (Attribute)attributeList.get(0);
            Double d2 = (Double)attribute.getValue();
            if (d2 == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(d2 * 1000.0)) / 10.0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static double getSystemCpuLoad() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList attributeList = mBeanServer.getAttributes(objectName, new String[]{"SystemCpuLoad"});
            if (attributeList.isEmpty()) {
                return Double.NaN;
            }
            Attribute attribute = (Attribute)attributeList.get(0);
            Double d2 = (Double)attribute.getValue();
            if (d2 == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(d2 * 1000.0)) / 10.0;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void main(String[] stringArray) {
        for (int i2 = 0; i2 < 20; ++i2) {
        }
    }
}

