/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.CurrentEditorProvider;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class EditorTestUtil {
    public static final String CARET_TAG = "<caret>";
    public static final String CARET_TAG_PREFIX = "<caret>".substring(0, "<caret>".length() - 1);
    public static final String SELECTION_START_TAG = "<selection>";
    public static final String SELECTION_END_TAG = "</selection>";
    public static final String BLOCK_SELECTION_START_TAG = "<block>";
    public static final String BLOCK_SELECTION_END_TAG = "</block>";
    public static final char BACKSPACE_FAKE_CHAR = '\uffff';
    public static final char SMART_ENTER_FAKE_CHAR = '\ufffe';
    public static final char SMART_LINE_SPLIT_CHAR = '\ufffd';

    public static void performTypingAction(Editor editor, char c2) {
        EditorActionManager editorActionManager = EditorActionManager.getInstance();
        if (c2 == '\uffff') {
            EditorTestUtil.executeAction(editor, "EditorBackSpace");
        } else if (c2 == '\ufffe') {
            EditorTestUtil.executeAction(editor, "EditorCompleteStatement");
        } else if (c2 == '\ufffd') {
            EditorTestUtil.executeAction(editor, "EditorSplitLine");
        } else if (c2 == '\n') {
            EditorTestUtil.executeAction(editor, "EditorEnter");
        } else {
            TypedAction typedAction = editorActionManager.getTypedAction();
            typedAction.actionPerformed(editor, c2, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        }
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String string) {
        if (editor == null) {
            EditorTestUtil.a(0);
        }
        if (string == null) {
            EditorTestUtil.a(1);
        }
        EditorTestUtil.executeAction(editor, string, false);
    }

    public static void executeAction(@NotNull Editor editor, @NotNull String string, boolean bl2) {
        if (editor == null) {
            EditorTestUtil.a(2);
        }
        if (string == null) {
            EditorTestUtil.a(3);
        }
        ActionManagerEx actionManagerEx = ActionManagerEx.getInstanceEx();
        AnAction anAction = actionManagerEx.getAction(string);
        Assert.assertNotNull((Object)anAction);
        EditorTestUtil.executeAction(editor, bl2, anAction);
    }

    public static void executeAction(@NotNull Editor editor, boolean bl2, @NotNull AnAction anAction) {
        if (editor == null) {
            EditorTestUtil.a(4);
        }
        if (anAction == null) {
            EditorTestUtil.a(5);
        }
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction, null, (String)"", (DataContext)EditorTestUtil.a(editor));
        anAction.beforeActionPerformedUpdate(anActionEvent);
        if (!anActionEvent.getPresentation().isEnabled()) {
            Assert.assertFalse((String)("Action " + anAction + " is disabled"), (boolean)bl2);
            return;
        }
        ActionManagerEx actionManagerEx = ActionManagerEx.getInstanceEx();
        actionManagerEx.fireBeforeActionPerformed(anAction, anActionEvent.getDataContext(), anActionEvent);
        anAction.actionPerformed(anActionEvent);
        actionManagerEx.fireAfterActionPerformed(anAction, anActionEvent.getDataContext(), anActionEvent);
    }

    @NotNull
    private static DataContext a(@NotNull Editor editor) {
        if (editor == null) {
            EditorTestUtil.a(6);
        }
        Editor editor2 = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        Map map = ContainerUtil.newHashMap((Pair)Pair.create((Object)CommonDataKeys.HOST_EDITOR.getName(), (Object)editor2), (Pair[])new Pair[]{Pair.createNonNull((Object)CommonDataKeys.EDITOR.getName(), (Object)editor)});
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)editor.getContentComponent());
        DataContext dataContext2 = SimpleDataContext.getSimpleContext((Map)map, (DataContext)dataContext);
        if (dataContext2 == null) {
            EditorTestUtil.a(7);
        }
        return dataContext2;
    }

    public static void performReferenceCopy(Editor editor) {
        EditorTestUtil.executeAction(editor, "CopyReference", true);
    }

    public static void performPaste(Editor editor) {
        EditorTestUtil.executeAction(editor, "EditorPaste", true);
    }

    public static List<IElementType> getAllTokens(EditorHighlighter editorHighlighter) {
        ArrayList<IElementType> arrayList = new ArrayList<IElementType>();
        HighlighterIterator highlighterIterator = editorHighlighter.createIterator(0);
        while (!highlighterIterator.atEnd()) {
            arrayList.add(highlighterIterator.getTokenType());
            highlighterIterator.advance();
        }
        return arrayList;
    }

    public static int getCaretPosition(@NotNull String string) {
        if (string == null) {
            EditorTestUtil.a(8);
        }
        return EditorTestUtil.getCaretAndSelectionPosition(string)[0];
    }

    public static int[] getCaretAndSelectionPosition(@NotNull String string) {
        String string2;
        if (string == null) {
            EditorTestUtil.a(9);
        }
        int n2 = string.indexOf(CARET_TAG_PREFIX);
        int n3 = string.indexOf(">", n2);
        int n4 = n3 - n2;
        int n5 = 0;
        if (n2 >= 0 && (string2 = string.substring(n2 + CARET_TAG_PREFIX.length(), n3)).length() > 1) {
            n5 = Integer.parseInt(string2.substring(1));
        }
        int n6 = string.indexOf(SELECTION_START_TAG);
        int n7 = string.indexOf(SELECTION_END_TAG);
        if (n6 >= 0) {
            if (n2 >= 0) {
                if (n2 < n6) {
                    n6 -= n4;
                    n7 -= n4;
                } else {
                    n2 = n2 < n7 ? (n2 -= SELECTION_START_TAG.length()) : (n2 -= SELECTION_START_TAG.length() + SELECTION_END_TAG.length());
                }
            }
            n7 -= SELECTION_START_TAG.length();
        }
        return new int[]{n2, n5, n6, n7};
    }

    public static boolean configureSoftWraps(Editor editor, int n2) {
        int n3 = 10;
        return EditorTestUtil.configureSoftWraps(editor, (n2 + 1) * n3 + 1, n3);
    }

    public static boolean configureSoftWraps(Editor editor, int n2, final int n3) {
        editor.getSettings().setUseSoftWraps(true);
        SoftWrapModelImpl softWrapModelImpl = (SoftWrapModelImpl)editor.getSoftWrapModel();
        softWrapModelImpl.setSoftWrapPainter(new SoftWrapPainter(){

            public int paint(@NotNull Graphics graphics, @NotNull SoftWrapDrawingType softWrapDrawingType, int n2, int n32, int n4) {
                if (graphics == null) {
                    1.a(0);
                }
                if (softWrapDrawingType == null) {
                    1.a(1);
                }
                return n3;
            }

            public int getDrawingHorizontalOffset(@NotNull Graphics graphics, @NotNull SoftWrapDrawingType softWrapDrawingType, int n2, int n32, int n4) {
                if (graphics == null) {
                    1.a(2);
                }
                if (softWrapDrawingType == null) {
                    1.a(3);
                }
                return n3;
            }

            public int getMinDrawingWidth(@NotNull SoftWrapDrawingType softWrapDrawingType) {
                if (softWrapDrawingType == null) {
                    1.a(4);
                }
                return n3;
            }

            public boolean canUse() {
                return true;
            }

            public void reinit() {
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "drawingType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDrawingHorizontalOffset";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getMinDrawingWidth";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        softWrapModelImpl.reinitSettings();
        SoftWrapApplianceManager softWrapApplianceManager = softWrapModelImpl.getApplianceManager();
        softWrapApplianceManager.setWidthProvider(() -> n2);
        softWrapModelImpl.setEditorTextRepresentationHelper((EditorTextRepresentationHelper)new DefaultEditorTextRepresentationHelper(editor){

            public int charWidth(int n2, int n32) {
                return n3;
            }
        });
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, n2, 1000);
        softWrapApplianceManager.registerSoftWrapIfNecessary();
        return !softWrapModelImpl.getRegisteredSoftWraps().isEmpty();
    }

    public static void setEditorVisibleSize(Editor editor, int n2, int n3) {
        EditorTestUtil.setEditorVisibleSizeInPixels(editor, n2 * EditorUtil.getSpaceWidth((int)0, (Editor)editor), n3 * editor.getLineHeight());
    }

    public static void setEditorVisibleSizeInPixels(Editor editor, int n2, int n3) {
        Dimension dimension = new Dimension(n2, n3);
        ((EditorEx)editor).getScrollPane().getViewport().setExtentSize(dimension);
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(@NotNull Document document) {
        if (document == null) {
            EditorTestUtil.a(10);
        }
        CaretAndSelectionState caretAndSelectionState = EditorTestUtil.extractCaretAndSelectionMarkers(document, true);
        if (caretAndSelectionState == null) {
            EditorTestUtil.a(11);
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkers(final @NotNull Document document, final boolean bl2) {
        if (document == null) {
            EditorTestUtil.a(12);
        }
        CaretAndSelectionState caretAndSelectionState = (CaretAndSelectionState)new WriteCommandAction<CaretAndSelectionState>(null, new PsiFile[0]){

            public void run(@NotNull Result<CaretAndSelectionState> result2) {
                if (result2 == null) {
                    3.a(0);
                }
                result2.setResult((Object)EditorTestUtil.extractCaretAndSelectionMarkersImpl(document, bl2));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionResult", "com/intellij/testFramework/EditorTestUtil$3", "run"));
            }
        }.execute().getResultObject();
        if (caretAndSelectionState == null) {
            EditorTestUtil.a(13);
        }
        return caretAndSelectionState;
    }

    @NotNull
    public static CaretAndSelectionState extractCaretAndSelectionMarkersImpl(@NotNull Document document, boolean bl2) {
        int n2;
        int n3;
        if (document == null) {
            EditorTestUtil.a(14);
        }
        ArrayList arrayList = ContainerUtil.newArrayList();
        String string = document.getText();
        RangeMarker rangeMarker = null;
        RangeMarker rangeMarker2 = null;
        if (bl2) {
            n3 = string.indexOf(BLOCK_SELECTION_START_TAG);
            if ((n3 ^ (n2 = string.indexOf(BLOCK_SELECTION_END_TAG))) < 0) {
                throw new IllegalArgumentException("Both block selection opening and closing tag must be present");
            }
            if (n3 >= 0) {
                rangeMarker = document.createRangeMarker(n3, n3);
                rangeMarker2 = document.createRangeMarker(n2, n2);
                document.deleteString(rangeMarker.getStartOffset(), rangeMarker.getStartOffset() + BLOCK_SELECTION_START_TAG.length());
                document.deleteString(rangeMarker2.getStartOffset(), rangeMarker2.getStartOffset() + BLOCK_SELECTION_END_TAG.length());
            }
        }
        n3 = StringUtil.getOccurrenceCount((String)document.getText(), (String)CARET_TAG) > 1 || StringUtil.getOccurrenceCount((String)document.getText(), (String)SELECTION_START_TAG) > 1 ? 1 : 0;
        n2 = 0;
        while (n2 < document.getTextLength()) {
            RangeMarker rangeMarker3;
            int n4;
            string = document.getText();
            int n5 = string.indexOf(CARET_TAG, n2);
            int n6 = string.indexOf(SELECTION_START_TAG, n2);
            if ((n6 ^ (n4 = string.indexOf(SELECTION_END_TAG, n2))) < 0) {
                n6 = -1;
                n4 = -1;
            }
            if (0 <= n4 && n4 < n6) {
                throw new IllegalArgumentException("Wrong order of selection opening and closing tags");
            }
            if (n5 < 0 && n6 < 0 && n4 < 0) break;
            if (n3 != 0 && 0 <= n5 && n5 < n6) {
                n6 = -1;
                n4 = -1;
            }
            if (n3 != 0 && n5 > n4 && n4 >= 0) {
                n5 = -1;
            }
            RangeMarker rangeMarker4 = n5 >= 0 ? document.createRangeMarker(n5, n5) : null;
            RangeMarker rangeMarker5 = n6 >= 0 ? document.createRangeMarker(n6, n6) : null;
            RangeMarker rangeMarker6 = rangeMarker3 = n4 >= 0 ? document.createRangeMarker(n4, n4) : null;
            if (rangeMarker4 != null) {
                document.deleteString(rangeMarker4.getStartOffset(), rangeMarker4.getStartOffset() + CARET_TAG.length());
            }
            if (rangeMarker5 != null) {
                document.deleteString(rangeMarker5.getStartOffset(), rangeMarker5.getStartOffset() + SELECTION_START_TAG.length());
            }
            if (rangeMarker3 != null) {
                document.deleteString(rangeMarker3.getStartOffset(), rangeMarker3.getStartOffset() + SELECTION_END_TAG.length());
            }
            LogicalPosition logicalPosition = null;
            if (rangeMarker4 != null) {
                int n7 = document.getLineNumber(rangeMarker4.getStartOffset());
                int n8 = rangeMarker4.getStartOffset() - document.getLineStartOffset(n7);
                logicalPosition = new LogicalPosition(n7, n8);
            }
            arrayList.add(new CaretInfo(logicalPosition, rangeMarker5 == null || rangeMarker3 == null ? null : new TextRange(rangeMarker5.getStartOffset(), rangeMarker3.getEndOffset())));
            n2 = Math.max(rangeMarker4 == null ? -1 : rangeMarker4.getStartOffset(), rangeMarker3 == null ? -1 : rangeMarker3.getEndOffset());
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new CaretInfo(null, null));
        }
        TextRange textRange = null;
        if (rangeMarker != null) {
            textRange = new TextRange(rangeMarker.getStartOffset(), rangeMarker2.getStartOffset());
        }
        CaretAndSelectionState caretAndSelectionState = new CaretAndSelectionState(Arrays.asList(arrayList.toArray(new CaretInfo[0])), textRange);
        if (caretAndSelectionState == null) {
            EditorTestUtil.a(15);
        }
        return caretAndSelectionState;
    }

    public static void setCaretsAndSelection(Editor editor, CaretAndSelectionState caretAndSelectionState) {
        CaretModel caretModel = editor.getCaretModel();
        ArrayList<CaretState> arrayList = new ArrayList<CaretState>(caretAndSelectionState.carets.size());
        for (CaretInfo caretInfo : caretAndSelectionState.carets) {
            arrayList.add(new CaretState(caretInfo.position == null ? null : editor.offsetToLogicalPosition(caretInfo.getCaretOffset(editor.getDocument())), caretInfo.selection == null ? null : editor.offsetToLogicalPosition(caretInfo.selection.getStartOffset()), caretInfo.selection == null ? null : editor.offsetToLogicalPosition(caretInfo.selection.getEndOffset())));
        }
        caretModel.setCaretsAndSelections(arrayList);
        if (caretAndSelectionState.blockSelection != null) {
            editor.getSelectionModel().setBlockSelection(editor.offsetToLogicalPosition(caretAndSelectionState.blockSelection.getStartOffset()), editor.offsetToLogicalPosition(caretAndSelectionState.blockSelection.getEndOffset()));
        }
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretAndSelectionState) {
        EditorTestUtil.verifyCaretAndSelectionState(editor, caretAndSelectionState, null);
    }

    public static void verifyCaretAndSelectionState(Editor editor, CaretAndSelectionState caretAndSelectionState, String string) {
        CaretInfo caretInfo;
        boolean bl2 = false;
        for (int i2 = 0; i2 < caretAndSelectionState.carets.size(); ++i2) {
            caretInfo = caretAndSelectionState.carets.get(i2);
            if (caretInfo.position == null && caretInfo.selection == null) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return;
        }
        String string2 = string == null ? "" : string + ": ";
        caretInfo = editor.getCaretModel();
        ArrayList arrayList = new ArrayList(caretInfo.getAllCarets());
        Assert.assertEquals((String)(string2 + " Unexpected number of carets"), (long)caretAndSelectionState.carets.size(), (long)arrayList.size());
        for (int i3 = 0; i3 < caretAndSelectionState.carets.size(); ++i3) {
            String string3 = caretAndSelectionState.carets.size() == 1 ? "" : "caret " + (i3 + 1) + "/" + caretAndSelectionState.carets.size() + " ";
            Caret caret = (Caret)arrayList.get(i3);
            int n2 = editor.getDocument().getLineNumber(caret.getOffset());
            int n3 = caret.getOffset() - editor.getDocument().getLineStartOffset(n2);
            LogicalPosition logicalPosition = new LogicalPosition(n2, n3);
            int n4 = caret.getSelectionStart();
            int n5 = caret.getSelectionEnd();
            LogicalPosition logicalPosition2 = editor.offsetToLogicalPosition(n4);
            LogicalPosition logicalPosition3 = editor.offsetToLogicalPosition(n5);
            CaretInfo caretInfo2 = caretAndSelectionState.carets.get(i3);
            if (caretInfo2.position != null) {
                Assert.assertEquals((String)(string2 + string3 + "unexpected caret position"), (Object)caretInfo2.position, (Object)logicalPosition);
            }
            if (caretInfo2.selection != null) {
                LogicalPosition logicalPosition4 = editor.offsetToLogicalPosition(caretInfo2.selection.getStartOffset());
                LogicalPosition logicalPosition5 = editor.offsetToLogicalPosition(caretInfo2.selection.getEndOffset());
                Assert.assertEquals((String)(string2 + string3 + "unexpected selection start"), (Object)logicalPosition4, (Object)logicalPosition2);
                Assert.assertEquals((String)(string2 + string3 + "unexpected selection end"), (Object)logicalPosition5, (Object)logicalPosition3);
                continue;
            }
            Assert.assertFalse((String)(string2 + string3 + "should has no selection, but was: (" + logicalPosition2 + ", " + logicalPosition3 + ")"), (boolean)caret.hasSelection());
        }
    }

    public static FoldRegion addFoldRegion(@NotNull Editor editor, int n2, int n3, String string, boolean bl2) {
        if (editor == null) {
            EditorTestUtil.a(16);
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        Ref ref = new Ref();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion foldRegion = foldingModel.addFoldRegion(n2, n3, string);
            Assert.assertNotNull((Object)foldRegion);
            foldRegion.setExpanded(!bl2);
            ref.set((Object)foldRegion);
        });
        return (FoldRegion)ref.get();
    }

    public static Inlay addInlay(@NotNull Editor editor, int n2) {
        if (editor == null) {
            EditorTestUtil.a(17);
        }
        return EditorTestUtil.addInlay(editor, n2, false);
    }

    public static Inlay addInlay(@NotNull Editor editor, int n2, boolean bl2) {
        if (editor == null) {
            EditorTestUtil.a(18);
        }
        return editor.getInlayModel().addInlineElement(n2, bl2, new EditorCustomElementRenderer(){

            public int calcWidthInPixels(@NotNull Editor editor) {
                if (editor == null) {
                    4.a(0);
                }
                return 1;
            }

            public void paint(@NotNull Editor editor, @NotNull Graphics graphics, @NotNull Rectangle rectangle, @NotNull TextAttributes textAttributes) {
                if (editor == null) {
                    4.a(1);
                }
                if (graphics == null) {
                    4.a(2);
                }
                if (rectangle == null) {
                    4.a(3);
                }
                if (textAttributes == null) {
                    4.a(4);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "g";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "r";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "textAttributes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil$4";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "calcWidthInPixels";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void waitForLoading(Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editor == null) {
            return;
        }
        while (!AsyncEditorLoader.isEditorLoaded((Editor)editor)) {
            LockSupport.parkNanos(100000000L);
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testUndoInEditor(@NotNull Editor editor, @NotNull Runnable runnable) {
        if (editor == null) {
            EditorTestUtil.a(19);
        }
        if (runnable == null) {
            EditorTestUtil.a(20);
        }
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        Project project2 = editor.getProject();
        Assert.assertNotNull((Object)project2);
        UndoManagerImpl undoManagerImpl = (UndoManagerImpl)UndoManager.getInstance((Project)project2);
        CurrentEditorProvider currentEditorProvider = undoManagerImpl.getEditorProvider();
        undoManagerImpl.setEditorProvider(() -> EditorTestUtil.a((FileEditor)textEditor));
        try {
            runnable.run();
        }
        finally {
            undoManagerImpl.setEditorProvider(currentEditorProvider);
        }
    }

    private static /* synthetic */ FileEditor a(FileEditor fileEditor) {
        return fileEditor;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/EditorTestUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/EditorTestUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorContext";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCaretAndSelectionMarkers";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCaretAndSelectionMarkersImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditorContext";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCaretPosition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAndSelectionPosition";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkers";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractCaretAndSelectionMarkersImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFoldRegion";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addInlay";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "testUndoInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CaretInfo {
        @Nullable
        public final LogicalPosition position;
        @Nullable
        public final TextRange selection;

        public CaretInfo(@Nullable LogicalPosition logicalPosition, @Nullable TextRange textRange) {
            this.position = logicalPosition;
            this.selection = textRange;
        }

        public int getCaretOffset(Document document) {
            return this.position == null ? -1 : document.getLineStartOffset(this.position.line) + this.position.column;
        }
    }

    public static class CaretAndSelectionState {
        public final List<CaretInfo> carets;
        public final TextRange blockSelection;

        public CaretAndSelectionState(List<CaretInfo> list2, @Nullable TextRange textRange) {
            this.carets = list2;
            this.blockSelection = textRange;
        }

        public boolean hasExplicitCaret() {
            if (this.carets.isEmpty()) {
                return false;
            }
            if (this.blockSelection == null && this.carets.size() == 1) {
                CaretInfo caretInfo = this.carets.get(0);
                return caretInfo.position != null || caretInfo.selection != null;
            }
            return true;
        }
    }
}

