/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.ref.DebugReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeakHunter {
    public static void checkProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, projectImpl -> !projectImpl.isDefault() && !projectImpl.isLight());
    }

    public static void checkNonDefaultProjectLeak() {
        LeakHunter.checkLeak(LeakHunter.allRoots(), ProjectImpl.class, projectImpl -> !projectImpl.isDefault());
    }

    public static void checkLeak(@NotNull Object object, @NotNull Class<?> clazz) throws AssertionError {
        if (object == null) {
            LeakHunter.a(0);
        }
        if (clazz == null) {
            LeakHunter.a(1);
        }
        LeakHunter.checkLeak(object, clazz, null);
    }

    public static <T> void checkLeak(@NotNull Map<Object, String> map, @NotNull Class<T> clazz, @Nullable Condition<? super T> condition) throws AssertionError {
        if (map == null) {
            LeakHunter.a(2);
        }
        if (clazz == null) {
            LeakHunter.a(3);
        }
        LeakHunter.processLeaks(map, clazz, condition, (object, object2) -> {
            String string = object instanceof Project ? PlatformTestCase.getCreationPlace((Project)object) : "";
            String string2 = "Found leaked " + object.getClass() + ": " + object + "; hash: " + System.identityHashCode(object) + "; place: " + string + "\n" + object2;
            System.out.println(string2);
            System.out.println(";-----");
            UsefulTestCase.printThreadDump();
            throw new AssertionError((Object)string2);
        });
    }

    static <T> void processLeaks(@NotNull Map<Object, String> map, @NotNull Class<T> clazz, @Nullable Condition<? super T> condition, @NotNull PairProcessor<? super T, Object> pairProcessor) throws AssertionError {
        if (map == null) {
            LeakHunter.a(4);
        }
        if (clazz == null) {
            LeakHunter.a(5);
        }
        if (pairProcessor == null) {
            LeakHunter.a(6);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumeratorBase.clearCacheForTests();
        LaterInvocator.purgeExpiredItems();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (map == null) {
                LeakHunter.a(10);
            }
            if (clazz == null) {
                LeakHunter.a(11);
            }
            if (pairProcessor == null) {
                LeakHunter.a(12);
            }
            try (AccessToken accessToken = ProhibitAWTEvents.start((String)"checking for leaks");){
                DebugReflectionUtil.walkObjects((int)10000, (Map)map, (Class)clazz, (Condition)Conditions.alwaysTrue(), (object, backLink) -> {
                    if (pairProcessor == null) {
                        LeakHunter.a(13);
                    }
                    Object object2 = object;
                    if (condition == null || condition.value(object2)) {
                        return pairProcessor.process(object2, backLink);
                    }
                    return true;
                });
            }
        });
    }

    public static <T> void checkLeak(@NotNull Object object, @NotNull Class<T> clazz, @Nullable Condition<? super T> condition) throws AssertionError {
        if (object == null) {
            LeakHunter.a(7);
        }
        if (clazz == null) {
            LeakHunter.a(8);
        }
        LeakHunter.checkLeak(Collections.singletonMap(object, "Root object"), clazz, condition);
    }

    @NotNull
    public static Map<Object, String> allRoots() {
        ClassLoader classLoader = LeakHunter.class.getClassLoader();
        Vector vector = (Vector)ReflectionUtil.getField(classLoader.getClass(), (Object)classLoader, Vector.class, (String)"classes");
        IdentityHashMap<Object, String> identityHashMap = new IdentityHashMap<Object, String>();
        identityHashMap.put(ApplicationManager.getApplication(), "ApplicationManager.getApplication()");
        identityHashMap.put(Disposer.getTree(), "Disposer.getTree()");
        identityHashMap.put(IdeEventQueue.getInstance(), "IdeEventQueue.getInstance()");
        identityHashMap.put(LaterInvocator.getLaterInvocatorQueue(), "LaterInvocator.getLaterInvocatorQueue()");
        identityHashMap.put(ThreadTracker.getThreads(), "all live threads");
        identityHashMap.put(vector, "all loaded classes statics");
        IdentityHashMap<Object, String> identityHashMap2 = identityHashMap;
        if (identityHashMap2 == null) {
            LeakHunter.a(9);
        }
        return identityHashMap2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspectClass";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LeakHunter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LeakHunter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "allRoots";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkLeak";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processLeaks";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processLeaks$4";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

