/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(@NonNls String string) {
        this.doTest(string, null);
    }

    protected void doTest(@NonNls String string, @Nullable String string2) {
        this.doTest(string, string2, this.createLexer());
    }

    protected void doTest(@NonNls String string, @Nullable String string2, @NotNull Lexer lexer) {
        if (lexer == null) {
            LexerTestCase.b(0);
        }
        String string3 = LexerTestCase.printTokens(string, 0, lexer);
        if (string2 != null) {
            LexerTestCase.assertSameLines(string2, string3);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), string3);
        }
    }

    @NotNull
    protected String getPathToTestDataFile(String string) {
        String string2 = PathManager.getHomePath() + "/" + this.getDirPath() + "/" + this.getTestName(true) + string;
        if (string2 == null) {
            LexerTestCase.b(1);
        }
        return string2;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        if (".txt" == null) {
            LexerTestCase.b(2);
        }
        return ".txt";
    }

    protected void checkZeroState(String string, TokenSet tokenSet) {
        IElementType iElementType;
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)string);
        while ((iElementType = lexer.getTokenType()) != null) {
            if (tokenSet.contains(iElementType) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + iElementType + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected void checkCorrectRestart(String string) {
        IElementType iElementType;
        Lexer lexer = this.createLexer();
        String string2 = LexerTestCase.printTokens(string, 0, lexer);
        Lexer lexer2 = this.createLexer();
        lexer2.start((CharSequence)string);
        while ((iElementType = lexer2.getTokenType()) != null) {
            int n2;
            String string3;
            if (lexer2.getState() == 0 && !string2.endsWith(string3 = LexerTestCase.printTokens(string, n2 = lexer2.getTokenStart(), lexer))) {
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + n2 + "; lexer state should not return 0 at this point"), (String)string2, (String)string3);
            }
            lexer2.advance();
        }
    }

    protected String printTokens(String string, int n2) {
        return LexerTestCase.printTokens(string, n2, this.createLexer());
    }

    public static String printTokens(CharSequence charSequence, int n2, Lexer lexer) {
        IElementType iElementType;
        lexer.start(charSequence, n2, charSequence.length());
        StringBuilder stringBuilder = new StringBuilder();
        while ((iElementType = lexer.getTokenType()) != null) {
            stringBuilder.append(LexerTestCase.printSingleToken(charSequence, iElementType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator highlighterIterator) {
        if (highlighterIterator == null) {
            LexerTestCase.b(3);
        }
        CharSequence charSequence = highlighterIterator.getDocument().getCharsSequence();
        StringBuilder stringBuilder = new StringBuilder();
        while (!highlighterIterator.atEnd()) {
            IElementType iElementType = highlighterIterator.getTokenType();
            stringBuilder.append(LexerTestCase.printSingleToken(charSequence, iElementType, highlighterIterator.getStart(), highlighterIterator.getEnd()));
            highlighterIterator.advance();
        }
        String string = stringBuilder.toString();
        if (string == null) {
            LexerTestCase.b(4);
        }
        return string;
    }

    public static String printSingleToken(CharSequence charSequence, IElementType iElementType, int n2, int n3) {
        return iElementType + " ('" + LexerTestCase.a(iElementType, charSequence, n2, n3) + "')\n";
    }

    protected void doFileTest(@NonNls String string) {
        this.doTest(this.loadTestDataFile("." + string));
    }

    @NotNull
    protected String loadTestDataFile(@NonNls String string) {
        String string2 = this.getPathToTestDataFile(string);
        String string3 = "";
        try {
            String string4 = FileUtil.loadFile((File)new File(string2));
            string3 = StringUtil.convertLineSeparators((String)(this.shouldTrim() ? string4.trim() : string4));
        }
        catch (IOException iOException) {
            LexerTestCase.fail((String)("can't load file " + string2 + ": " + iOException.getMessage()));
        }
        String string5 = string3;
        if (string5 == null) {
            LexerTestCase.b(5);
        }
        return string5;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String a(IElementType iElementType, CharSequence charSequence, int n2, int n3) {
        if (iElementType instanceof TokenWrapper) {
            String string = ((TokenWrapper)iElementType).getValue();
            if (string == null) {
                LexerTestCase.b(6);
            }
            return string;
        }
        String string = StringUtil.replace((String)charSequence.subSequence(n2, n3).toString(), (String)"\n", (String)"\\n");
        if (string == null) {
            LexerTestCase.b(7);
        }
        return string;
    }

    protected abstract Lexer createLexer();

    protected abstract String getDirPath();

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToTestDataFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFileExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "printTokens";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestDataFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "printTokens";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

