/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.text.AsyncHighlighterUpdater;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static IdeaTestApplication k;
    private static boolean n;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected static final Collection<File> myFilesToDelete;
    protected boolean myAssertionsInTestDetected;
    public static Thread ourTestThread;
    private static TestCase r;
    private static final long l = 300L;
    public static long ourTestTime;
    private EditorListenerTracker p;
    private ThreadTracker q;
    private static boolean t;
    private static Set<VirtualFile> s;
    private SdkLeakTracker u;
    private VirtualFilePointerTracker m;
    private static final String[] o;

    public static void synchronizeTempDirVfs(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PlatformTestCase.b(0);
        }
        virtualFile.getChildren();
        virtualFile.refresh(false, true);
    }

    protected void initApplication() throws Exception {
        boolean bl2 = k == null;
        k = IdeaTestApplication.getInstance(null);
        k.setDataProvider(this);
        if (bl2) {
            PlatformTestCase.x();
        }
        this.u = new SdkLeakTracker();
    }

    public static void doAutodetectPlatformPrefix() {
        if (t) {
            return;
        }
        for (String string : o) {
            String string2 = string != null ? "META-INF/" + string + "Plugin.xml" : "idea/ApplicationInfo.xml";
            URL uRL = PlatformTestCase.class.getClassLoader().getResource(string2);
            if (uRL == null) continue;
            if (string == null) break;
            PlatformTestCase.a(string);
            break;
        }
    }

    private static void x() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    @Override
    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            CodeStyleSettings codeStyleSettings = new CodeStyleSettings();
            if (codeStyleSettings == null) {
                PlatformTestCase.b(1);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)this.getProject());
        if (codeStyleSettings == null) {
            PlatformTestCase.b(2);
        }
        return codeStyleSettings;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File file = new File(FileUtilRt.getTempDirectory());
        myFilesToDelete.add(file);
        if (r != null) {
            String string = "Previous test " + r + " hasn't called tearDown(). Probably overridden without super call.";
            r = null;
            PlatformTestCase.fail((String)string);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        if (this.u == null) {
            this.u = new SdkLeakTracker();
        }
        this.p = new EditorListenerTracker();
        this.q = new ThreadTracker();
        this.setUpProject();
        this.storeSettings();
        r = this;
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            CodeStyle.setTemporarySettings((Project)this.myProject, (CodeStyleSettings)new CodeStyleSettings());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).clearUncommittedDocuments();
        }
        UIUtil.dispatchAllInvocationEvents();
        this.m = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        PlatformTestCase.assertNotNull((String)"Cannot instantiate ProjectManager component", (Object)this.myProjectManager);
        this.myProject = this.doCreateProject(this.getProjectDirOrFile());
        this.myProjectManager.openTestProject(this.myProject);
        LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        this.setUpModule();
        this.setUpJdk();
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        this.runStartupActivities();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected Project doCreateProject(@NotNull Path path) throws Exception {
        if (path == null) {
            PlatformTestCase.b(3);
        }
        return PlatformTestCase.createProject(path.toFile(), ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }

    @NotNull
    public static Project createProject(File file, @NotNull String string) {
        if (string == null) {
            PlatformTestCase.b(4);
        }
        Project project2 = PlatformTestCase.createProject(file.getPath(), string);
        if (project2 == null) {
            PlatformTestCase.b(5);
        }
        return project2;
    }

    @NotNull
    public static Project createProject(@NotNull String string, @NotNull String string2) {
        Project project2;
        if (string == null) {
            PlatformTestCase.b(6);
        }
        if (string2 == null) {
            PlatformTestCase.b(7);
        }
        String string3 = PathUtilRt.getFileName((String)string);
        try {
            String string4 = FileUtilRt.getNameWithoutExtension((String)string3);
            Project project3 = ProjectManagerEx.getInstanceEx().newProject(string4, string, false, false);
            assert (project3 != null);
            project3.putUserData(CREATION_PLACE, (Object)string2);
            project2 = project3;
        }
        catch (TooManyProjectLeakedException tooManyProjectLeakedException) {
            Object object2;
            if (n) {
                PlatformTestCase.fail((String)"Too many projects leaked, again.");
                if (null == null) {
                    PlatformTestCase.b(9);
                }
                return null;
            }
            n = true;
            TIntHashSet tIntHashSet = new TIntHashSet();
            for (Object object2 : tooManyProjectLeakedException.getLeakedProjects()) {
                tIntHashSet.add(System.identityHashCode(object2));
            }
            String string5 = PathManager.getHomePath() + "/leakedProjects.hprof.zip";
            System.out.println("##teamcity[publishArtifacts 'leakedProjects.hprof.zip']");
            try {
                FileUtil.delete((File)new File(string5));
                MemoryDumpHelper.captureMemoryDumpZipped((String)string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Too many projects leaked: \n");
            LeakHunter.processLeaks(LeakHunter.allRoots(), ProjectImpl.class, projectImpl -> tIntHashSet.contains(System.identityHashCode(projectImpl)), (arg_0, arg_1) -> PlatformTestCase.a((StringBuilder)object2, tIntHashSet, arg_0, arg_1));
            PlatformTestCase.fail((String)(object2 + "\nPlease see '" + (String)string5 + "' for a memory dump"));
            if (null == null) {
                PlatformTestCase.b(10);
            }
            return null;
        }
        if (project2 == null) {
            PlatformTestCase.b(8);
        }
        return project2;
    }

    @NotNull
    public static String getCreationPlace(@NotNull Project project2) {
        String string;
        if (project2 == null) {
            PlatformTestCase.b(11);
        }
        String string2 = (String)project2.getUserData(CREATION_PLACE);
        try {
            string = project2.isDisposed() ? "" : project2.getBaseDir();
        }
        catch (Exception exception) {
            string = " (" + exception + " while getting base dir)";
        }
        String string3 = project2 + (string2 != null ? string2 : "") + string;
        if (string3 == null) {
            PlatformTestCase.b(12);
        }
        return string3;
    }

    protected void runStartupActivities() {
        StartupManagerImpl startupManagerImpl = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        startupManagerImpl.runStartupActivities();
        startupManagerImpl.startCacheUpdate();
        startupManagerImpl.runPostStartupActivities();
    }

    @NotNull
    protected Path getProjectDirOrFile() {
        Path path = this.getProjectDirOrFile(false);
        if (path == null) {
            PlatformTestCase.b(13);
        }
        return path;
    }

    protected boolean isCreateProjectFileExplicitly() {
        return true;
    }

    @NotNull
    protected final Path getProjectDirOrFile(boolean bl2) {
        if (!bl2 && this.isCreateProjectFileExplicitly()) {
            Path path;
            try {
                File file = FileUtil.createTempFile((String)this.getName(), (String)".ipr");
                myFilesToDelete.add(file);
                path = file.toPath();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (path == null) {
                PlatformTestCase.b(14);
            }
            return path;
        }
        Path path = TemporaryDirectoryKt.generateTemporaryPath(FileUtil.sanitizeFileName((String)this.getName(), (boolean)false) + (bl2 ? "" : ".ipr"));
        myFilesToDelete.add(path.toFile());
        Path path2 = path;
        if (path2 == null) {
            PlatformTestCase.b(15);
        }
        return path2;
    }

    protected void setUpModule() {
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                PlatformTestCase.this.myModule = PlatformTestCase.this.createMainModule();
            }
        }.execute().throwException();
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        Module module2 = this.createModule(this.myProject.getName());
        if (module2 == null) {
            PlatformTestCase.b(16);
        }
        return module2;
    }

    @NotNull
    protected Module createModule(@NonNls String string) {
        Module module2 = this.doCreateRealModule(string);
        if (module2 == null) {
            PlatformTestCase.b(17);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModule(String string) {
        Module module2 = this.doCreateRealModuleIn(string, this.myProject, this.getModuleType());
        if (module2 == null) {
            PlatformTestCase.b(18);
        }
        return module2;
    }

    @NotNull
    protected Module doCreateRealModuleIn(@NotNull String string, @NotNull Project project2, ModuleType moduleType) {
        if (string == null) {
            PlatformTestCase.b(19);
        }
        if (project2 == null) {
            PlatformTestCase.b(20);
        }
        Module module2 = this.createModuleAt(string, project2, moduleType, Objects.requireNonNull(project2.getBasePath()));
        if (module2 == null) {
            PlatformTestCase.b(21);
        }
        return module2;
    }

    @NotNull
    protected Module createModuleAt(final @NotNull String string, final @NotNull Project project2, final ModuleType moduleType, final @NotNull String string2) {
        if (string == null) {
            PlatformTestCase.b(22);
        }
        if (project2 == null) {
            PlatformTestCase.b(23);
        }
        if (string2 == null) {
            PlatformTestCase.b(24);
        }
        if (this.isCreateProjectFileExplicitly()) {
            final File file = new File(FileUtil.toSystemDependentName((String)string2), string + ".iml");
            FileUtil.createIfDoesntExist((File)file);
            myFilesToDelete.add(file);
            Module module2 = (Module)new WriteAction<Module>(){

                protected void run(@NotNull Result<Module> result2) {
                    if (result2 == null) {
                        2.a(0);
                    }
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                    TestCase.assertNotNull((Object)virtualFile);
                    Module module2 = ModuleManager.getInstance((Project)project2).newModule(virtualFile.getPath(), moduleType.getId());
                    module2.getModuleFile();
                    result2.setResult((Object)module2);
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$2", "run"));
                }
            }.execute().getResultObject();
            if (module2 == null) {
                PlatformTestCase.b(25);
            }
            return module2;
        }
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Module module3 = (Module)new WriteAction<Module>(){

            protected void run(@NotNull Result<Module> result2) {
                if (result2 == null) {
                    3.a(0);
                }
                result2.setResult((Object)moduleManager.newModule(string2 + File.separatorChar + string + ".iml", moduleType.getId()));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$3", "run"));
            }
        }.execute().getResultObject();
        if (module3 == null) {
            PlatformTestCase.b(26);
        }
        return module3;
    }

    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(Project project2) {
        Project project3;
        UndoManagerImpl undoManagerImpl = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (undoManagerImpl != null) {
            undoManagerImpl.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        assert (projectManager != null) : "The ProjectManager is not initialized yet";
        ProjectManagerImpl projectManagerImpl = (ProjectManagerImpl)projectManager;
        if (projectManagerImpl.isDefaultProjectInitialized()) {
            project3 = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project3)).cleanupForNextTest();
        }
        AsyncHighlighterUpdater.completeAsyncTasks();
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).cleanupForNextTest();
        project3 = (LocalFileSystemImpl)LocalFileSystem.getInstance();
        if (project3 != null) {
            project3.cleanupForNextTest();
        }
    }

    private static Set<VirtualFile> C() {
        if (s != null) {
            return s;
        }
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        for (IndexableSetContributor indexableSetContributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile virtualFile : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)indexableSetContributor)) {
                PlatformTestCase.a(hashSet, virtualFile);
            }
        }
        s = hashSet;
        return hashSet;
    }

    public static void addSurvivingFiles(@NotNull Collection<VirtualFile> collection) {
        if (collection == null) {
            PlatformTestCase.b(27);
        }
        for (VirtualFile virtualFile : collection) {
            PlatformTestCase.a(PlatformTestCase.C(), virtualFile);
        }
    }

    private static void a(Set<VirtualFile> set, VirtualFile virtualFile) {
        PlatformTestCase.a(virtualFile, set);
        while (virtualFile != null && set.add(virtualFile)) {
            virtualFile = virtualFile.getParent();
        }
    }

    private static void a(VirtualFile virtualFile, Set<VirtualFile> set) {
        if (virtualFile instanceof VirtualDirectoryImpl) {
            for (VirtualFile virtualFile2 : ((VirtualDirectoryImpl)virtualFile).getCachedChildren()) {
                if (!(virtualFile2 instanceof VirtualDirectoryImpl)) continue;
                set.add(virtualFile2);
                PlatformTestCase.a(virtualFile2, set);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            AutoPopupController.getInstance((Project)project2).cancelAllRequests();
        }
        new RunAll(new ThrowableRunnable[0]).append(() -> this.disposeRootDisposable()).append(() -> {
            if (project2 != null) {
                LightPlatformTestCase.doTearDown(project2, k);
            }
        }).append(() -> this.o()).append(() -> UIUtil.dispatchAllInvocationEvents()).append(() -> this.checkForSettingsDamage()).append(() -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }).append(() -> {
            ((JarFileSystemImpl)JarFileSystem.getInstance()).cleanupForNextTest();
            for (File file : myFilesToDelete) {
                this.a(file);
            }
            LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        }).append(() -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> super.tearDown()).append(() -> {
            if (this.p != null) {
                this.p.checkListenersLeak();
            }
        }).append(() -> {
            if (this.q != null) {
                this.q.checkLeak();
            }
        }).append(() -> LightPlatformTestCase.checkEditorsReleased()).append(() -> this.u.checkForJdkTableLeaks()).append(() -> this.m.assertPointersAreDisposed()).append(() -> {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            myFilesToDelete.clear();
            this.p = null;
            this.q = null;
            r = null;
        }).run();
    }

    private void o() {
        if (this.myProject != null) {
            PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(this.myProject);
            this.myProject = null;
        }
    }

    public static void closeAndDisposeProjectAndCheckThatNoOpenProjects(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestCase.b(28);
        }
        RunAll runAll = new RunAll(new ThrowableRunnable[0]);
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        if (projectManagerEx instanceof ProjectManagerImpl) {
            for (Project project3 : projectManagerEx.closeTestProject(project2)) {
                runAll = runAll.append(() -> {
                    throw new IllegalStateException("Test project is not disposed: " + project3 + ";\n created in: " + PlatformTestCase.getCreationPlace(project3));
                }).append(() -> ((ProjectManagerImpl)projectManagerEx).forceCloseProject(project3, true));
            }
        }
        runAll.append(() -> {
            if (project2 == null) {
                PlatformTestCase.b(72);
            }
            WriteAction.run(() -> {
                if (project2 == null) {
                    PlatformTestCase.b(73);
                }
                Disposer.dispose((Disposable)project2);
            });
        }).run();
    }

    protected void resetAllFields() {
        this.a(((Object)((Object)this)).getClass());
    }

    @Override
    protected final <T extends Disposable> T disposeOnTearDown(T t2) {
        Disposer.register((Disposable)this.myProject, t2);
        return t2;
    }

    private void a(Class<?> clazz) {
        try {
            PlatformTestCase.clearDeclaredFields((Object)this, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error((Throwable)illegalAccessException);
        }
        if (clazz == PlatformTestCase.class) {
            return;
        }
        this.a(clazz.getSuperclass());
    }

    private String u() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    private void a(File file) {
        boolean bl2 = FileUtil.delete((File)file);
        if (!bl2 && file.exists() && !this.myAssertionsInTestDetected) {
            PlatformTestCase.fail((String)("Can't delete " + file.getAbsolutePath() + " in " + this.u()));
        }
    }

    protected void setUpJdk() {
        Module[] moduleArray;
        Sdk sdk = this.getTestProjectJdk();
        for (Module module2 : moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)sdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.q();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
                    PlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                }));
            }
            catch (Throwable throwable) {}
        }
    }

    private void q() throws Throwable {
        ThrowableRunnable throwableRunnable = () -> {
            ourTestThread = Thread.currentThread();
            ourTestTime = 300L;
            try {
                try {
                    this.myAssertionsInTestDetected = true;
                    this.setUp();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable throwable) {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                Throwable throwable = null;
                try {
                    this.myAssertionsInTestDetected = true;
                    this.runTest();
                    this.myAssertionsInTestDetected = false;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                }
                finally {
                    block20: {
                        try {
                            this.tearDown();
                        }
                        catch (Throwable throwable4) {
                            if (throwable != null) break block20;
                            throwable = throwable4;
                        }
                    }
                }
                if (throwable != null) {
                    throw throwable;
                }
            }
            finally {
                ourTestThread = null;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)throwableRunnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        PlatformTestCase.B();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void B() throws InterruptedException, InvocationTargetException {
        for (int i2 = 0; i2 < 3; ++i2) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(ThrowableRunnable<Throwable> throwableRunnable) throws Throwable {
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(throwableRunnable);
        } else {
            throwableRunnable.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            PlatformTestCase.b(29);
        }
        Exception[] exceptionArray = new Exception[1];
        Runnable runnable2 = () -> {
            if (runnable == null) {
                PlatformTestCase.b(71);
            }
            try {
                if (ApplicationManager.getApplication().isDispatchThread() && this.isRunInWriteAction()) {
                    ApplicationManager.getApplication().runWriteAction(runnable);
                } else {
                    runnable.run();
                }
            }
            catch (Exception exception) {
                exceptionArray[0] = exception;
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, "", null);
        } else {
            runnable2.run();
        }
        if (exceptionArray[0] != null) {
            throw exceptionArray[0];
        }
    }

    public Object getData(String string) {
        return this.myProject == null ? null : new TestDataProvider(this.myProject).getData(string);
    }

    @NotNull
    public static File createTempDir(@NonNls String string) throws IOException {
        File file = PlatformTestCase.createTempDir(string, true);
        if (file == null) {
            PlatformTestCase.b(30);
        }
        return file;
    }

    @NotNull
    public static File createTempDir(@NonNls String string, boolean bl2) throws IOException {
        File file = FileUtilRt.createTempDirectory((String)("idea_test_" + string), null, (boolean)false);
        myFilesToDelete.add(file);
        if (bl2) {
            PlatformTestCase.getVirtualFile(file);
        }
        File file2 = file;
        if (file2 == null) {
            PlatformTestCase.b(31);
        }
        return file2;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file) {
        if (file == null) {
            PlatformTestCase.b(32);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @NotNull
    protected File createTempDirectory() throws IOException {
        File file = PlatformTestCase.createTempDir("");
        if (file == null) {
            PlatformTestCase.b(33);
        }
        return file;
    }

    @NotNull
    protected File createTempDirectory(boolean bl2) throws IOException {
        File file = PlatformTestCase.createTempDir("", bl2);
        if (file == null) {
            PlatformTestCase.b(34);
        }
        return file;
    }

    @NotNull
    protected File createTempFile(@NotNull String string, @Nullable String string2) throws IOException {
        File file;
        File file2;
        if (string == null) {
            PlatformTestCase.b(35);
        }
        if (!(file2 = new File(file = this.createTempDirectory(), string)).createNewFile()) {
            throw new IOException("Can't create " + file2);
        }
        if (string2 != null) {
            FileUtil.writeToFile((File)file2, (String)string2);
        }
        File file3 = file2;
        if (file3 == null) {
            PlatformTestCase.b(36);
        }
        return file3;
    }

    public static void setContentOnDisk(@NotNull File file, @Nullable byte[] byArray, @NotNull String string, @NotNull Charset charset) throws IOException {
        if (file == null) {
            PlatformTestCase.b(37);
        }
        if (string == null) {
            PlatformTestCase.b(38);
        }
        if (charset == null) {
            PlatformTestCase.b(39);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (byArray != null) {
            fileOutputStream.write(byArray);
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, charset);){
            outputStreamWriter.write(string);
        }
    }

    @NotNull
    public static VirtualFile createTempFile(@NonNls @NotNull String string, @Nullable byte[] byArray, @NonNls @NotNull String string2, @NotNull Charset charset) throws IOException {
        if (string == null) {
            PlatformTestCase.b(40);
        }
        if (string2 == null) {
            PlatformTestCase.b(41);
        }
        if (charset == null) {
            PlatformTestCase.b(42);
        }
        File file = FileUtil.createTempFile((String)"copy", (String)("." + string));
        PlatformTestCase.setContentOnDisk(file, byArray, string2, charset);
        myFilesToDelete.add(file);
        VirtualFile virtualFile = PlatformTestCase.getVirtualFile(file);
        assert (virtualFile != null) : file;
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            PlatformTestCase.b(43);
        }
        return virtualFile2;
    }

    @Nullable
    protected PsiFile getPsiFile(Document document) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    private static void a(String string) {
        System.setProperty("idea.platform.prefix", string);
        t = true;
    }

    @NotNull
    protected static VirtualFile createChildData(final @NotNull VirtualFile virtualFile, final @NotNull @NonNls String string) {
        if (virtualFile == null) {
            PlatformTestCase.b(44);
        }
        if (string == null) {
            PlatformTestCase.b(45);
        }
        VirtualFile virtualFile2 = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                if (result2 == null) {
                    4.a(0);
                }
                result2.setResult((Object)virtualFile.createChildData(null, string));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$4", "run"));
            }
        }.execute().throwException().getResultObject();
        if (virtualFile2 == null) {
            PlatformTestCase.b(46);
        }
        return virtualFile2;
    }

    @NotNull
    protected static VirtualFile createChildDirectory(final @NotNull VirtualFile virtualFile, final @NotNull @NonNls String string) {
        if (virtualFile == null) {
            PlatformTestCase.b(47);
        }
        if (string == null) {
            PlatformTestCase.b(48);
        }
        VirtualFile virtualFile2 = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result2) throws Throwable {
                if (result2 == null) {
                    5.a(0);
                }
                result2.setResult((Object)virtualFile.createChildDirectory(null, string));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$5", "run"));
            }
        }.execute().throwException().getResultObject();
        if (virtualFile2 == null) {
            PlatformTestCase.b(49);
        }
        return virtualFile2;
    }

    protected static void rename(final @NotNull VirtualFile virtualFile, final @NotNull String string) {
        if (virtualFile == null) {
            PlatformTestCase.b(50);
        }
        if (string == null) {
            PlatformTestCase.b(51);
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                virtualFile.rename((Object)this, string);
            }
        }.execute().throwException();
    }

    protected static void delete(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PlatformTestCase.b(52);
        }
        VfsTestUtil.deleteFile(virtualFile);
    }

    public static void move(final @NotNull VirtualFile virtualFile, final @NotNull VirtualFile virtualFile2) {
        if (virtualFile == null) {
            PlatformTestCase.b(53);
        }
        if (virtualFile2 == null) {
            PlatformTestCase.b(54);
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                virtualFile.move((Object)this, virtualFile2);
            }
        }.execute().throwException();
    }

    @NotNull
    protected static VirtualFile copy(final @NotNull VirtualFile virtualFile, final @NotNull VirtualFile virtualFile2, final @NotNull String string) {
        if (virtualFile == null) {
            PlatformTestCase.b(55);
        }
        if (virtualFile2 == null) {
            PlatformTestCase.b(56);
        }
        if (string == null) {
            PlatformTestCase.b(57);
        }
        final VirtualFile[] virtualFileArray = new VirtualFile[1];
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                virtualFileArray[0] = virtualFile.copy((Object)this, virtualFile2, string);
            }
        }.execute().throwException();
        VirtualFile virtualFile3 = virtualFileArray[0];
        if (virtualFile3 == null) {
            PlatformTestCase.b(58);
        }
        return virtualFile3;
    }

    public static void copyDirContentsTo(final @NotNull VirtualFile virtualFile, final @NotNull VirtualFile virtualFile2) {
        if (virtualFile == null) {
            PlatformTestCase.b(59);
        }
        if (virtualFile2 == null) {
            PlatformTestCase.b(60);
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                for (VirtualFile virtualFile3 : virtualFile.getChildren()) {
                    VfsUtil.copy((Object)((Object)this), (VirtualFile)virtualFile3, (VirtualFile)virtualFile2);
                }
            }
        }.execute().throwException();
    }

    public static void setFileText(final @NotNull VirtualFile virtualFile, final @NotNull String string) {
        if (virtualFile == null) {
            PlatformTestCase.b(61);
        }
        if (string == null) {
            PlatformTestCase.b(62);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    10.a(0);
                }
                VfsUtil.saveText((VirtualFile)virtualFile, (String)string);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$10", "run"));
            }
        }.execute().throwException();
    }

    public static void setBinaryContent(final @NotNull VirtualFile virtualFile, final @NotNull byte[] byArray) {
        if (virtualFile == null) {
            PlatformTestCase.b(63);
        }
        if (byArray == null) {
            PlatformTestCase.b(64);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    11.a(0);
                }
                virtualFile.setBinaryContent(byArray);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$11", "run"));
            }
        }.execute().throwException();
    }

    public static void setBinaryContent(final @NotNull VirtualFile virtualFile, final @NotNull byte[] byArray, final long l2, final long l3, final Object object) {
        if (virtualFile == null) {
            PlatformTestCase.b(65);
        }
        if (byArray == null) {
            PlatformTestCase.b(66);
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    12.a(0);
                }
                virtualFile.setBinaryContent(byArray, l2, l3, object);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$12", "run"));
            }
        }.execute().throwException();
    }

    @NotNull
    protected VirtualFile getOrCreateProjectBaseDir() {
        VirtualFile virtualFile = this.myProject.getBaseDir();
        if (virtualFile == null) {
            String string = this.myProject.getBasePath();
            try {
                FileUtil.ensureExists((File)new File(Objects.requireNonNull(string)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(string);
            if (virtualFile2 == null) {
                PlatformTestCase.b(67);
            }
            return virtualFile2;
        }
        VirtualFile virtualFile3 = virtualFile;
        if (virtualFile3 == null) {
            PlatformTestCase.b(68);
        }
        return virtualFile3;
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module2) throws IOException {
        if (module2 == null) {
            PlatformTestCase.b(69);
        }
        File file = new File(PathUtil.getParentPath((String)module2.getModuleFilePath()));
        FileUtil.ensureExists((File)file);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile == null) {
            PlatformTestCase.b(70);
        }
        return virtualFile;
    }

    private static /* synthetic */ boolean a(StringBuilder stringBuilder, TIntHashSet tIntHashSet, ProjectImpl projectImpl, Object object) {
        int n2 = System.identityHashCode(projectImpl);
        stringBuilder.append("Leaked project found:").append(projectImpl).append("; hash: ").append(n2).append("; place: ").append(PlatformTestCase.getCreationPlace((Project)projectImpl)).append("\n");
        stringBuilder.append(object + "\n");
        stringBuilder.append(";-----\n");
        tIntHashSet.remove(n2);
        return !tIntHashSet.isEmpty();
    }

    static {
        myFilesToDelete = new THashSet();
        ourTestTime = 300L;
        o = new String[]{"Rider", "GoLand", null, "AppCode", "CLion", "CidrCommon", "DataGrip", "Python", "PyCharmCore", "Ruby", "PhpStorm", "UltimateLangXml", "Idea", "PlatformLangXml"};
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 58: 
            case 67: 
            case 68: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 58: 
            case 67: 
            case 68: 
            case 70: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 58: 
            case 67: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestCase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creationPlace";
                break;
            }
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 28: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectToClose";
                break;
            }
            case 29: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 32: 
            case 37: 
            case 55: 
            case 61: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: 
            case 41: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 50: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile1";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vTestRoot";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestCase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCodeStyleSettings";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreationPlace";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirOrFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModule";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRealModuleIn";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleAt";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 36: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectBaseDir";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleDir";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeTempDirVfs";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 58: 
            case 67: 
            case 68: 
            case 70: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCreateProject";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCreationPlace";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModuleIn";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createModuleAt";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addSurvivingFiles";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "closeAndDisposeProjectAndCheckThatNoOpenProjects";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 35: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setContentOnDisk";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContentsTo";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setFileText";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleDir";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeTestRunnable$23";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$closeAndDisposeProjectAndCheckThatNoOpenProjects$20";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$19";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 43: 
            case 46: 
            case 49: 
            case 58: 
            case 67: 
            case 68: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

