/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.CpuUsageData;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.TeamCityLogger;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.Equality;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.InvocationEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.junit.Assert;

public class PlatformTestUtil {
    public static final boolean COVERAGE_ENABLED_BUILD = "true".equals(System.getProperty("idea.coverage.enabled.build"));
    private static final List<Runnable> b = new CopyOnWriteArrayList<Runnable>();
    private static final long a = TimeUnit.MINUTES.toMillis(2L);
    private static final OutputStream c = new OutputStream(){

        @Override
        public void write(int n2) {
        }
    };

    @NotNull
    public static String getTestName(@NotNull String string, boolean bl2) {
        if (string == null) {
            PlatformTestUtil.a(0);
        }
        String string2 = StringUtil.isEmpty((String)(string = StringUtil.trimStart((String)string, (String)"test"))) ? "" : PlatformTestUtil.lowercaseFirstLetter(string, bl2);
        if (string2 == null) {
            PlatformTestUtil.a(1);
        }
        return string2;
    }

    @NotNull
    public static String lowercaseFirstLetter(@NotNull String string, boolean bl2) {
        if (string == null) {
            PlatformTestUtil.a(2);
        }
        if (bl2 && !PlatformTestUtil.isAllUppercaseName(string)) {
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        String string2 = string;
        if (string2 == null) {
            PlatformTestUtil.a(3);
        }
        return string2;
    }

    public static boolean isAllUppercaseName(@NotNull String string) {
        if (string == null) {
            PlatformTestUtil.a(4);
        }
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isLowerCase(string.charAt(i2))) {
                return false;
            }
            if (!Character.isUpperCase(string.charAt(i2))) continue;
            ++n2;
        }
        return n2 >= 3;
    }

    public static <T> void registerExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull T t2, @NotNull Disposable disposable) {
        if (extensionPointName == null) {
            PlatformTestUtil.a(5);
        }
        if (t2 == null) {
            PlatformTestUtil.a(6);
        }
        if (disposable == null) {
            PlatformTestUtil.a(7);
        }
        PlatformTestUtil.registerExtension(Extensions.getRootArea(), extensionPointName, t2, disposable);
    }

    public static <T> void registerExtension(@NotNull ExtensionsArea extensionsArea, @NotNull ExtensionPointName<T> extensionPointName, @NotNull T t2, @NotNull Disposable disposable) {
        if (extensionsArea == null) {
            PlatformTestUtil.a(8);
        }
        if (extensionPointName == null) {
            PlatformTestUtil.a(9);
        }
        if (t2 == null) {
            PlatformTestUtil.a(10);
        }
        if (disposable == null) {
            PlatformTestUtil.a(11);
        }
        ExtensionPoint extensionPoint = extensionsArea.getExtensionPoint(extensionPointName.getName());
        extensionPoint.registerExtension(t2);
        Disposer.register((Disposable)disposable, () -> {
            if (t2 == null) {
                PlatformTestUtil.a(44);
            }
            extensionPoint.unregisterExtension(t2);
        });
    }

    @Nullable
    public static String toString(@Nullable Object object, @Nullable Queryable.PrintInfo printInfo) {
        if (object instanceof AbstractTreeNode) {
            if (printInfo != null) {
                return ((AbstractTreeNode)object).toTestString(printInfo);
            }
            String string = ((AbstractTreeNode)object).getTestPresentation();
            return string;
        }
        return String.valueOf(object);
    }

    public static String print(JTree jTree, boolean bl2) {
        return PlatformTestUtil.a(jTree, jTree.getModel().getRoot(), bl2, null, null);
    }

    public static String print(JTree jTree, Object object, @Nullable Queryable.PrintInfo printInfo, boolean bl2) {
        return PlatformTestUtil.a(jTree, object, bl2, printInfo, null);
    }

    public static String print(JTree jTree, boolean bl2, @Nullable Condition<String> condition) {
        return PlatformTestUtil.a(jTree, jTree.getModel().getRoot(), bl2, null, condition);
    }

    private static String a(JTree jTree, Object object, boolean bl2, @Nullable Queryable.PrintInfo printInfo, @Nullable Condition<String> condition) {
        StringBuilder stringBuilder = new StringBuilder();
        Collection<String> collection = PlatformTestUtil.b(jTree, object, bl2, printInfo, condition);
        for (String string : collection) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    private static Collection<String> b(JTree jTree, Object object, boolean bl2, @Nullable Queryable.PrintInfo printInfo, Condition<String> condition) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PlatformTestUtil.a(jTree, object, arrayList, 0, bl2, printInfo, condition);
        return arrayList;
    }

    private static void a(JTree jTree, Object object, Collection<String> collection, int n2, boolean bl2, @Nullable Queryable.PrintInfo printInfo, @Nullable Condition<String> condition) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        String string = PlatformTestUtil.toString(object2, printInfo);
        if (condition != null && !condition.value((Object)string)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)n2);
        boolean bl3 = jTree.isExpanded(new TreePath(defaultMutableTreeNode.getPath()));
        if (!defaultMutableTreeNode.isLeaf() && (jTree.isRootVisible() || defaultMutableTreeNode != jTree.getModel().getRoot() || defaultMutableTreeNode.getChildCount() > 0)) {
            stringBuilder.append(bl3 ? "-" : "+");
        }
        boolean bl4 = jTree.getSelectionModel().isPathSelected(new TreePath(defaultMutableTreeNode.getPath()));
        if (bl2 && bl4) {
            stringBuilder.append("[");
        }
        stringBuilder.append(string);
        if (bl2 && bl4) {
            stringBuilder.append("]");
        }
        collection.add(stringBuilder.toString());
        int n3 = jTree.getModel().getChildCount(object);
        if (bl3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                PlatformTestUtil.a(jTree, jTree.getModel().getChild(object, i2), collection, n2 + 1, bl2, printInfo, condition);
            }
        }
    }

    public static void assertTreeEqual(JTree jTree, @NonNls String string) {
        PlatformTestUtil.assertTreeEqual(jTree, string, false);
    }

    public static void assertTreeEqualIgnoringNodesOrder(JTree jTree, @NonNls String string) {
        Collection<String> collection = PlatformTestUtil.b(jTree, jTree.getModel().getRoot(), false, null, null);
        List list2 = StringUtil.split((String)string, (String)"\n");
        UsefulTestCase.assertSameElements(collection, list2);
    }

    public static void assertTreeEqual(JTree jTree, String string, boolean bl2) {
        String string2 = PlatformTestUtil.print(jTree, bl2);
        Assert.assertEquals((Object)string, (Object)string2);
    }

    public static void expand(JTree jTree, int ... nArray) {
        for (int n2 : nArray) {
            jTree.expandRow(n2);
            PlatformTestUtil.waitWhileBusy(jTree);
        }
    }

    public static void expandAll(JTree jTree) {
        PlatformTestUtil.waitForPromise(TreeUtil.promiseExpandAll((JTree)jTree));
    }

    private static long b(long l2) {
        return System.currentTimeMillis() - l2;
    }

    private static void a(long l2) {
        assert (PlatformTestUtil.b(l2) <= a) : "the waiting takes too long";
    }

    private static void a() {
        PlatformTestUtil.a(ApplicationManager.getApplication());
    }

    private static void a(Application application) {
        if (application != null) {
            assert (!application.isWriteAccessAllowed()) : "do not wait under the write action to avoid possible deadlock";
            assert (application.isDispatchThread());
        } else assert (EventQueue.isDispatchThread());
    }

    private static boolean a(JTree jTree) {
        UIUtil.dispatchAllInvocationEvents();
        TreeModel treeModel = jTree.getModel();
        if (treeModel instanceof AsyncTreeModel) {
            AsyncTreeModel asyncTreeModel = (AsyncTreeModel)treeModel;
            if (asyncTreeModel.isProcessing()) {
                return true;
            }
            UIUtil.dispatchAllInvocationEvents();
            return asyncTreeModel.isProcessing();
        }
        AbstractTreeBuilder abstractTreeBuilder = AbstractTreeBuilder.getBuilderFor((JTree)jTree);
        if (abstractTreeBuilder == null) {
            return false;
        }
        AbstractTreeUi abstractTreeUi = abstractTreeBuilder.getUi();
        if (abstractTreeUi == null) {
            return false;
        }
        return abstractTreeUi.hasPendingWork();
    }

    public static void waitWhileBusy(JTree jTree) {
        PlatformTestUtil.a();
        long l2 = System.currentTimeMillis();
        while (PlatformTestUtil.a(jTree)) {
            PlatformTestUtil.a(l2);
        }
    }

    public static void waitForCallback(@NotNull ActionCallback actionCallback) {
        if (actionCallback == null) {
            PlatformTestUtil.a(12);
        }
        AsyncPromise asyncPromise = new AsyncPromise();
        actionCallback.doWhenDone(() -> asyncPromise.setResult(null));
        PlatformTestUtil.waitForPromise(asyncPromise);
    }

    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            PlatformTestUtil.a(13);
        }
        PlatformTestUtil.a();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        promise.processed(object -> atomicBoolean.set(true));
        Object object2 = null;
        long l2 = System.currentTimeMillis();
        do {
            UIUtil.dispatchAllInvocationEvents();
            try {
                object2 = promise.blockingGet(20, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PlatformTestUtil.a(l2);
        } while (!atomicBoolean.get());
        UIUtil.dispatchAllInvocationEvents();
        return (T)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAlarm(int n2) {
        Application application = ApplicationManager.getApplication();
        PlatformTestUtil.a();
        Disposable disposable = Disposer.newDisposable();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        AtomicBoolean atomicBoolean2 = new AtomicBoolean();
        AtomicBoolean atomicBoolean3 = new AtomicBoolean();
        AtomicBoolean atomicBoolean4 = new AtomicBoolean();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Alarm alarm2 = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, disposable);
        ModalityState modalityState = ModalityState.current();
        alarm.addRequest(() -> {
            if (application == null) {
                PlatformTestUtil.a(43);
            }
            atomicBoolean3.set(true);
            application.invokeLater(() -> {
                atomicBoolean.set(true);
                alarm.addRequest(() -> atomicBoolean4.set(true), n2);
            });
        }, n2);
        alarm2.addRequest(() -> atomicBoolean2.set(true), n2);
        UIUtil.dispatchAllInvocationEvents();
        long l2 = System.currentTimeMillis();
        try {
            boolean bl2 = false;
            while (!atomicBoolean4.get()) {
                AtomicBoolean atomicBoolean5 = new AtomicBoolean();
                application.invokeLater(() -> atomicBoolean5.set(true));
                UIUtil.dispatchAllInvocationEvents();
                Assert.assertTrue((boolean)atomicBoolean5.get());
                TimeoutUtil.sleep((long)(bl2 ? 10L : (long)n2));
                bl2 = true;
                if (PlatformTestUtil.b(l2) > a) {
                    throw new AssertionError((Object)("Couldn't await alarm; alarm passed=" + atomicBoolean3.get() + "; modality1=" + modalityState + "; modality2=" + ModalityState.current() + "; non-modal=" + (modalityState == ModalityState.NON_MODAL) + "; invokeLater passed=" + atomicBoolean.get() + "; pooled alarm passed=" + atomicBoolean2.get() + "; app.disposed=" + application.isDisposed() + "; alarm.disposed=" + alarm.isDisposed() + "; alarm.requests=" + alarm.getActiveRequestCount() + "\n delayQueue=" + StringUtil.trimLog((String)((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).dumpQueue(), (int)1000) + "\n invocatorQueue=" + LaterInvocator.getLaterInvocatorQueue()));
                }
            }
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        UIUtil.dispatchAllInvocationEvents();
    }

    public static void dispatchAllInvocationEventsInIdeEventQueue() throws InterruptedException {
        AWTEvent aWTEvent;
        IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
        while ((aWTEvent = ideEventQueue.peekEvent()) != null) {
            AWTEvent aWTEvent2 = ideEventQueue.getNextEvent();
            if (!(aWTEvent2 instanceof InvocationEvent)) continue;
            ideEventQueue.dispatchEvent(aWTEvent2);
        }
    }

    public static void dispatchAllEventsInIdeEventQueue() throws InterruptedException {
        IdeEventQueue ideEventQueue = IdeEventQueue.getInstance();
        while (PlatformTestUtil.dispatchNextEventIfAny(ideEventQueue) != null) {
        }
    }

    public static AWTEvent dispatchNextEventIfAny(@NotNull IdeEventQueue ideEventQueue) throws InterruptedException {
        if (ideEventQueue == null) {
            PlatformTestUtil.a(14);
        }
        assert (SwingUtilities.isEventDispatchThread()) : Thread.currentThread();
        AWTEvent aWTEvent = ideEventQueue.peekEvent();
        if (aWTEvent == null) {
            return null;
        }
        AWTEvent aWTEvent2 = ideEventQueue.getNextEvent();
        ideEventQueue.dispatchEvent(aWTEvent2);
        return aWTEvent2;
    }

    public static StringBuilder print(AbstractTreeStructure abstractTreeStructure, Object object2, int n2, @Nullable Comparator comparator, int n3, char c2, @Nullable Queryable.PrintInfo printInfo) {
        return PlatformTestUtil.a(abstractTreeStructure, object2, n2, comparator, n3, c2, (Object object) -> PlatformTestUtil.toString(object, printInfo));
    }

    public static String print(AbstractTreeStructure abstractTreeStructure, Object object, Function<Object, String> function) {
        return PlatformTestUtil.a(abstractTreeStructure, object, 0, Comparator.comparing(function), -1, ' ', function).toString();
    }

    private static StringBuilder a(AbstractTreeStructure abstractTreeStructure, Object object, int n2, @Nullable Comparator comparator, int n3, char c2, Function<Object, String> function) {
        StringBuilder stringBuilder = new StringBuilder();
        PlatformTestUtil.a(stringBuilder, n2, object, abstractTreeStructure, comparator, n3, 0, c2, function);
        return stringBuilder;
    }

    private static int a(StringBuilder stringBuilder, int n2, Object object, AbstractTreeStructure abstractTreeStructure, @Nullable Comparator comparator, int n3, int n4, char c2, Function<Object, String> function) {
        if (n4 >= n3 && n3 != -1) {
            return n4;
        }
        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)c2, (int)n2);
        stringBuilder.append(function.apply(object)).append("\n");
        ++n4;
        Object[] objectArray = abstractTreeStructure.getChildElements(object);
        if (comparator != null) {
            ArrayList<Object> object2 = new ArrayList<Object>(Arrays.asList(objectArray));
            Comparator comparator2 = comparator;
            Collections.sort(object2, comparator2);
            objectArray = ArrayUtil.toObjectArray(object2);
        }
        for (Object object2 : objectArray) {
            n4 = PlatformTestUtil.a(stringBuilder, n2 + 1, object2, abstractTreeStructure, comparator, n3, n4, c2, function);
        }
        return n4;
    }

    public static String print(Object[] objectArray) {
        return PlatformTestUtil.print(Arrays.asList(objectArray));
    }

    public static String print(Collection collection) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            stringBuilder.append(PlatformTestUtil.toString(e2, null));
            if (!iterator.hasNext()) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String print(ListModel listModel) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < listModel.getSize(); ++i2) {
            stringBuilder.append(PlatformTestUtil.toString(listModel.getElementAt(i2), null));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String print(JTree jTree) {
        return PlatformTestUtil.print(jTree, false);
    }

    public static void assertTreeStructureEquals(@NotNull TreeModel treeModel, @NotNull String string) {
        if (treeModel == null) {
            PlatformTestUtil.a(15);
        }
        if (string == null) {
            PlatformTestUtil.a(16);
        }
        Assert.assertEquals((Object)string.trim(), (Object)PlatformTestUtil.print(PlatformTestUtil.createStructure(treeModel), treeModel.getRoot(), 0, null, -1, ' ', null).toString().trim());
    }

    @NotNull
    protected static AbstractTreeStructure createStructure(final @NotNull TreeModel treeModel) {
        if (treeModel == null) {
            PlatformTestUtil.a(17);
        }
        AbstractTreeStructure abstractTreeStructure = new AbstractTreeStructure(){

            public Object getRootElement() {
                return treeModel.getRoot();
            }

            public Object[] getChildElements(Object object) {
                return TreeUtil.nodeChildren((Object)object, (TreeModel)treeModel).toList().toArray();
            }

            @Nullable
            public Object getParentElement(Object object) {
                return ((AbstractTreeNode)object).getParent();
            }

            @NotNull
            public NodeDescriptor createDescriptor(Object object, NodeDescriptor nodeDescriptor) {
                throw new UnsupportedOperationException();
            }

            public void commit() {
                throw new UnsupportedOperationException();
            }

            public boolean hasSomethingToCommit() {
                throw new UnsupportedOperationException();
            }
        };
        if (abstractTreeStructure == null) {
            PlatformTestUtil.a(18);
        }
        return abstractTreeStructure;
    }

    public static void invokeNamedAction(String string) {
        AnAction anAction = ActionManager.getInstance().getAction(string);
        Assert.assertNotNull((Object)anAction);
        Presentation presentation = new Presentation();
        DataContext dataContext = DataManager.getInstance().getDataContext();
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction, null, (String)"", (DataContext)dataContext);
        anAction.beforeActionPerformedUpdate(anActionEvent);
        Assert.assertTrue((boolean)presentation.isEnabled());
        anAction.actionPerformed(anActionEvent);
    }

    public static void assertTiming(String string, long l2, long l3) {
        if (COVERAGE_ENABLED_BUILD) {
            return;
        }
        long l4 = Math.max(1L, l2 * Timings.CPU_TIMING / 200L);
        String string2 = string;
        if (l3 > l4) {
            int n2 = (int)(100.0 * (double)(l3 - l4) / (double)l4);
            string2 = string2 + ". Operation took " + n2 + "% longer than expected";
        }
        string2 = string2 + ". Expected on my machine: " + l4 + ". Actual: " + l3 + ". Expected on Standard machine: " + l2 + "; Timings: CPU=" + Timings.CPU_TIMING + ", I/O=" + Timings.IO_TIMING + ".";
        double d2 = 1.1;
        if (l3 < l4) {
            System.out.println(string2);
            TeamCityLogger.info((String)string2);
        } else if ((double)l3 < (double)l4 * 1.1) {
            TeamCityLogger.warning((String)string2, null);
        } else {
            throw new AssertionFailedError(string2);
        }
    }

    @Contract(pure=true)
    public static PerformanceTestInfo startPerformanceTest(@NonNls @NotNull String string, int n2, @NotNull ThrowableRunnable throwableRunnable) {
        if (string == null) {
            PlatformTestUtil.a(19);
        }
        if (throwableRunnable == null) {
            PlatformTestUtil.a(20);
        }
        return new PerformanceTestInfo(throwableRunnable, n2, string);
    }

    public static void assertPathsEqual(@Nullable String string, @Nullable String string2) {
        if (string != null) {
            string = FileUtil.toSystemIndependentName((String)string);
        }
        if (string2 != null) {
            string2 = FileUtil.toSystemIndependentName((String)string2);
        }
        Assert.assertEquals((Object)string, (Object)string2);
    }

    @NotNull
    public static String getJavaExe() {
        String string = SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
        if (string == null) {
            PlatformTestUtil.a(21);
        }
        return string;
    }

    @NotNull
    public static String getRtJarPath() {
        String string = SystemProperties.getJavaHome() + "/lib/rt.jar";
        if (string == null) {
            PlatformTestUtil.a(22);
        }
        return string;
    }

    public static void saveProject(@NotNull Project project2) {
        if (project2 == null) {
            PlatformTestUtil.a(23);
        }
        PlatformTestUtil.saveProject(project2, false);
    }

    public static void saveProject(@NotNull Project project2, boolean bl2) {
        if (project2 == null) {
            PlatformTestUtil.a(24);
        }
        ProjectManagerEx.getInstanceEx().flushChangedProjectFileAlarm();
        StoreUtil.save((IComponentStore)ServiceKt.getStateStore((ComponentManager)project2), (Project)project2, (boolean)bl2);
    }

    static void waitForAllBackgroundActivityToCalmDown() {
        CpuUsageData cpuUsageData;
        for (int i2 = 0; i2 < 50 && (cpuUsageData = CpuUsageData.measureCpuUsage(() -> TimeoutUtil.sleep((long)100L))).hasAnyActivityBesides(Thread.currentThread()); ++i2) {
        }
    }

    public static void assertTiming(String string, long l2, @NotNull Runnable runnable) {
        if (runnable == null) {
            PlatformTestUtil.a(25);
        }
        PlatformTestUtil.assertTiming(string, l2, 4, runnable);
    }

    private static long a(@NotNull Runnable runnable) {
        if (runnable == null) {
            PlatformTestUtil.a(26);
        }
        PlatformTestUtil.waitForAllBackgroundActivityToCalmDown();
        long l2 = System.currentTimeMillis();
        runnable.run();
        long l3 = System.currentTimeMillis();
        return l3 - l2;
    }

    public static void assertTiming(String string, long l2, int n2, @NotNull Runnable runnable) {
        if (runnable == null) {
            PlatformTestUtil.a(27);
        }
        while (true) {
            --n2;
            long l3 = PlatformTestUtil.a(runnable);
            try {
                PlatformTestUtil.assertTiming(string, l2, l3);
            }
            catch (AssertionFailedError assertionFailedError) {
                if (n2 == 0) {
                    throw assertionFailedError;
                }
                System.gc();
                System.gc();
                System.gc();
                String string2 = assertionFailedError.getMessage() + "\n  " + n2 + " attempts remain";
                TeamCityLogger.warning((String)string2, null);
                System.err.println(string2);
                continue;
            }
            break;
        }
    }

    private static HashMap<String, VirtualFile> a(VirtualFile[] virtualFileArray, @Nullable VirtualFileFilter virtualFileFilter) {
        HashMap<String, VirtualFile> hashMap = new HashMap<String, VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (virtualFileFilter != null && !virtualFileFilter.accept(virtualFile)) continue;
            hashMap.put(virtualFile.getName(), virtualFile);
        }
        return hashMap;
    }

    public static void assertDirectoriesEqual(VirtualFile virtualFile, VirtualFile virtualFile2) throws IOException {
        PlatformTestUtil.assertDirectoriesEqual(virtualFile, virtualFile2, null);
    }

    public static void assertDirectoriesEqual(VirtualFile virtualFile, VirtualFile virtualFile2, @Nullable VirtualFileFilter virtualFileFilter) throws IOException {
        File[] fileArray;
        Object[] objectArray;
        FileDocumentManager.getInstance().saveAllDocuments();
        VirtualFile[] virtualFileArray = virtualFile.getChildren();
        if (virtualFile.isInLocalFileSystem() && virtualFile.getFileSystem() != TempFileSystem.getInstance()) {
            objectArray = new File(virtualFile.getPath()).listFiles();
            PlatformTestUtil.a(virtualFileArray, (File[])objectArray);
        }
        objectArray = virtualFile2.getChildren();
        if (virtualFile2.isInLocalFileSystem() && virtualFile2.getFileSystem() != TempFileSystem.getInstance()) {
            fileArray = new File(virtualFile2.getPath()).listFiles();
            PlatformTestUtil.a(objectArray, fileArray);
        }
        fileArray = PlatformTestUtil.a(virtualFileArray, virtualFileFilter);
        HashMap<String, VirtualFile> hashMap = PlatformTestUtil.a(objectArray, virtualFileFilter);
        Set<String> set = fileArray.keySet();
        Set<String> set2 = hashMap.keySet();
        Assert.assertEquals((String)virtualFile.getPath(), set, set2);
        for (String string : set) {
            VirtualFile virtualFile3 = (VirtualFile)fileArray.get(string);
            VirtualFile virtualFile4 = hashMap.get(string);
            if (virtualFile3.isDirectory()) {
                PlatformTestUtil.assertDirectoriesEqual(virtualFile3, virtualFile4, virtualFileFilter);
                continue;
            }
            PlatformTestUtil.assertFilesEqual(virtualFile3, virtualFile4);
        }
    }

    private static void a(VirtualFile[] virtualFileArray, @Nullable File[] fileArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (VirtualFile virtualFile : virtualFileArray) {
            arrayList.add(virtualFile.getPath());
        }
        ArrayList arrayList2 = new ArrayList();
        if (fileArray != null) {
            for (File file : fileArray) {
                arrayList2.add(file.getPath().replace(File.separatorChar, '/'));
            }
        }
        Assert.assertEquals((Object)PlatformTestUtil.a(arrayList), (Object)PlatformTestUtil.a(arrayList2));
    }

    private static String a(List<String> list2) {
        Collections.sort(list2);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list2) {
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static void assertFilesEqual(VirtualFile virtualFile, VirtualFile virtualFile2) throws IOException {
        try {
            PlatformTestUtil.assertJarFilesEqual(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile), VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile2));
        }
        catch (IOException iOException) {
            String string;
            boolean bl2;
            boolean bl3;
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Document document = fileDocumentManager.getDocument(virtualFile2);
            boolean bl4 = bl3 = !virtualFile2.getFileType().isBinary() || virtualFile2.getFileType() == FileTypes.UNKNOWN;
            String string2 = document != null ? document.getText() : (!bl3 ? null : LoadTextUtil.getTextByBinaryPresentation((byte[])virtualFile2.contentsToByteArray(false), (VirtualFile)virtualFile2).toString());
            Document document2 = fileDocumentManager.getDocument(virtualFile);
            boolean bl5 = bl2 = !virtualFile2.getFileType().isBinary() || virtualFile2.getFileType() == FileTypes.UNKNOWN;
            String string3 = document2 != null ? document2.getText() : (string = !bl2 ? null : LoadTextUtil.getTextByBinaryPresentation((byte[])virtualFile.contentsToByteArray(false), (VirtualFile)virtualFile).toString());
            if (string != null && string2 != null) {
                if (!StringUtil.equals((CharSequence)string, (CharSequence)string2)) {
                    throw new FileComparisonFailure("Text mismatch in file " + virtualFile2.getName(), string, string2, virtualFile.getPath());
                }
            }
            Assert.assertArrayEquals((String)virtualFile.getPath(), (byte[])virtualFile.contentsToByteArray(), (byte[])virtualFile2.contentsToByteArray());
        }
    }

    public static void assertJarFilesEqual(File file, File file2) throws IOException {
        File file3;
        File file4;
        try (JarFile jarFile = new JarFile(file);
             JarFile jarFile2 = new JarFile(file2);){
            file4 = PlatformTestCase.createTempDir("tmp1");
            file3 = PlatformTestCase.createTempDir("tmp2");
            ZipUtil.extract((ZipFile)jarFile, (File)file4, null);
            ZipUtil.extract((ZipFile)jarFile2, (File)file3, null);
        }
        jarFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file4);
        Assert.assertNotNull((String)file4.toString(), (Object)jarFile);
        var5_3 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file3);
        Assert.assertNotNull((String)file3.toString(), (Object)var5_3);
        ApplicationManager.getApplication().runWriteAction(() -> PlatformTestUtil.a((VirtualFile)jarFile, (VirtualFile)var5_3));
        PlatformTestUtil.assertDirectoriesEqual((VirtualFile)jarFile, (VirtualFile)var5_3);
    }

    @Deprecated
    public static void assertElementsEqual(Element element, Element element2) {
        if (!JDOMUtil.areElementsEqual((Element)element, (Element)element2)) {
            Assert.assertEquals((Object)JDOMUtil.writeElement((Element)element), (Object)JDOMUtil.writeElement((Element)element2));
        }
    }

    @Deprecated
    public static void assertElementEquals(String string, Element element) {
        try {
            PlatformTestUtil.assertElementsEqual(JdomKt.loadElement((CharSequence)string), element);
        }
        catch (IOException | JDOMException throwable) {
            throw new AssertionError((Object)throwable);
        }
    }

    public static String getCommunityPath() {
        String string = PathManager.getHomePath();
        if (new File(string, "community/.idea").isDirectory()) {
            return string + File.separatorChar + "community";
        }
        return string;
    }

    public static String getPlatformTestDataPath() {
        return PlatformTestUtil.getCommunityPath().replace(File.separatorChar, '/') + "/platform/platform-tests/testData/";
    }

    public static Comparator<AbstractTreeNode> createComparator(Queryable.PrintInfo printInfo) {
        return (abstractTreeNode, abstractTreeNode2) -> {
            String string = abstractTreeNode.toTestString(printInfo);
            String string2 = abstractTreeNode2.toTestString(printInfo);
            return Comparing.compare((Comparable)((Object)string), (Comparable)((Object)string2));
        };
    }

    @NotNull
    public static <T> T notNull(@Nullable T t2) {
        Assert.assertNotNull(t2);
        T t3 = t2;
        if (t3 == null) {
            PlatformTestUtil.a(28);
        }
        return t3;
    }

    @NotNull
    public static String loadFileText(@NotNull String string) throws IOException {
        if (string == null) {
            PlatformTestUtil.a(29);
        }
        String string2 = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)new File(string)));
        if (string2 == null) {
            PlatformTestUtil.a(30);
        }
        return string2;
    }

    public static void tryGcSoftlyReachableObjects() {
        GCUtil.tryGcSoftlyReachableObjects();
    }

    public static void withEncoding(@NotNull String string, @NotNull ThrowableRunnable throwableRunnable) {
        if (string == null) {
            PlatformTestUtil.a(31);
        }
        if (throwableRunnable == null) {
            PlatformTestUtil.a(32);
        }
        try {
            Charset charset = Charset.defaultCharset();
            try {
                PlatformTestUtil.a(string);
                throwableRunnable.run();
            }
            finally {
                PlatformTestUtil.a(charset.name());
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void a(String string) {
        ReflectionUtil.resetField(Charset.class, Charset.class, (String)"defaultCharset");
        System.setProperty("file.encoding", string);
    }

    public static void withStdErrSuppressed(@NotNull Runnable runnable) {
        if (runnable == null) {
            PlatformTestUtil.a(33);
        }
        PrintStream printStream = System.err;
        System.setErr(new PrintStream(c));
        try {
            runnable.run();
        }
        finally {
            System.setErr(printStream);
        }
    }

    public static void assertSuccessful(@NotNull GeneralCommandLine generalCommandLine) {
        if (generalCommandLine == null) {
            PlatformTestUtil.a(34);
        }
        try {
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine.withRedirectErrorStream(true));
            Assert.assertEquals((String)processOutput.getStdout(), (long)0L, (long)processOutput.getExitCode());
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException(executionException);
        }
    }

    @NotNull
    public static List<WebReference> collectWebReferences(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PlatformTestUtil.a(35);
        }
        final ArrayList<WebReference> arrayList = new ArrayList<WebReference>();
        psiElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement psiElement) {
                for (PsiReference psiReference : psiElement.getReferences()) {
                    if (!(psiReference instanceof WebReference)) continue;
                    arrayList.add((WebReference)psiReference);
                }
                super.visitElement(psiElement);
            }
        });
        ArrayList<WebReference> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PlatformTestUtil.a(36);
        }
        return arrayList2;
    }

    public static void registerProjectCleanup(@NotNull Runnable runnable) {
        if (runnable == null) {
            PlatformTestUtil.a(37);
        }
        b.add(runnable);
    }

    public static void cleanupAllProjects() {
        for (Runnable runnable : b) {
            runnable.run();
        }
        b.clear();
    }

    public static void disposeApplicationAndCheckForProjectLeaks() {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            try {
                LightPlatformTestCase.initApplication();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            PlatformTestUtil.cleanupAllProjects();
            UIUtil.dispatchAllInvocationEvents();
            ApplicationImpl applicationImpl = (ApplicationImpl)ApplicationManager.getApplication();
            System.out.println(applicationImpl.writeActionStatistics());
            System.out.println(ActionUtil.ActionPauses.STAT.statistics());
            System.out.println(((AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService()).statistics());
            System.out.println("ProcessIOExecutorService threads created: " + ((ProcessIOExecutorService)ProcessIOExecutorService.INSTANCE).getThreadCounter());
            try {
                LeakHunter.checkNonDefaultProjectLeak();
            }
            catch (AssertionError | Exception object) {
                PlatformTestUtil.captureMemorySnapshot();
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)object);
            }
            finally {
                applicationImpl.setDisposeInProgress(true);
                LightPlatformTestCase.disposeApplication();
                UIUtil.dispatchAllInvocationEvents();
            }
        }));
    }

    public static void captureMemorySnapshot() {
        try {
            Method method = ReflectionUtil.getMethod(Class.forName("com.intellij.util.ProfilingUtil"), (String)"captureMemorySnapshot", (Class[])new Class[0]);
            if (method != null) {
                Object object = method.invoke(null, new Object[0]);
                System.out.println("Memory snapshot captured to '" + object + "'");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static <T> void assertComparisonContractNotViolated(@NotNull List<T> list2, @NotNull Comparator<T> comparator, @NotNull Equality<T> equality) {
        if (list2 == null) {
            PlatformTestUtil.a(38);
        }
        if (comparator == null) {
            PlatformTestUtil.a(39);
        }
        if (equality == null) {
            PlatformTestUtil.a(40);
        }
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            for (int i3 = i2; i3 < list2.size(); ++i3) {
                T t2 = list2.get(i2);
                T t3 = list2.get(i3);
                int n2 = comparator.compare(t2, t3);
                int n3 = comparator.compare(t3, t2);
                if (equality.equals(t2, t3)) {
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", t2, t3), (long)0L, (long)n2);
                    Assert.assertEquals((String)String.format("Equal, but not 0: '%s' - '%s'", t3, t2), (long)0L, (long)n3);
                } else {
                    if (n2 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", t2, t3));
                    }
                    if (n3 == 0) {
                        Assert.fail((String)String.format("Not equal, but 0: '%s' - '%s'", t3, t2));
                    }
                    if (Integer.signum(n2) == Integer.signum(n3)) {
                        Assert.fail((String)String.format("Not symmetrical: '%s' - '%s'", t2, t3));
                    }
                }
                for (int i4 = i3; i4 < list2.size(); ++i4) {
                    int n4;
                    T t4 = list2.get(i4);
                    int n5 = comparator.compare(t3, t4);
                    if (PlatformTestUtil.a(n2, n5, n4 = comparator.compare(t4, t2))) continue;
                    Assert.fail((String)String.format("Not transitive: '%s' - '%s' - '%s'", t2, t3, t4));
                }
            }
        }
    }

    private static boolean a(int n2, int n3, int n4) {
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return true;
        }
        if (n2 > 0 && n3 > 0 && n4 > 0) {
            return false;
        }
        if (n2 < 0 && n3 < 0 && n4 < 0) {
            return false;
        }
        if (n2 == 0 && Integer.signum(n3) * Integer.signum(n4) >= 0) {
            return false;
        }
        if (n3 == 0 && Integer.signum(n2) * Integer.signum(n4) >= 0) {
            return false;
        }
        return n4 != 0 || Integer.signum(n3) * Integer.signum(n2) < 0;
    }

    public static void setLongMeaninglessFileIncludeTemplateTemporarilyFor(@NotNull Project project2, @NotNull Disposable disposable) {
        if (project2 == null) {
            PlatformTestUtil.a(41);
        }
        if (disposable == null) {
            PlatformTestUtil.a(42);
        }
        FileTemplateManagerImpl fileTemplateManagerImpl = (FileTemplateManagerImpl)FileTemplateManager.getInstance((Project)project2);
        fileTemplateManagerImpl.setDefaultFileIncludeTemplateTextTemporarilyForTest("File Header", "/**\n * Created by ${USER} on ${DATE}.\n */\n", disposable);
    }

    private static /* synthetic */ void a(VirtualFile virtualFile, VirtualFile virtualFile2) {
        virtualFile.refresh(false, true);
        virtualFile2.refresh(false, true);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 21: 
            case 22: 
            case 28: 
            case 30: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 21: 
            case 22: 
            case 28: 
            case 30: 
            case 36: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 21: 
            case 22: 
            case 28: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 6: 
            case 10: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 7: 
            case 11: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventQueue";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 23: 
            case 24: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToMeasure";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanup";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformTestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "lowercaseFirstLetter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructure";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaExe";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRtJarPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "collectWebReferences";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 21: 
            case 22: 
            case 28: 
            case 30: 
            case 36: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lowercaseFirstLetter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAllUppercaseName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitForCallback";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dispatchNextEventIfAny";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "assertTreeStructureEquals";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createStructure";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startPerformanceTest";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "saveProject";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "assertTiming";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "withEncoding";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "withStdErrSuppressed";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "assertSuccessful";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectWebReferences";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectCleanup";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "assertComparisonContractNotViolated";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setLongMeaninglessFileIncludeTemplateTemporarilyFor";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$waitForAlarm$5";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerExtension$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 18: 
            case 21: 
            case 22: 
            case 28: 
            case 30: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

