/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestDataProvider
implements DataProvider,
DataContext {
    private final Project a;

    public TestDataProvider(@NotNull Project project2) {
        if (project2 == null) {
            TestDataProvider.a(0);
        }
        this.a = project2;
    }

    public Object getData(@NonNls String string) {
        if (this.a.isDisposed()) {
            throw new RuntimeException("TestDataProvider is already disposed for " + this.a + "\nIf you closed a project in test, please reset IdeaTestApplication.setDataProvider.");
        }
        if (CommonDataKeys.PROJECT.is(string)) {
            return this.a;
        }
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)this.a);
        if (fileEditorManagerEx == null) {
            return null;
        }
        if (CommonDataKeys.EDITOR.is(string) || OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(string)) {
            return fileEditorManagerEx instanceof FileEditorManagerImpl ? ((FileEditorManagerImpl)fileEditorManagerEx).getSelectedTextEditor(true) : fileEditorManagerEx.getSelectedTextEditor();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(string)) {
            Editor editor = fileEditorManagerEx.getSelectedTextEditor();
            return editor == null ? null : TextEditorProvider.getInstance().getTextEditor(editor);
        }
        Editor editor = (Editor)this.getData(CommonDataKeys.EDITOR.getName());
        if (editor != null) {
            Object object = fileEditorManagerEx.getData(string, editor, editor.getCaretModel().getCurrentCaret());
            if (object != null) {
                return object;
            }
            JComponent jComponent = editor.getContentComponent();
            if (jComponent instanceof EditorComponentImpl) {
                return ((EditorComponentImpl)jComponent).getData(string);
            }
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/TestDataProvider", "<init>"));
    }
}

