/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;
import org.junit.Assert;

public class ThreadTracker {
    private static final Logger c = Logger.getInstance(ThreadTracker.class);
    private final Collection<Thread> b = ThreadTracker.getThreads();
    private final boolean d = ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized();
    private static final Method a = ReflectionUtil.getDeclaredMethod(Thread.class, (String)"getThreads", (Class[])new Class[0]);
    private static final Set<String> e = new THashSet();

    @NotNull
    public static Collection<Thread> getThreads() {
        Object[] objectArray;
        try {
            objectArray = (Thread[])a.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        ArrayList arrayList = ContainerUtilRt.newArrayList((Object[])objectArray);
        if (arrayList == null) {
            ThreadTracker.a(0);
        }
        return arrayList;
    }

    public static void longRunningThreadCreated(@NotNull Disposable disposable, String ... stringArray) {
        if (disposable == null) {
            ThreadTracker.a(1);
        }
        if (stringArray == null) {
            ThreadTracker.a(2);
        }
        e.addAll(Arrays.asList(stringArray));
        Disposer.register((Disposable)disposable, () -> {
            if (stringArray == null) {
                ThreadTracker.a(12);
            }
            e.removeAll(Arrays.asList(stringArray));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkLeak() throws AssertionError {
        NettyUtil.awaitQuiescenceOfGlobalEventExecutor((long)100L, (TimeUnit)TimeUnit.SECONDS);
        ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
        try {
            if (this.d != ((ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized()) {
                return;
            }
            THashSet tHashSet = new THashSet(ThreadTracker.getThreads());
            tHashSet.removeAll(this.b);
            for (final Thread thread : tHashSet) {
                StackTraceElement[] stackTraceElementArray;
                ThreadGroup threadGroup;
                if (thread == Thread.currentThread() || (threadGroup = thread.getThreadGroup()) != null && "system".equals(threadGroup.getName()) || ThreadTracker.a(thread) || !thread.isAlive()) continue;
                if (thread.getStackTrace().length == 0) {
                    thread.interrupt();
                    if (new WaitFor(10000){

                        protected boolean condition() {
                            return !thread.isAlive();
                        }
                    }.isConditionRealized()) continue;
                }
                if ((stackTraceElementArray = thread.getStackTrace()).length == 0 || ThreadTracker.a(thread, stackTraceElementArray) || ThreadTracker.b(thread, stackTraceElementArray)) continue;
                String string = "Thread leaked: " + thread + "; " + (Object)((Object)thread.getState()) + " (" + thread.isAlive() + ")\n--- its stacktrace:\n";
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    string = string + " at " + stackTraceElement + "\n";
                }
                string = string + "---\n";
                Assert.fail((String)string);
            }
        }
        finally {
            this.b.clear();
        }
    }

    private static boolean a(@NotNull Thread thread) {
        if (thread == null) {
            ThreadTracker.a(3);
        }
        String string = thread.getName();
        return ContainerUtil.exists(e, string::contains);
    }

    private static boolean a(@NotNull Thread thread, @NotNull StackTraceElement[] stackTraceElementArray) {
        if (thread == null) {
            ThreadTracker.a(4);
        }
        if (stackTraceElementArray == null) {
            ThreadTracker.a(5);
        }
        if (!ThreadTracker.a(thread)) {
            return false;
        }
        boolean bl2 = Arrays.stream(stackTraceElementArray).anyMatch(stackTraceElement -> stackTraceElement.getMethodName().equals("getTask") && stackTraceElement.getClassName().equals("java.util.concurrent.ThreadPoolExecutor"));
        return bl2;
    }

    private static boolean b(@NotNull Thread thread, @NotNull StackTraceElement[] stackTraceElementArray) {
        if (thread == null) {
            ThreadTracker.a(6);
        }
        if (stackTraceElementArray == null) {
            ThreadTracker.a(7);
        }
        if (!ForkJoinWorkerThread.class.isAssignableFrom(thread.getClass())) {
            return false;
        }
        boolean bl2 = Arrays.stream(stackTraceElementArray).anyMatch(stackTraceElement -> stackTraceElement.getMethodName().equals("awaitWork") && stackTraceElement.getClassName().equals("java.util.concurrent.ForkJoinPool"));
        return bl2;
    }

    public static void awaitJDIThreadsTermination(int n2, @NotNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            ThreadTracker.a(8);
        }
        ThreadTracker.a("JDI main", n2, timeUnit);
    }

    private static void a(@NotNull String string, int n2, @NotNull TimeUnit timeUnit) {
        Thread thread2;
        if (string == null) {
            ThreadTracker.a(9);
        }
        if (timeUnit == null) {
            ThreadTracker.a(10);
        }
        long l2 = System.currentTimeMillis();
        while (System.currentTimeMillis() < l2 + timeUnit.toMillis(n2) && (thread2 = (Thread)ContainerUtil.find(ThreadTracker.getThreads(), thread -> {
            ThreadGroup threadGroup;
            if (string == null) {
                ThreadTracker.a(11);
            }
            return (threadGroup = thread.getThreadGroup()) != null && threadGroup.getParent() != null && string.equals(threadGroup.getParent().getName());
        })) != null) {
            try {
                long l3 = l2 + timeUnit.toMillis(n2) - System.currentTimeMillis();
                c.debug("Waiting for the " + thread2 + " for " + l3 + "ms");
                thread2.join(l3);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    static {
        e.add("AWT-EventQueue-");
        e.add("AWT-Shutdown");
        e.add("AWT-Windows");
        e.add("CompilerThread0");
        e.add("External compiler");
        e.add("Finalizer");
        e.add("IDEA Test Case Thread");
        e.add("Image Fetcher ");
        e.add("Java2D Disposer");
        e.add("JobScheduler FJ pool ");
        e.add("JPS thread pool");
        e.add("Keep-Alive-Timer");
        e.add("main");
        e.add("Monitor Ctrl-Break");
        e.add("Netty ");
        e.add("Reference Handler");
        e.add("RMI TCP Connection");
        e.add("Signal Dispatcher");
        e.add("timer-int");
        e.add("timer-sys");
        e.add("TimerQueue");
        e.add("UserActivityMonitor thread");
        e.add("VM Periodic Task Thread");
        e.add("VM Thread");
        e.add("YJPAgent-Telemetry");
        Application application = ApplicationManager.getApplication();
        if (!application.isDisposed()) {
            ThreadTracker.longRunningThreadCreated((Disposable)application, "Periodic tasks thread", "ApplicationImpl pooled thread ", "Process I/O pool ");
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ThreadTracker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadNamePrefixes";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandThreadGroup";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreads";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ThreadTracker";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "longRunningThreadCreated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isWellKnownOffender";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIdleApplicationPoolThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIdleCommonPoolThread";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "awaitJDIThreadsTermination";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "awaitThreadTerminationWithParentParentGroup";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$awaitThreadTerminationWithParentParentGroup$3";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$longRunningThreadCreated$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

