/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.CpuTimings;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class Timings {
    private static final int a = 42;
    public static final long CPU_TIMING;
    private static final CpuTimings b;
    public static final long IO_TIMING;
    public static final long REFERENCE_CPU_TIMING = 200L;
    public static final long REFERENCE_IO_TIMING = 100L;

    public static int adjustAccordingToMySpeed(int n2, boolean bl2) {
        return Math.max(1, (int)(1.0 * (double)n2 * 200.0 / (double)CPU_TIMING) / 8 * (bl2 ? JobSchedulerImpl.getJobPoolParallelism() : 1));
    }

    public static String getStatistics() {
        return String.format("CPU=%d (%d%% reference CPU, sd=%.2f), I/O=%d (%d%% reference IO), %d cores", Timings.b.average, CPU_TIMING * 100L / 200L, Timings.b.stdDev, IO_TIMING, IO_TIMING * 100L / 100L, Runtime.getRuntime().availableProcessors());
    }

    static {
        b = CpuTimings.calcStableCpuTiming();
        CPU_TIMING = Timings.b.average;
        long l2 = System.currentTimeMillis();
        for (int i2 = 0; i2 < 42; ++i2) {
            try {
                File file = FileUtil.createTempFile((String)"test", (String)("test" + i2));
                try (Closeable closeable = new FileWriter(file);){
                    for (int i3 = 0; i3 < 15; ++i3) {
                        ((Writer)closeable).write("test" + i3);
                        ((OutputStreamWriter)closeable).flush();
                    }
                }
                closeable = new FileReader(file);
                var5_5 = null;
                try {
                    while (((InputStreamReader)closeable).read() >= 0) {
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (closeable != null) {
                        if (var5_5 != null) {
                            try {
                                ((InputStreamReader)closeable).close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStreamReader)closeable).close();
                        }
                    }
                }
                if (i2 == 41) {
                    closeable = new FileOutputStream(file);
                    var5_5 = null;
                    try {
                        ((FileOutputStream)closeable).getFD().sync();
                    }
                    catch (Throwable throwable) {
                        var5_5 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (closeable != null) {
                            if (var5_5 != null) {
                                try {
                                    ((FileOutputStream)closeable).close();
                                }
                                catch (Throwable throwable) {
                                    var5_5.addSuppressed(throwable);
                                }
                            } else {
                                ((FileOutputStream)closeable).close();
                            }
                        }
                    }
                }
                if (file.delete()) continue;
                throw new IOException("Unable to delete: " + file);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        IO_TIMING = System.currentTimeMillis() - l2;
    }
}

