/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.builders.EmptyModuleFixtureBuilder;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import java.io.File;
import org.jetbrains.annotations.NonNls;

public abstract class CodeInsightFixtureTestCase<T extends ModuleFixtureBuilder>
extends UsefulTestCase {
    protected CodeInsightTestFixture myFixture;
    protected Module myModule;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String string = ((Object)((Object)this)).getClass().getName() + "." + this.getName();
        TestFixtureBuilder<IdeaProjectTestFixture> testFixtureBuilder = IdeaTestFixtureFactory.getFixtureFactory().createFixtureBuilder(string);
        this.myFixture = IdeaTestFixtureFactory.getFixtureFactory().createCodeInsightFixture(testFixtureBuilder.getFixture());
        T t2 = testFixtureBuilder.addModule(this.getModuleBuilderClass());
        t2.addSourceContentRoot(this.myFixture.getTempDirPath());
        this.tuneFixture(t2);
        this.myFixture.setUp();
        this.myFixture.setTestDataPath(this.getTestDataPath());
        this.myModule = t2.getFixture().getModule();
    }

    protected Class<T> getModuleBuilderClass() {
        return EmptyModuleFixtureBuilder.class;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myModule = null;
        try {
            this.myFixture.tearDown();
        }
        finally {
            this.myFixture = null;
            super.tearDown();
        }
    }

    protected void tuneFixture(T t2) {
    }

    @NonNls
    protected String getBasePath() {
        return "";
    }

    @NonNls
    protected final String getTestDataPath() {
        String string = this.isCommunity() ? PlatformTestUtil.getCommunityPath() : PathManager.getHomePath();
        return string.replace(File.separatorChar, '/') + this.getBasePath();
    }

    protected boolean isCommunity() {
        return false;
    }

    protected Project getProject() {
        return this.myFixture.getProject();
    }

    protected Editor getEditor() {
        return this.myFixture.getEditor();
    }

    protected PsiFile getFile() {
        return this.myFixture.getFile();
    }
}

