/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.testIntegration.ConfigurationByRecordProvider;
import com.intellij.testIntegration.RecentTestsData;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SuiteEntry;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;

public class RecentTestsListProvider {
    private final Map<String, TestStateStorage.Record> a;
    private final ConfigurationByRecordProvider b;

    public RecentTestsListProvider(ConfigurationByRecordProvider configurationByRecordProvider, Map<String, TestStateStorage.Record> map) {
        this.a = map;
        this.b = configurationByRecordProvider;
    }

    public List<RecentTestsPopupEntry> getTestsToShow() {
        if (this.a == null) {
            return ContainerUtil.emptyList();
        }
        RecentTestsData recentTestsData = new RecentTestsData();
        for (Map.Entry<String, TestStateStorage.Record> entry : this.a.entrySet()) {
            String string = entry.getKey();
            TestStateStorage.Record record = entry.getValue();
            if (!TestLocator.canLocate(string)) continue;
            this.a(recentTestsData, string, record);
        }
        return recentTestsData.getTestsToShow();
    }

    private void a(RecentTestsData recentTestsData, String string, TestStateStorage.Record record) {
        TestStateInfo.Magnitude magnitude = RecentTestsListProvider.a(record.magnitude);
        if (magnitude == null) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.b.getConfiguration(record);
        if (runnerAndConfigurationSettings == null) {
            return;
        }
        if (TestLocator.isSuite(string)) {
            SuiteEntry suiteEntry = new SuiteEntry(string, record.date, runnerAndConfigurationSettings);
            recentTestsData.addSuite(suiteEntry);
        } else {
            SingleTestEntry singleTestEntry = new SingleTestEntry(string, record.date, runnerAndConfigurationSettings, magnitude);
            recentTestsData.addTest(singleTestEntry);
        }
    }

    private static TestStateInfo.Magnitude a(int n2) {
        for (TestStateInfo.Magnitude magnitude : TestStateInfo.Magnitude.values()) {
            if (magnitude.getValue() != n2) continue;
            return magnitude;
        }
        return null;
    }
}

