/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileContainerImpl
extends SimpleModificationTracker
implements ConfigFileContainer {
    private final Project d;
    private final EventDispatcher<ConfigFileListener> c = EventDispatcher.create(ConfigFileListener.class);
    private final MultiValuesMap<ConfigFileMetaData, ConfigFile> e = new MultiValuesMap();
    private ConfigFile[] f;
    private final ConfigFileMetaDataProvider b;
    private final ConfigFileInfoSetImpl a;

    public ConfigFileContainerImpl(Project project2, ConfigFileMetaDataProvider configFileMetaDataProvider, ConfigFileInfoSetImpl configFileInfoSetImpl) {
        this.a = configFileInfoSetImpl;
        this.b = configFileMetaDataProvider;
        this.d = project2;
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent virtualFilePropertyEvent) {
                if (virtualFilePropertyEvent == null) {
                    1.a(0);
                }
                if (virtualFilePropertyEvent.getPropertyName().equals("name")) {
                    ConfigFileContainerImpl.this.a(virtualFilePropertyEvent.getFile());
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent virtualFileMoveEvent) {
                if (virtualFileMoveEvent == null) {
                    1.a(1);
                }
                ConfigFileContainerImpl.this.a(virtualFileMoveEvent.getFile());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/util/descriptors/impl/ConfigFileContainerImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.a.setContainer(this);
    }

    private void a(VirtualFile virtualFile) {
        for (ConfigFile configFile : this.e.values()) {
            VirtualFile virtualFile2 = configFile.getVirtualFile();
            if (virtualFile2 == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) continue;
            this.a.updateConfigFile(configFile);
            this.fireDescriptorChanged(configFile);
        }
    }

    @Nullable
    public ConfigFile getConfigFile(ConfigFileMetaData configFileMetaData) {
        return (ConfigFile)ContainerUtil.getFirstItem((Collection)this.e.get((Object)configFileMetaData));
    }

    public ConfigFile[] getConfigFiles() {
        if (this.f == null) {
            Collection collection = this.e.values();
            this.f = collection.toArray(ConfigFile.EMPTY_ARRAY);
        }
        return this.f;
    }

    public Project getProject() {
        return this.d;
    }

    public void addListener(ConfigFileListener configFileListener, Disposable disposable) {
        this.c.addListener((EventListener)configFileListener, disposable);
    }

    public void fireDescriptorChanged(ConfigFile configFile) {
        this.incModificationCount();
        ((ConfigFileListener)this.c.getMulticaster()).configFileChanged(configFile);
    }

    public ConfigFileInfoSet getConfiguration() {
        return this.a;
    }

    public void dispose() {
    }

    public void addListener(ConfigFileListener configFileListener) {
        this.c.addListener((EventListener)configFileListener);
    }

    public void removeListener(ConfigFileListener configFileListener) {
        this.c.removeListener((EventListener)configFileListener);
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.b;
    }

    public void updateDescriptors(@NotNull MultiValuesMap<ConfigFileMetaData, ConfigFileInfo> multiValuesMap) {
        if (multiValuesMap == null) {
            ConfigFileContainerImpl.a(0);
        }
        HashSet hashSet = this.e.isEmpty() ? Collections.emptySet() : new HashSet(this.e.values());
        Set set = null;
        for (Map.Entry entry : multiValuesMap.entrySet()) {
            ConfigFileMetaData configFileMetaData = (ConfigFileMetaData)entry.getKey();
            HashSet hashSet2 = new HashSet((Collection)entry.getValue());
            Collection collection = this.e.get((Object)configFileMetaData);
            if (collection != null) {
                for (ConfigFile configFile : collection) {
                    if (!hashSet2.remove(configFile.getInfo())) continue;
                    hashSet.remove(configFile);
                }
            }
            for (ConfigFile configFile : hashSet2) {
                ConfigFileImpl configFileImpl = new ConfigFileImpl(this, (ConfigFileInfo)configFile);
                Disposer.register((Disposable)this, (Disposable)configFileImpl);
                this.e.put((Object)configFileMetaData, (Object)configFileImpl);
                if (set == null) {
                    set = new THashSet();
                }
                set.add(configFileImpl);
            }
        }
        for (Map.Entry entry : hashSet) {
            this.e.remove((Object)entry.getMetaData(), (Object)entry);
            Disposer.dispose((Disposable)entry);
        }
        this.f = null;
        if (set != null) {
            for (Map.Entry entry : set) {
                this.incModificationCount();
                ((ConfigFileListener)this.c.getMulticaster()).configFileAdded((ConfigFile)entry);
            }
        }
        for (Map.Entry entry : hashSet) {
            this.incModificationCount();
            ((ConfigFileListener)this.c.getMulticaster()).configFileRemoved((ConfigFile)entry);
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorsMap", "com/intellij/util/descriptors/impl/ConfigFileContainerImpl", "updateDescriptors"));
    }
}

