/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\n\u001a\u0004\u0018\u00010\u0007*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"assertDirectoryContentMatches", "", "file", "Ljava/io/File;", "spec", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "relativePath", "", "assertDirectoryMatches", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "convertToText", "", "intellij.platform.testFramework"})
public final class DirectoryContentSpecImplKt {
    public static final void assertDirectoryContentMatches(@NotNull File file, @NotNull DirectoryContentSpecImpl directoryContentSpecImpl, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)directoryContentSpecImpl, (String)"spec");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"relativePath");
        DirectoryContentSpecImpl directoryContentSpecImpl2 = directoryContentSpecImpl;
        if (directoryContentSpecImpl2 instanceof DirectorySpec) {
            DirectoryContentSpecImplKt.a(file, (DirectorySpecBase)directoryContentSpecImpl, string);
        } else if (directoryContentSpecImpl2 instanceof ZipSpec) {
            File file2 = FileUtil.createTempDirectory((String)("extracted-" + file.getName()), null, (boolean)false);
            ZipUtil.extract((File)file, (File)file2, null);
            File file3 = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"dirForExtracted");
            DirectoryContentSpecImplKt.a(file3, (DirectorySpecBase)directoryContentSpecImpl, string);
            FileUtil.delete((File)file2);
        } else if (directoryContentSpecImpl2 instanceof FileSpec) {
            byte[] byArray;
            Assert.assertTrue((String)("" + file + " is not a file"), (boolean)file.isFile());
            if (((FileSpec)directoryContentSpecImpl).getContent() != null && !Arrays.equals(byArray = FileUtil.loadFileBytes((File)file), ((FileSpec)directoryContentSpecImpl).getContent())) {
                String string2;
                String string3 = DirectoryContentSpecImplKt.a(byArray);
                String string4 = DirectoryContentSpecImplKt.a(((FileSpec)directoryContentSpecImpl).getContent());
                String string5 = string2 = Intrinsics.areEqual((Object)string, (Object)"") ^ true ? " at " + string : "";
                if (string3 != null && string4 != null) {
                    Assert.assertEquals((String)("File content mismatch" + string2 + ':'), (Object)string4, (Object)string3);
                } else {
                    Assert.fail((String)("Binary file content mismatch" + string2));
                }
            }
        }
    }

    private static final String a(@NotNull byte[] byArray) {
        Charset charset;
        CharsetToolkit.GuessedEncoding guessedEncoding = new CharsetToolkit(byArray, Charsets.UTF_8).guessFromContent(byArray.length);
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[guessedEncoding.ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    private static final void a(File file, DirectorySpecBase directorySpecBase, String string) {
        Assert.assertTrue((String)("" + file + " is not a directory"), (boolean)file.isDirectory());
        List list2 = ArraysKt.sortedWith((Object[])file.list(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Map<String, DirectoryContentSpecImpl> map = directorySpecBase.getChildren();
        List list3 = CollectionsKt.sortedWith((Iterable)map.keySet(), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Assert.assertEquals((String)("Directory content mismatch" + (Intrinsics.areEqual((Object)string, (Object)"") ^ true ? " at " + string : "") + ':'), (Object)CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        Iterable iterable = list2;
        for (Object t2 : iterable) {
            String string2 = (String)t2;
            File file2 = new File(file, string2);
            DirectoryContentSpecImpl directoryContentSpecImpl = map.get(string2);
            if (directoryContentSpecImpl == null) {
                Intrinsics.throwNpe();
            }
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(file2, directoryContentSpecImpl, "" + string + '/' + string2);
        }
    }
}

