/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Referencing;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.GenericDomValueReference;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import com.intellij.xml.XmlBundle;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomHighlightingHelperImpl
extends DomHighlightingHelper {
    public static final DomHighlightingHelperImpl INSTANCE = new DomHighlightingHelperImpl();
    private final GenericValueReferenceProvider b = new GenericValueReferenceProvider();
    private final DomApplicationComponent a = DomApplicationComponent.getInstance();

    public void runAnnotators(DomElement domElement, DomElementAnnotationHolder domElementAnnotationHolder, Class<? extends DomElement> clazz) {
        DomElementsAnnotator domElementsAnnotator = this.a.getAnnotator(clazz);
        if (domElementsAnnotator != null) {
            domElementsAnnotator.annotate(domElement, domElementAnnotationHolder);
        }
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkRequired(DomElement domElement, DomElementAnnotationHolder domElementAnnotationHolder) {
        XmlElement xmlElement;
        Required required = (Required)domElement.getAnnotation(Required.class);
        if (required != null) {
            xmlElement = domElement.getXmlElement();
            if (xmlElement == null) {
                if (required.value()) {
                    String string = domElement.getXmlElementName();
                    String string2 = domElement.getXmlElementNamespace();
                    if (domElement instanceof GenericAttributeValue) {
                        List<DomElementProblemDescriptor> list2 = Collections.singletonList(domElementAnnotationHolder.createProblem(domElement, IdeBundle.message((String)"attribute.0.should.be.defined", (Object[])new Object[]{string}), new LocalQuickFix[]{new DefineAttributeQuickFix(string, string2)}));
                        if (list2 == null) {
                            DomHighlightingHelperImpl.a(0);
                        }
                        return list2;
                    }
                    List<DomElementProblemDescriptor> list3 = Collections.singletonList(domElementAnnotationHolder.createProblem(domElement, HighlightSeverity.ERROR, IdeBundle.message((String)"child.tag.0.should.be.defined", (Object[])new Object[]{string}), new LocalQuickFix[]{new AddRequiredSubtagFix(string, string2)}));
                    if (list3 == null) {
                        DomHighlightingHelperImpl.a(1);
                    }
                    return list3;
                }
            } else if (domElement instanceof GenericDomValue) {
                List list4 = ContainerUtil.createMaybeSingletonList((Object)DomHighlightingHelperImpl.a((GenericDomValue)domElement, required, domElementAnnotationHolder));
                if (list4 == null) {
                    DomHighlightingHelperImpl.a(2);
                }
                return list4;
            }
        }
        if (DomUtil.hasXml((DomElement)domElement)) {
            xmlElement = new SmartList();
            DomGenericInfo domGenericInfo = domElement.getGenericInfo();
            for (AbstractDomChildrenDescription abstractDomChildrenDescription : domGenericInfo.getChildrenDescriptions()) {
                if (!(abstractDomChildrenDescription instanceof DomCollectionChildDescription) || !abstractDomChildrenDescription.getValues(domElement).isEmpty()) continue;
                DomCollectionChildDescription domCollectionChildDescription = (DomCollectionChildDescription)abstractDomChildrenDescription;
                Required required2 = (Required)abstractDomChildrenDescription.getAnnotation(Required.class);
                if (required2 == null || !required2.value()) continue;
                xmlElement.add((Object)domElementAnnotationHolder.createProblem(domElement, domCollectionChildDescription, IdeBundle.message((String)"child.tag.0.should.be.defined", (Object[])new Object[]{((DomCollectionChildDescription)abstractDomChildrenDescription).getXmlElementName()})));
            }
            XmlElement xmlElement2 = xmlElement;
            if (xmlElement2 == null) {
                DomHighlightingHelperImpl.a(3);
            }
            return xmlElement2;
        }
        List<DomElementProblemDescriptor> list5 = Collections.emptyList();
        if (list5 == null) {
            DomHighlightingHelperImpl.a(4);
        }
        return list5;
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkResolveProblems(GenericDomValue genericDomValue, DomElementAnnotationHolder domElementAnnotationHolder) {
        XmlElement xmlElement;
        if (StringUtil.isEmpty((String)genericDomValue.getStringValue()) && (xmlElement = (Required)genericDomValue.getAnnotation(Required.class)) != null && !xmlElement.nonEmpty()) {
            List<DomElementProblemDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                DomHighlightingHelperImpl.a(5);
            }
            return list2;
        }
        xmlElement = DomUtil.getValueElement((GenericDomValue)genericDomValue);
        if (xmlElement != null && !DomHighlightingHelperImpl.a(genericDomValue)) {
            String string;
            SmartList smartList = new SmartList();
            Object[] objectArray = this.b.getReferencesByElement((PsiElement)xmlElement, new ProcessingContext());
            GenericDomValueReference genericDomValueReference = (GenericDomValueReference)((Object)ContainerUtil.findInstance((Object[])objectArray, GenericDomValueReference.class));
            Converter converter = WrappingConverter.getDeepestConverter((Converter)genericDomValue.getConverter(), (GenericDomValue)genericDomValue);
            boolean bl2 = false;
            if (genericDomValueReference == null || !DomHighlightingHelperImpl.a(genericDomValue, genericDomValueReference, converter)) {
                for (Object object : objectArray) {
                    if (object == genericDomValueReference || !DomHighlightingHelperImpl.a((PsiReference)object)) continue;
                    bl2 = true;
                    smartList.add((Object)domElementAnnotationHolder.createResolveProblem(genericDomValue, (PsiReference)object));
                }
                boolean bl3 = converter instanceof ResolvingConverter;
                if (!bl2 && (genericDomValueReference != null || bl3 && DomHighlightingHelperImpl.a(genericDomValueReference = new GenericDomValueReference(genericDomValue)))) {
                    bl2 = true;
                    String string2 = converter.getErrorMessage(genericDomValue.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)genericDomValue)));
                    if (string2 != null) {
                        smartList.add((Object)domElementAnnotationHolder.createResolveProblem(genericDomValue, genericDomValueReference));
                    }
                }
            }
            if (!bl2 && objectArray.length == 0 && genericDomValue.getValue() == null && !PsiTreeUtil.hasErrorElements((PsiElement)xmlElement) && (string = converter.getErrorMessage(genericDomValue.getStringValue(), ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)genericDomValue)))) != null) {
                smartList.add((Object)domElementAnnotationHolder.createProblem((DomElement)genericDomValue, string, new LocalQuickFix[0]));
            }
            SmartList smartList2 = smartList;
            if (smartList2 == null) {
                DomHighlightingHelperImpl.a(6);
            }
            return smartList2;
        }
        List<DomElementProblemDescriptor> list3 = Collections.emptyList();
        if (list3 == null) {
            DomHighlightingHelperImpl.a(7);
        }
        return list3;
    }

    private static boolean a(GenericDomValue genericDomValue, GenericDomValueReference genericDomValueReference, Converter converter) {
        return !DomHighlightingHelperImpl.a((PsiReference)genericDomValueReference) || converter instanceof ResolvingConverter && ((ResolvingConverter)converter).getAdditionalVariants(genericDomValueReference.getConvertContext()).contains(genericDomValue.getStringValue());
    }

    @NotNull
    public List<DomElementProblemDescriptor> checkNameIdentity(DomElement domElement, DomElementAnnotationHolder domElementAnnotationHolder) {
        DomElement domElement2;
        String string = ElementPresentationManager.getElementName((Object)domElement);
        if (StringUtil.isNotEmpty((String)string) && (domElement2 = DomUtil.findDuplicateNamedValue((DomElement)domElement, (String)string)) != null) {
            String string2 = ElementPresentationManager.getTypeNameForObject((Object)domElement);
            GenericDomValue genericDomValue = domElement2.getGenericInfo().getNameDomElement(domElement);
            if (genericDomValue != null) {
                List<DomElementProblemDescriptor> list2 = Collections.singletonList(domElementAnnotationHolder.createProblem((DomElement)genericDomValue, DomUtil.getFile((DomElement)domElement2).equals(DomUtil.getFile((DomElement)domElement)) ? IdeBundle.message((String)"model.highlighting.identity", (Object[])new Object[]{string2}) : IdeBundle.message((String)"model.highlighting.identity.in.other.file", (Object[])new Object[]{string2, domElement2.getXmlTag().getContainingFile().getName()}), new LocalQuickFix[0]));
                if (list2 == null) {
                    DomHighlightingHelperImpl.a(8);
                }
                return list2;
            }
        }
        List<DomElementProblemDescriptor> list3 = Collections.emptyList();
        if (list3 == null) {
            DomHighlightingHelperImpl.a(9);
        }
        return list3;
    }

    private static boolean a(PsiReference psiReference) {
        return XmlHighlightVisitor.hasBadResolve((PsiReference)psiReference, (boolean)true);
    }

    private static boolean a(GenericDomValue genericDomValue) {
        Resolve resolve = (Resolve)genericDomValue.getAnnotation(Resolve.class);
        if (resolve != null && resolve.soft()) {
            return true;
        }
        Convert convert = (Convert)genericDomValue.getAnnotation(Convert.class);
        if (convert != null && convert.soft()) {
            return true;
        }
        Referencing referencing = (Referencing)genericDomValue.getAnnotation(Referencing.class);
        return referencing != null && referencing.soft();
    }

    @Nullable
    private static DomElementProblemDescriptor a(GenericDomValue genericDomValue, Required required, DomElementAnnotationHolder domElementAnnotationHolder) {
        String string = genericDomValue.getStringValue();
        if (string == null) {
            return null;
        }
        if (required.nonEmpty() && DomHighlightingHelperImpl.a(genericDomValue, string)) {
            return domElementAnnotationHolder.createProblem((DomElement)genericDomValue, IdeBundle.message((String)"value.must.not.be.empty", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        if (required.identifier() && !DomHighlightingHelperImpl.a(string)) {
            return domElementAnnotationHolder.createProblem((DomElement)genericDomValue, IdeBundle.message((String)"value.must.be.identifier", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
        return null;
    }

    private static boolean a(String string) {
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < string.length(); ++i2) {
            if (Character.isJavaIdentifierPart(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean a(GenericDomValue genericDomValue, String string) {
        XmlAttributeValue xmlAttributeValue;
        if (string.trim().length() != 0) {
            return false;
        }
        return !(genericDomValue instanceof GenericAttributeValue) || (xmlAttributeValue = ((GenericAttributeValue)genericDomValue).getXmlAttributeValue()) == null || !xmlAttributeValue.getTextRange().isEmpty();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkRequired";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkResolveProblems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNameIdentity";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class AddRequiredSubtagFix
    implements LocalQuickFix {
        private final String b;
        private final String a;

        private AddRequiredSubtagFix(@NotNull String string, @NotNull String string2) {
            if (string == null) {
                AddRequiredSubtagFix.a(0);
            }
            if (string2 == null) {
                AddRequiredSubtagFix.a(1);
            }
            this.b = string;
            this.a = string2;
        }

        @NotNull
        public String getName() {
            String string = XmlBundle.message((String)"insert.required.tag.fix", (Object[])new Object[]{this.b});
            if (string == null) {
                AddRequiredSubtagFix.a(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlBundle.message((String)"insert.required.tag.fix.family", (Object[])new Object[0]);
            if (string == null) {
                AddRequiredSubtagFix.a(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
            XmlTag xmlTag;
            if (project2 == null) {
                AddRequiredSubtagFix.a(4);
            }
            if (problemDescriptor == null) {
                AddRequiredSubtagFix.a(5);
            }
            if ((xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)problemDescriptor.getPsiElement(), XmlTag.class, (boolean)false)) != null) {
                this.a(xmlTag);
            }
        }

        private void a(XmlTag xmlTag) {
            xmlTag.add((PsiElement)xmlTag.createChildTag(this.b, this.a, null, false));
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_tagName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_tagNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/highlighting/DomHighlightingHelperImpl$AddRequiredSubtagFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

