/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemService;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.FileDescriptionCachedValueProvider;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.MockDomFileDescription;
import com.intellij.util.xml.impl.StableInvocationHandler;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomManagerImpl
extends DomManager {
    private static final Key<Object> c = Key.create((String)"MockElement");
    static final Key<WeakReference<DomFileElementImpl>> CACHED_FILE_ELEMENT = Key.create((String)"CACHED_FILE_ELEMENT");
    static final Key<DomFileDescription> MOCK_DESCRIPTION = Key.create((String)"MockDescription");
    static final SemKey<FileDescriptionCachedValueProvider> FILE_DESCRIPTION_KEY = SemKey.createKey((String)"FILE_DESCRIPTION_KEY", (SemKey[])new SemKey[0]);
    static final SemKey<DomInvocationHandler> DOM_HANDLER_KEY = SemKey.createKey((String)"DOM_HANDLER_KEY", (SemKey[])new SemKey[0]);
    static final SemKey<IndexedElementInvocationHandler> DOM_INDEXED_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_INDEXED_HANDLER_KEY", new SemKey[0]);
    static final SemKey<CollectionElementInvocationHandler> DOM_COLLECTION_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_COLLECTION_HANDLER_KEY", new SemKey[0]);
    static final SemKey<CollectionElementInvocationHandler> DOM_CUSTOM_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_CUSTOM_HANDLER_KEY", new SemKey[0]);
    static final SemKey<AttributeChildInvocationHandler> DOM_ATTRIBUTE_HANDLER_KEY = DOM_HANDLER_KEY.subKey("DOM_ATTRIBUTE_HANDLER_KEY", new SemKey[0]);
    private final EventDispatcher<DomEventListener> f = EventDispatcher.create(DomEventListener.class);
    private final Project d;
    private final SemService b;
    private final DomApplicationComponent e;
    private boolean a;

    public DomManagerImpl(Project project2) {
        super(project2);
        this.d = project2;
        this.b = SemService.getSemService((Project)project2);
        this.e = DomApplicationComponent.getInstance();
        final PomModel pomModel = PomManager.getModel((Project)project2);
        pomModel.addModelListener(new PomModelListener(){

            public void modelChanged(PomModelEvent pomModelEvent) {
                if (DomManagerImpl.this.a) {
                    return;
                }
                XmlChangeSet xmlChangeSet = (XmlChangeSet)pomModelEvent.getChangeSet(pomModel.getModelAspect(XmlAspect.class));
                if (xmlChangeSet != null) {
                    for (XmlFile xmlFile : xmlChangeSet.getChangedFiles()) {
                        DomFileElementImpl domFileElementImpl = DomManagerImpl.getCachedFileElement(xmlFile);
                        if (domFileElementImpl == null) continue;
                        DomManagerImpl.this.fireEvent(new DomEvent(domFileElementImpl, false));
                    }
                }
            }

            public boolean isAspectChangeInteresting(PomModelAspect pomModelAspect) {
                return pomModelAspect instanceof XmlAspect;
            }
        }, (Disposable)project2);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){
            private final List<DomEvent> a = new SmartList();

            public void contentsChanged(@NotNull VirtualFileEvent virtualFileEvent) {
                if (virtualFileEvent == null) {
                    2.a(0);
                }
                if (!virtualFileEvent.isFromSave()) {
                    DomManagerImpl.this.a(DomManagerImpl.this.b(virtualFileEvent.getFile()));
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent virtualFileMoveEvent) {
                if (virtualFileMoveEvent == null) {
                    2.a(1);
                }
                DomManagerImpl.this.a(DomManagerImpl.this.b(virtualFileMoveEvent.getFile()));
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent virtualFileEvent) {
                if (virtualFileEvent == null) {
                    2.a(2);
                }
                this.a.addAll(DomManagerImpl.this.b(virtualFileEvent.getFile()));
            }

            public void fileDeleted(@NotNull VirtualFileEvent virtualFileEvent) {
                if (virtualFileEvent == null) {
                    2.a(3);
                }
                if (!this.a.isEmpty()) {
                    DomManagerImpl.this.a(this.a);
                    this.a.clear();
                }
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent virtualFilePropertyEvent) {
                VirtualFile virtualFile;
                if (virtualFilePropertyEvent == null) {
                    2.a(4);
                }
                if (!(virtualFile = virtualFilePropertyEvent.getFile()).isDirectory() && "name".equals(virtualFilePropertyEvent.getPropertyName())) {
                    DomManagerImpl.this.a(DomManagerImpl.this.b(virtualFile));
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileDeletion";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.d);
    }

    public long getPsiModificationCount() {
        return PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    public <T extends DomInvocationHandler> void cacheHandler(SemKey<T> semKey, XmlElement xmlElement, T t2) {
        this.b.setCachedSemElement(semKey, (PsiElement)xmlElement, t2);
    }

    private PsiFile a(VirtualFile virtualFile) {
        return PsiManagerEx.getInstanceEx((Project)this.d).getFileManager().getCachedPsiFile(virtualFile);
    }

    private List<DomEvent> b(VirtualFile virtualFile) {
        if (!(virtualFile instanceof NewVirtualFile) || this.d.isDisposed()) {
            return Collections.emptyList();
        }
        final ArrayList arrayList = ContainerUtil.newArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile virtualFile) {
                DomFileElementImpl domFileElementImpl;
                PsiFile psiFile;
                if (virtualFile == null) {
                    3.a(0);
                }
                if (DomManagerImpl.this.d.isDisposed() || !ProjectFileIndex.SERVICE.getInstance((Project)DomManagerImpl.this.d).isInContent(virtualFile)) {
                    return false;
                }
                if (!virtualFile.isDirectory() && StdFileTypes.XML == virtualFile.getFileType() && (psiFile = DomManagerImpl.this.a(virtualFile)) != null && StdFileTypes.XML.equals(psiFile.getFileType()) && psiFile instanceof XmlFile && (domFileElementImpl = DomManagerImpl.getCachedFileElement((XmlFile)psiFile)) != null) {
                    arrayList.add(new DomEvent(domFileElementImpl, false));
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    3.a(1);
                }
                return ((NewVirtualFile)virtualFile).getCachedChildren();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return arrayList;
    }

    public static DomManagerImpl getDomManager(Project project2) {
        return (DomManagerImpl)DomManager.getDomManager((Project)project2);
    }

    public void addDomEventListener(DomEventListener domEventListener, Disposable disposable) {
        this.f.addListener((EventListener)domEventListener, disposable);
    }

    public final ConverterManager getConverterManager() {
        return (ConverterManager)ServiceManager.getService(ConverterManager.class);
    }

    public final ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    final void fireEvent(DomEvent domEvent) {
        if (this.b.isInsideAtomicChange()) {
            return;
        }
        this.incModificationCount();
        ((DomEventListener)this.f.getMulticaster()).eventOccured(domEvent);
    }

    private void a(Collection<DomEvent> collection) {
        for (DomEvent domEvent : collection) {
            this.fireEvent(domEvent);
        }
    }

    public final DomGenericInfo getGenericInfo(Type type) {
        return this.e.getStaticGenericInfo(type);
    }

    @Nullable
    public static DomInvocationHandler getDomInvocationHandler(DomElement domElement) {
        if (domElement instanceof DomFileElement) {
            return null;
        }
        if (domElement instanceof DomInvocationHandler) {
            return (DomInvocationHandler)domElement;
        }
        InvocationHandler invocationHandler = AdvancedProxy.getInvocationHandler((Object)domElement);
        if (invocationHandler instanceof StableInvocationHandler) {
            DomElement domElement2 = (DomElement)((StableInvocationHandler)invocationHandler).getWrappedElement();
            return domElement2 == null ? null : DomManagerImpl.getDomInvocationHandler(domElement2);
        }
        if (invocationHandler instanceof DomInvocationHandler) {
            return (DomInvocationHandler)invocationHandler;
        }
        return null;
    }

    @NotNull
    public static DomInvocationHandler getNotNullHandler(DomElement domElement) {
        DomInvocationHandler domInvocationHandler = DomManagerImpl.getDomInvocationHandler(domElement);
        if (domInvocationHandler == null) {
            throw new AssertionError((Object)("null handler for " + domElement));
        }
        DomInvocationHandler domInvocationHandler2 = domInvocationHandler;
        if (domInvocationHandler2 == null) {
            DomManagerImpl.a(0);
        }
        return domInvocationHandler2;
    }

    public static StableInvocationHandler getStableInvocationHandler(Object object) {
        return (StableInvocationHandler)AdvancedProxy.getInvocationHandler((Object)object);
    }

    public DomApplicationComponent getApplicationComponent() {
        return this.e;
    }

    public final Project getProject() {
        return this.d;
    }

    @NotNull
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile xmlFile, Class<T> clazz, String string) {
        if (xmlFile.getUserData(MOCK_DESCRIPTION) == null) {
            xmlFile.putUserData(MOCK_DESCRIPTION, new MockDomFileDescription<T>(clazz, string, xmlFile.getViewProvider().getVirtualFile()));
            this.b.clearCache();
        }
        DomFileElement domFileElement = this.getFileElement(xmlFile);
        assert (domFileElement != null);
        DomFileElement domFileElement2 = domFileElement;
        if (domFileElement2 == null) {
            DomManagerImpl.a(1);
        }
        return domFileElement2;
    }

    @NotNull
    final <T extends DomElement> FileDescriptionCachedValueProvider<T> getOrCreateCachedValueProvider(XmlFile xmlFile) {
        FileDescriptionCachedValueProvider fileDescriptionCachedValueProvider = (FileDescriptionCachedValueProvider)this.b.getSemElement(FILE_DESCRIPTION_KEY, (PsiElement)xmlFile);
        if (fileDescriptionCachedValueProvider == null) {
            DomManagerImpl.a(2);
        }
        return fileDescriptionCachedValueProvider;
    }

    public final Set<DomFileDescription> getFileDescriptions(String string) {
        return this.e.getFileDescriptions(string);
    }

    public final Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return this.e.getAcceptingOtherRootTagNameDescriptions();
    }

    @NotNull
    @NonNls
    public final String getComponentName() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DomManagerImpl.a(3);
        }
        return string;
    }

    final void runChange(Runnable runnable) {
        boolean bl2 = this.setChanging(true);
        try {
            runnable.run();
        }
        finally {
            this.setChanging(bl2);
        }
    }

    final boolean setChanging(boolean bl2) {
        boolean bl3 = this.a;
        if (bl2) assert (!bl3);
        this.a = bl2;
        return bl3;
    }

    @Nullable
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(@Nullable XmlFile xmlFile) {
        if (xmlFile == null) {
            return null;
        }
        if (!(xmlFile.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        if (virtualFile != null && virtualFile.isDirectory()) {
            return null;
        }
        return this.getOrCreateCachedValueProvider(xmlFile).getFileElement();
    }

    @Nullable
    static <T extends DomElement> DomFileElementImpl<T> getCachedFileElement(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            DomManagerImpl.a(4);
        }
        return (DomFileElementImpl)SoftReference.dereference((Reference)((Reference)xmlFile.getUserData(CACHED_FILE_ELEMENT)));
    }

    @Nullable
    public final <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile xmlFile, Class<T> clazz) {
        DomFileDescription domFileDescription = this.getDomFileDescription(xmlFile);
        if (domFileDescription != null && this.e.assignabilityCache.isAssignable(clazz, domFileDescription.getRootElementClass())) {
            return this.getFileElement(xmlFile);
        }
        return null;
    }

    @Nullable
    public final DomElement getDomElement(XmlTag xmlTag) {
        if (this.a) {
            return null;
        }
        DomInvocationHandler domInvocationHandler = this.getDomHandler((XmlElement)xmlTag);
        return domInvocationHandler != null ? domInvocationHandler.getProxy() : null;
    }

    @Nullable
    public GenericAttributeValue getDomElement(XmlAttribute xmlAttribute) {
        if (this.a) {
            return null;
        }
        AttributeChildInvocationHandler attributeChildInvocationHandler = (AttributeChildInvocationHandler)this.b.getSemElement(DOM_ATTRIBUTE_HANDLER_KEY, (PsiElement)xmlAttribute);
        return attributeChildInvocationHandler == null ? null : (GenericAttributeValue)attributeChildInvocationHandler.getProxy();
    }

    @Nullable
    public DomInvocationHandler getDomHandler(XmlElement xmlElement) {
        if (xmlElement == null) {
            return null;
        }
        List list2 = this.b.getCachedSemElements(DOM_HANDLER_KEY, (PsiElement)xmlElement);
        if (list2 != null && !list2.isEmpty()) {
            return (DomInvocationHandler)((Object)list2.get(0));
        }
        return (DomInvocationHandler)this.b.getSemElement(DOM_HANDLER_KEY, (PsiElement)xmlElement);
    }

    @Nullable
    public AbstractDomChildrenDescription findChildrenDescription(@NotNull XmlTag xmlTag, @NotNull DomElement domElement) {
        if (xmlTag == null) {
            DomManagerImpl.a(5);
        }
        if (domElement == null) {
            DomManagerImpl.a(6);
        }
        return DomManagerImpl.findChildrenDescription(xmlTag, DomManagerImpl.getDomInvocationHandler(domElement));
    }

    static AbstractDomChildrenDescription findChildrenDescription(XmlTag xmlTag, DomInvocationHandler domInvocationHandler) {
        DomGenericInfoEx domGenericInfoEx = domInvocationHandler.getGenericInfo();
        return domGenericInfoEx.findChildrenDescription(domInvocationHandler, xmlTag.getLocalName(), xmlTag.getNamespace(), false, xmlTag.getName());
    }

    public final boolean isDomFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof XmlFile && this.getFileElement((XmlFile)psiFile) != null;
    }

    @Nullable
    public final DomFileDescription<?> getDomFileDescription(PsiElement psiElement) {
        PsiFile psiFile;
        if (psiElement instanceof XmlElement && (psiFile = psiElement.getContainingFile()) instanceof XmlFile) {
            return this.getDomFileDescription((XmlFile)psiFile);
        }
        return null;
    }

    public final <T extends DomElement> T createMockElement(Class<T> clazz, Module module2, boolean bl2) {
        XmlFile xmlFile = (XmlFile)PsiFileFactory.getInstance((Project)this.d).createFileFromText("a.xml", (FileType)StdFileTypes.XML, (CharSequence)"", 0L, bl2);
        xmlFile.putUserData(MOCK_ELEMENT_MODULE, (Object)module2);
        xmlFile.putUserData(c, new Object());
        return this.getFileElement(xmlFile, (Class)clazz, "I_sincerely_hope_that_nobody_will_have_such_a_root_tag_name").getRootElement();
    }

    public final boolean isMockElement(DomElement domElement) {
        return DomUtil.getFile((DomElement)domElement).getUserData(c) != null;
    }

    public final <T extends DomElement> T createStableValue(Factory<T> factory) {
        return (T)((DomElement)this.createStableValue(factory, domElement -> domElement.isValid()));
    }

    public final <T> T createStableValue(Factory<T> factory, Condition<T> condition) {
        Object object = factory.create();
        assert (object != null);
        StableInvocationHandler<Object> stableInvocationHandler = new StableInvocationHandler<Object>(object, factory, condition);
        HashSet<Class<StableElement>> hashSet = new HashSet<Class<StableElement>>();
        ContainerUtil.addAll(hashSet, (Object[])object.getClass().getInterfaces());
        hashSet.add(StableElement.class);
        return (T)AdvancedProxy.createProxy(object.getClass().getSuperclass(), (Class[])hashSet.toArray(ArrayUtil.EMPTY_CLASS_ARRAY), stableInvocationHandler, (Object[])new Object[0]);
    }

    public final <T extends DomElement> void registerFileDescription(final DomFileDescription<T> domFileDescription, Disposable disposable) {
        this.registerFileDescription(domFileDescription);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                DomManagerImpl.this.getFileDescriptions(domFileDescription.getRootTagName()).remove(domFileDescription);
                DomManagerImpl.this.getAcceptingOtherRootTagNameDescriptions().remove(domFileDescription);
            }
        });
    }

    public final void registerFileDescription(DomFileDescription domFileDescription) {
        this.b.clearCache();
        this.e.registerFileDescription(domFileDescription);
    }

    @NotNull
    public final DomElement getResolvingScope(GenericDomValue genericDomValue) {
        DomFileDescription domFileDescription = DomUtil.getFileElement((DomElement)genericDomValue).getFileDescription();
        DomElement domElement = domFileDescription.getResolveScope(genericDomValue);
        if (domElement == null) {
            DomManagerImpl.a(7);
        }
        return domElement;
    }

    @Nullable
    public final DomElement getIdentityScope(DomElement domElement) {
        DomFileDescription domFileDescription = DomUtil.getFileElement((DomElement)domElement).getFileDescription();
        return domFileDescription.getIdentityScope(domElement);
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.e.getTypeChooserManager();
    }

    public void performAtomicChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            DomManagerImpl.a(8);
        }
        this.b.performAtomicChange(runnable);
        if (!this.b.isInsideAtomicChange()) {
            this.incModificationCount();
        }
    }

    public SemService getSemService() {
        return this.b;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCachedValueProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvingScope";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenDescription";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performAtomicChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

