/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.XmlUtil;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileDescriptionCachedValueProvider<T extends DomElement>
implements SemElement {
    private final XmlFile d;
    private volatile boolean c;
    private volatile DomFileElementImpl<T> e;
    private final MyCondition f = new MyCondition();
    private final DomManagerImpl a;
    private final DomService b;

    public FileDescriptionCachedValueProvider(DomManagerImpl domManagerImpl, XmlFile xmlFile) {
        this.a = domManagerImpl;
        this.d = xmlFile;
        this.b = DomService.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DomFileElementImpl<T> getFileElement() {
        if (this.c) {
            return this.e;
        }
        DomFileElementImpl<T> domFileElementImpl = this.a(false, this.b.getXmlFileHeader(this.d), null);
        MyCondition myCondition = this.f;
        synchronized (myCondition) {
            if (this.c) {
                return this.e;
            }
            this.e = domFileElementImpl;
            WeakReference<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<T>>>>> weakReference = domFileElementImpl != null ? new WeakReference<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<T>>>>>(domFileElementImpl) : null;
            this.d.putUserData(DomManagerImpl.CACHED_FILE_ELEMENT, weakReference);
            this.c = true;
            return domFileElementImpl;
        }
    }

    @Nullable
    private DomFileElementImpl<T> a(boolean bl2, @NotNull XmlFileHeader xmlFileHeader, @Nullable StringBuilder stringBuilder) {
        ObjectStubTree objectStubTree;
        SmartList smartList;
        if (xmlFileHeader == null) {
            FileDescriptionCachedValueProvider.a(0);
        }
        if (stringBuilder != null) {
            stringBuilder.append(xmlFileHeader).append("\n");
        }
        if (!this.d.isValid()) {
            return null;
        }
        if (stringBuilder != null) {
            stringBuilder.append("File is valid\n");
        }
        if (!(this.d.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        if (stringBuilder != null) {
            stringBuilder.append("File is of dom file type\n");
        }
        DomFileDescription<T> domFileDescription = this.a(xmlFileHeader, stringBuilder);
        DomFileElementImpl<T> domFileElementImpl = this.getLastValue();
        if (stringBuilder != null) {
            stringBuilder.append("last " + domFileElementImpl + "\n");
        }
        SmartList smartList2 = smartList = bl2 ? new SmartList() : Collections.emptyList();
        if (domFileElementImpl != null && bl2) {
            smartList.add(new DomEvent(domFileElementImpl, false));
        }
        if (domFileDescription == null) {
            return null;
        }
        Class clazz = domFileDescription.getRootElementClass();
        XmlName xmlName = DomImplUtil.createXmlName(domFileDescription.getRootTagName(), clazz, null);
        assert (xmlName != null);
        EvaluatedXmlNameImpl evaluatedXmlNameImpl = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)xmlName, (String)xmlName.getNamespaceKey(), (boolean)false);
        VirtualFile virtualFile = this.d.getVirtualFile();
        FileStub fileStub = null;
        if (domFileDescription.hasStubs() && virtualFile instanceof VirtualFileWithId && !this.a()) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!XmlUtil.isStubBuilding() && (objectStubTree = StubTreeLoader.getInstance().readOrBuild(this.d.getProject(), virtualFile, (PsiFile)this.d)) != null) {
                fileStub = (FileStub)objectStubTree.getRoot();
            }
        }
        objectStubTree = new DomFileElementImpl(this.d, clazz, evaluatedXmlNameImpl, this.a, domFileDescription, fileStub);
        if (stringBuilder != null) {
            stringBuilder.append("success " + objectStubTree + "\n");
        }
        if (bl2) {
            smartList.add(new DomEvent((DomElement)objectStubTree, true));
        }
        return objectStubTree;
    }

    private boolean a() {
        return this.d instanceof PsiFileEx && ((PsiFileEx)this.d).isContentsLoaded();
    }

    @Nullable
    private DomFileDescription<T> a(XmlFileHeader xmlFileHeader, @Nullable StringBuilder stringBuilder) {
        DomFileDescription domFileDescription;
        DomFileDescription domFileDescription2 = (DomFileDescription)this.d.getUserData(DomManagerImpl.MOCK_DESCRIPTION);
        if (domFileDescription2 != null) {
            return domFileDescription2;
        }
        if (stringBuilder != null) {
            stringBuilder.append("no mock\n");
        }
        XmlFile xmlFile = (XmlFile)this.d.getOriginalFile();
        if (stringBuilder != null) {
            stringBuilder.append("original: " + xmlFile + "\n");
        }
        if (!xmlFile.equals(this.d)) {
            FileDescriptionCachedValueProvider fileDescriptionCachedValueProvider = this.a.getOrCreateCachedValueProvider(xmlFile);
            DomFileElementImpl domFileElementImpl = fileDescriptionCachedValueProvider.getFileElement();
            if (stringBuilder != null) {
                stringBuilder.append("originalDom " + domFileElementImpl + "\n");
            }
            return domFileElementImpl == null ? null : domFileElementImpl.getFileDescription();
        }
        Set<DomFileDescription> set = this.a.getFileDescriptions(xmlFileHeader.getRootTagLocalName());
        if (stringBuilder != null) {
            stringBuilder.append("named " + new HashSet<DomFileDescription>(set) + "\n");
        }
        if ((domFileDescription = (DomFileDescription)ContainerUtil.find(set, (Condition)this.f)) == null) {
            Set<DomFileDescription> set2 = this.a.getAcceptingOtherRootTagNameDescriptions();
            domFileDescription = (DomFileDescription)ContainerUtil.find(set2, (Condition)this.f);
        }
        if (stringBuilder != null) {
            stringBuilder.append("found " + domFileDescription + "\n");
        }
        return domFileDescription;
    }

    @Nullable
    final DomFileElementImpl<T> getLastValue() {
        return this.e;
    }

    public String getFileElementWithLogging() {
        XmlFileHeader xmlFileHeader = this.b.getXmlFileHeader(this.d);
        StringBuilder stringBuilder = new StringBuilder();
        this.e = this.a(false, xmlFileHeader, stringBuilder);
        return stringBuilder.toString();
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTagName", "com/intellij/util/xml/impl/FileDescriptionCachedValueProvider", "_computeFileElement"));
    }

    private class MyCondition
    implements Condition<DomFileDescription> {
        public Module module;

        private MyCondition() {
        }

        public boolean value(DomFileDescription domFileDescription) {
            return domFileDescription.isMyFile(FileDescriptionCachedValueProvider.this.d, this.module);
        }
    }
}

