/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.Implementation;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.SofterCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

class ImplementationClassCache {
    private static final Comparator<Class> b = (clazz, clazz2) -> {
        if (clazz.isAssignableFrom((Class<?>)clazz2)) {
            return 1;
        }
        if (clazz2.isAssignableFrom((Class<?>)clazz)) {
            return -1;
        }
        if (clazz.equals(clazz2)) {
            return 0;
        }
        throw new AssertionError((Object)("Incompatible implementation classes: " + clazz + " & " + clazz2));
    };
    private final MultiMap<String, DomImplementationClassEP> a = new MultiMap();
    private final SofterCache<Class, Class> c = SofterCache.create(clazz -> this.a((Class)clazz));

    ImplementationClassCache(ExtensionPointName<DomImplementationClassEP> extensionPointName) {
        for (DomImplementationClassEP domImplementationClassEP : (DomImplementationClassEP[])extensionPointName.getExtensions()) {
            this.a.putValue((Object)domImplementationClassEP.interfaceName, (Object)domImplementationClassEP);
        }
    }

    private Class a(Class clazz) {
        TreeSet<Class> treeSet = new TreeSet<Class>(b);
        this.a(clazz, treeSet);
        if (!treeSet.isEmpty()) {
            return treeSet.first();
        }
        Implementation implementation = (Implementation)DomReflectionUtil.findAnnotationDFS((Class)clazz, Implementation.class);
        return implementation == null ? clazz : implementation.value();
    }

    private void a(Class clazz, SortedSet<Class> sortedSet) {
        Collection collection = this.a.get((Object)clazz.getName());
        for (DomImplementationClassEP domImplementationClassEP : collection) {
            if (domImplementationClassEP.getInterfaceClass() != clazz) continue;
            sortedSet.add(domImplementationClassEP.getImplementationClass());
            return;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.a(clazz2, sortedSet);
        }
    }

    public final void registerImplementation(final Class clazz, final Class clazz2, @Nullable Disposable disposable) {
        DomImplementationClassEP domImplementationClassEP = new DomImplementationClassEP(){

            @Override
            public Class getInterfaceClass() {
                return clazz;
            }

            @Override
            public Class getImplementationClass() {
                return clazz2;
            }
        };
        this.a.putValue((Object)clazz.getName(), (Object)domImplementationClassEP);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    ImplementationClassCache.this.a.remove((Object)clazz.getName());
                }
            });
        }
        this.c.clearCache();
    }

    public Class get(Class clazz) {
        Class clazz2 = this.c.getCachedValue(clazz);
        return clazz2 == clazz ? null : clazz2;
    }
}

