/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.impl.VirtualDomParentStrategy;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubParentStrategy
implements DomParentStrategy {
    private static final Logger a = Logger.getInstance(StubParentStrategy.class);
    protected final DomStub myStub;

    public StubParentStrategy(@NotNull DomStub domStub) {
        if (domStub == null) {
            StubParentStrategy.a(0);
        }
        this.myStub = domStub;
    }

    public static StubParentStrategy createAttributeStrategy(@Nullable AttributeStub attributeStub, @NotNull DomStub domStub) {
        if (domStub == null) {
            StubParentStrategy.a(1);
        }
        if (attributeStub == null) {
            return new Empty(domStub);
        }
        return new StubParentStrategy(attributeStub){

            @Override
            public XmlElement getXmlElement() {
                DomInvocationHandler domInvocationHandler = this.getParentHandler();
                if (domInvocationHandler == null) {
                    a.error("no parent handler for " + this);
                    return null;
                }
                XmlTag xmlTag = domInvocationHandler.getXmlTag();
                if (xmlTag == null) {
                    a.error("can't find tag for " + (Object)((Object)domInvocationHandler) + "\nparent stub: " + this.myStub.getParentStub() + "\nparent's children: " + ((DomStub)this.myStub.getParentStub()).getChildrenStubs());
                    return null;
                }
                return xmlTag.getAttribute(this.myStub.getName());
            }
        };
    }

    @Override
    public DomInvocationHandler getParentHandler() {
        DomStub domStub = (DomStub)this.myStub.getParentStub();
        return domStub == null ? null : domStub.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmlElement getXmlElement() {
        XmlTag[] xmlTagArray;
        DomStub domStub = (DomStub)this.myStub.getParentStub();
        if (domStub == null) {
            return null;
        }
        List<DomStub> list2 = domStub.getChildrenStubs();
        if (list2.isEmpty()) {
            return null;
        }
        XmlTag xmlTag = domStub.getHandler().getXmlTag();
        if (xmlTag == null) {
            return null;
        }
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(true);
            xmlTagArray = xmlTag.getSubTags();
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(false);
        }
        int n2 = 0;
        String string = this.myStub.getName();
        for (XmlTag xmlTag2 : xmlTagArray) {
            if (!string.equals(xmlTag2.getName()) || this.myStub.getIndex() != n2++) continue;
            return xmlTag2;
        }
        return null;
    }

    @Override
    @NotNull
    public DomParentStrategy refreshStrategy(DomInvocationHandler domInvocationHandler) {
        StubParentStrategy stubParentStrategy = this;
        if (stubParentStrategy == null) {
            StubParentStrategy.a(2);
        }
        return stubParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement xmlElement) {
        if (xmlElement == null) {
            StubParentStrategy.a(3);
        }
        PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(xmlElement, DomManagerImpl.getDomManager(xmlElement.getProject()));
        if (physicalDomParentStrategy == null) {
            StubParentStrategy.a(4);
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy clearXmlElement() {
        DomInvocationHandler domInvocationHandler = this.getParentHandler();
        assert (domInvocationHandler != null) : "write operations should be performed on the DOM having a parent, your DOM may be not very fresh";
        VirtualDomParentStrategy virtualDomParentStrategy = new VirtualDomParentStrategy(domInvocationHandler);
        if (virtualDomParentStrategy == null) {
            StubParentStrategy.a(5);
        }
        return virtualDomParentStrategy;
    }

    @Override
    public String checkValidity() {
        return null;
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler domInvocationHandler) {
        return this.getParentHandler().getFile();
    }

    @Override
    public boolean isPhysical() {
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StubParentStrategy)) {
            return PhysicalDomParentStrategy.strategyEquals(this, object);
        }
        if (object == this) {
            return true;
        }
        StubParentStrategy stubParentStrategy = (StubParentStrategy)object;
        if (!stubParentStrategy.getClass().equals(this.getClass())) {
            return false;
        }
        if (!stubParentStrategy.myStub.equals((Object)this.myStub)) {
            return false;
        }
        return Comparing.equal((Object)this.getContainingFile(this.myStub.getHandler()), (Object)stubParentStrategy.getContainingFile(stubParentStrategy.myStub.getHandler()));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/stubs/StubParentStrategy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/stubs/StubParentStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setXmlElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "clearXmlElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeStrategy";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setXmlElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Empty
    extends StubParentStrategy {
        private final DomStub b;

        public Empty(DomStub domStub) {
            super(domStub);
            this.b = domStub;
        }

        @Override
        public DomInvocationHandler getParentHandler() {
            return this.b.getHandler();
        }

        @Override
        public XmlElement getXmlElement() {
            return null;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }
    }
}

