/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentLineDataBuilder
extends CommentLineDataBuilder {
    private PsiComment f;
    private IElementType e;
    private static final String d = "//";
    private TextRange h;
    private CommonCodeStyleSettings.IndentOptions c;
    @Nullable
    private TextRange g;
    private int b;

    public LineCommentLineDataBuilder(@NotNull PsiComment psiComment, IElementType iElementType, @NotNull CommonCodeStyleSettings commonCodeStyleSettings, @Nullable TextRange textRange) {
        if (psiComment == null) {
            LineCommentLineDataBuilder.a(0);
        }
        if (commonCodeStyleSettings == null) {
            LineCommentLineDataBuilder.a(1);
        }
        super(commonCodeStyleSettings.getRootSettings());
        this.f = psiComment;
        this.e = iElementType;
        this.c = commonCodeStyleSettings.getIndentOptions() != null ? commonCodeStyleSettings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
        this.g = textRange;
    }

    public boolean isMergedWithPrevious(@NotNull PsiComment psiComment) {
        if (psiComment == null) {
            LineCommentLineDataBuilder.a(2);
        }
        if (this.isAfterNonEmptyLine(psiComment.getNode()) || this.getFormatterTag(psiComment) != FormatterTagHandler.FormatterTag.NONE) {
            return false;
        }
        PsiElement psiElement = psiComment.getPrevSibling();
        if (psiElement instanceof PsiWhiteSpace) {
            PsiElement psiElement2 = psiElement;
            if ((psiElement = psiElement.getPrevSibling()) != null && psiElement.getNode().getElementType() == this.e && LineCommentLineDataBuilder.countLineBreaks(psiElement2.getNode()) == 1) {
                int n2;
                if (this.g != null && psiElement.getTextRange().getEndOffset() < this.g.getStartOffset() || psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE) {
                    return false;
                }
                int n3 = this.calcBlockLineIndent(psiComment.getNode());
                return n3 == (n2 = this.calcBlockLineIndent(psiElement.getNode()));
            }
        }
        return false;
    }

    @Override
    public List<CommentLineData> getLines() {
        ArrayList<CommentLineData> arrayList = new ArrayList<CommentLineData>();
        int n2 = this.f.getTextRange().getStartOffset();
        int n3 = this.f.getTextRange().getEndOffset();
        int n4 = this.calcBlockLineIndent(this.f.getNode());
        this.a(arrayList, (PsiElement)this.f, n4, true);
        for (PsiElement psiElement = this.f.getNextSibling(); psiElement != null && (this.g == null || psiElement.getTextRange().getStartOffset() <= this.g.getEndOffset()); psiElement = psiElement.getNextSibling()) {
            if (psiElement.getNode().getElementType() == this.e) {
                int n5;
                if (psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE || (n5 = this.calcBlockLineIndent(psiElement.getNode())) != n4) break;
                n3 = psiElement.getTextRange().getEndOffset();
                this.a(arrayList, psiElement, n4, false);
                continue;
            }
            if (!(psiElement instanceof PsiWhiteSpace) || LineCommentLineDataBuilder.countLineBreaks(psiElement.getNode()) > 1) break;
        }
        this.h = new TextRange(n2, n3);
        return arrayList;
    }

    public TextRange getCommentBlockRange() {
        return this.h;
    }

    private void a(List<CommentLineData> list2, @NotNull PsiElement psiElement, int n2, boolean bl2) {
        if (psiElement == null) {
            LineCommentLineDataBuilder.a(3);
        }
        String string = new String(CharArrayUtil.fromSequence((CharSequence)psiElement.getNode().getChars()));
        LineCommentLineData lineCommentLineData = (LineCommentLineData)this.parseLine(string);
        lineCommentLineData.b = n2;
        lineCommentLineData.c = bl2;
        list2.add(lineCommentLineData);
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String string) {
        int n2;
        if (string == null) {
            LineCommentLineDataBuilder.a(4);
        }
        LineCommentLineData lineCommentLineData = new LineCommentLineData(string);
        lineCommentLineData.commentOffset = LineCommentLineDataBuilder.nextNonWhitespace(string, 0);
        if (lineCommentLineData.commentOffset >= 0 && (n2 = lineCommentLineData.commentOffset + d.length()) < string.length()) {
            lineCommentLineData.textStartOffset = LineCommentLineDataBuilder.nextNonWhitespace(string, n2);
        }
        LineCommentLineData lineCommentLineData2 = lineCommentLineData;
        if (lineCommentLineData2 == null) {
            LineCommentLineDataBuilder.a(5);
        }
        return lineCommentLineData2;
    }

    public boolean isAfterNonEmptyLine(@NotNull ASTNode aSTNode) {
        ASTNode aSTNode2;
        if (aSTNode == null) {
            LineCommentLineDataBuilder.a(6);
        }
        if (aSTNode.getElementType() == this.e && (aSTNode2 = aSTNode.getTreePrev()) != null) {
            return !(aSTNode2.getPsi() instanceof PsiWhiteSpace) || !aSTNode2.textContains('\n');
        }
        return false;
    }

    public static int countLineBreaks(@NotNull ASTNode aSTNode) {
        if (aSTNode == null) {
            LineCommentLineDataBuilder.a(7);
        }
        CharSequence charSequence = aSTNode.getChars();
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) != '\n') continue;
            ++n2;
        }
        return n2;
    }

    public int calcBlockLineIndent(@NotNull ASTNode aSTNode) {
        ASTNode aSTNode2;
        if (aSTNode == null) {
            LineCommentLineDataBuilder.a(8);
        }
        int n2 = 0;
        for (aSTNode2 = aSTNode.getTreePrev(); aSTNode2 != null && !aSTNode2.textContains('\n'); aSTNode2 = aSTNode2.getTreePrev()) {
            n2 += aSTNode2.getTextLength();
        }
        if (aSTNode2 != null) {
            int n3 = 0;
            CharSequence charSequence = aSTNode2.getChars();
            int n4 = CharArrayUtil.shiftBackwardUntil((CharSequence)charSequence, (int)(aSTNode2.getTextLength() - 1), (String)"\r\n");
            if (n4 >= 0) {
                n3 += aSTNode2.getTextLength() - n4 - 1;
            }
            char[] cArray = CharArrayUtil.fromSequence((CharSequence)charSequence, (int)(aSTNode2.getTextLength() - n3), (int)aSTNode2.getTextLength());
            this.b = 0;
            boolean bl2 = cArray.length > 0 && cArray[0] == '\t';
            for (char c2 : cArray) {
                if (c2 == '\t' && bl2) {
                    n2 += this.c.TAB_SIZE;
                    ++this.b;
                    continue;
                }
                bl2 = false;
                ++n2;
            }
        }
        return n2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMergedWithPrevious";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addLineDataFromComment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAfterNonEmptyLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "countLineBreaks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockLineIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LineCommentLineData
    extends CommentLineData {
        private int b;
        private boolean c;

        public LineCommentLineData(String string) {
            if (string == null) {
                LineCommentLineData.b(0);
            }
            super(string);
        }

        @Override
        public int getLineLength() {
            return this.b + super.getLineLength();
        }

        @Override
        protected int calcWrapPos(int n2) {
            if (this.b < n2) {
                return super.calcWrapPos(n2 - this.b);
            }
            return -1;
        }

        public String getIndentString() {
            if (!((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).c.USE_TAB_CHARACTER) {
                return StringUtil.repeatSymbol((char)' ', (int)this.b);
            }
            int n2 = ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).c.SMART_TABS ? LineCommentLineDataBuilder.this.b : (((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).c.TAB_SIZE > 0 ? this.b / ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).c.TAB_SIZE : 0);
            int n3 = this.b - n2 * ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).c.TAB_SIZE;
            return StringUtil.repeatSymbol((char)'\t', (int)n2) + StringUtil.repeatSymbol((char)' ', (int)n3);
        }

        @Override
        @Nullable
        public Pair<String, String> splitLine(int n2) {
            Pair<String, String> pair2 = super.splitLine(n2);
            if (pair2 != null && !this.c && this.b > 0) {
                return Pair.create((Object)(this.getIndentString() + (String)pair2.first), (Object)pair2.second);
            }
            return pair2;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            String string = (this.b > 0 ? this.getIndentString() : this.line.substring(0, this.commentOffset)) + LineCommentLineDataBuilder.d;
            if (string == null) {
                LineCommentLineData.b(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return ((LineCommentLineDataBuilder)LineCommentLineDataBuilder.this).c.TAB_SIZE;
        }

        @Override
        @NotNull
        public String getLine() {
            String string = this.b > 0 && !this.c ? this.getIndentString() + this.line : this.line;
            if (string == null) {
                LineCommentLineData.b(2);
            }
            return string;
        }

        @Override
        public boolean canBeMergedWithPrevious() {
            return true;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLine";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

