/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeCellRenderer;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.actions.ContentEntryEditingAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.resourceRoots.ResourceRootIconProvider;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class WebIdeProjectStructureConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private static final Color a = JBColor.MAGENTA;
    private final Module b;
    private final JPanel c = new JPanel(new BorderLayout());
    protected ModifiableRootModel myModifiableModel;
    protected CommonContentEntriesEditor myEditor;

    public WebIdeProjectStructureConfigurable(Module module2) {
        this.b = module2;
    }

    public String getDisplayName() {
        return "Directories";
    }

    public String getHelpTopic() {
        return "reference.webide.settings.project.settings.directories";
    }

    public JComponent createComponent() {
        this.d();
        return this.c;
    }

    private void d() {
        if (this.b == null) {
            return;
        }
        this.myModifiableModel = (ModifiableRootModel)ReadAction.compute(() -> ModuleRootManager.getInstance((Module)this.b).getModifiableModel());
        ModuleConfigurationStateImpl moduleConfigurationStateImpl = new ModuleConfigurationStateImpl(this.b.getProject(), (ModulesProvider)new DefaultModulesProvider(this.b.getProject())){

            public ModifiableRootModel getRootModel() {
                return WebIdeProjectStructureConfigurable.this.myModifiableModel;
            }
        };
        this.myEditor = this.createEditor(this.b, (ModuleConfigurationState)moduleConfigurationStateImpl);
        JComponent jComponent = (JComponent)ReadAction.compute(() -> this.myEditor.createComponent());
        this.c.add((Component)jComponent, "Center");
    }

    protected CommonContentEntriesEditor createEditor(@NotNull Module module2, @NotNull ModuleConfigurationState moduleConfigurationState) {
        if (module2 == null) {
            WebIdeProjectStructureConfigurable.a(0);
        }
        if (moduleConfigurationState == null) {
            WebIdeProjectStructureConfigurable.a(1);
        }
        return new MyCommonContentEntriesEditor(module2, moduleConfigurationState, true, new JpsModuleSourceRootType[]{JavaSourceRootType.TEST_SOURCE});
    }

    public boolean isModified() {
        return this.myEditor != null && this.myEditor.isModified();
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor == null) {
            return;
        }
        this.myEditor.apply();
        if (this.myModifiableModel.isChanged()) {
            ApplicationManager.getApplication().runWriteAction(() -> this.myModifiableModel.commit());
            this.b();
        }
    }

    public void reset() {
        if (this.myEditor == null) {
            return;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
        }
        this.b();
    }

    private void b() {
        this.myEditor.disposeUIResources();
        this.c.remove(this.myEditor.getComponent());
        this.d();
    }

    public void disposeUIResources() {
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.c.remove(this.myEditor.getComponent());
            this.myEditor = null;
        }
        if (this.myModifiableModel != null) {
            this.myModifiableModel.dispose();
            this.myModifiableModel = null;
        }
    }

    protected Configurable[] buildConfigurables() {
        return new Configurable[0];
    }

    @NotNull
    public String getId() {
        if ("web-ide.project.structure" == null) {
            WebIdeProjectStructureConfigurable.a(2);
        }
        return "web-ide.project.structure";
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OptionContributor
    extends SearchableOptionContributor {
        public void processOptions(@NotNull SearchableOptionProcessor searchableOptionProcessor) {
            if (searchableOptionProcessor == null) {
                OptionContributor.a(0);
            }
            searchableOptionProcessor.addOptions("directories project structure exclude resource test root content", null, "Directories", "web-ide.project.structure", "Directories", true);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$OptionContributor", "processOptions"));
        }
    }

    private static class ResourceRootFolder
    extends ContentFolderBaseImpl {
        protected ResourceRootFolder(@NotNull VirtualFilePointer virtualFilePointer, @NotNull ContentEntryImpl contentEntryImpl) {
            if (virtualFilePointer == null) {
                ResourceRootFolder.a(0);
            }
            if (contentEntryImpl == null) {
                ResourceRootFolder.a(1);
            }
            super(virtualFilePointer, contentEntryImpl);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePointer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contentEntry";
                    break;
                }
            }
            objectArray[1] = "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$ResourceRootFolder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class MyCommonContentEntriesEditor
    extends CommonContentEntriesEditor {
        private final MultiMap<ContentEntry, VirtualFilePointer> b = new MultiMap();
        private Disposable d;
        private final Project c;
        private final VirtualFilePointerListener a = new VirtualFilePointerListener(){};

        public MyCommonContentEntriesEditor(Module module2, ModuleConfigurationState moduleConfigurationState, boolean bl2, JpsModuleSourceRootType<?> ... jpsModuleSourceRootTypeArray) {
            super(module2.getName(), moduleConfigurationState, bl2, jpsModuleSourceRootTypeArray);
            this.c = module2.getProject();
            this.reset();
        }

        protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project2) {
            return new MyContentEntryTreeEditor(project2, this.getEditHandlers());
        }

        protected List<ContentEntry> addContentEntries(VirtualFile[] virtualFileArray) {
            List list2 = super.addContentEntries(virtualFileArray);
            this.addContentEntryPanels(list2.toArray(new ContentEntry[0]));
            return list2;
        }

        public void reset() {
            ContentEntryEditor contentEntryEditor;
            if (this.d != null) {
                Disposer.dispose((Disposable)this.d);
            }
            this.b.clear();
            this.d = Disposer.newDisposable();
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(this.c);
            if (webResourcesPathsConfiguration != null) {
                contentEntryEditor = webResourcesPathsConfiguration.getResourceRoots();
                for (String string : contentEntryEditor.keySet()) {
                    ContentEntry contentEntry = this.a(string);
                    if (contentEntry == null) continue;
                    for (String string2 : contentEntryEditor.get((Object)string)) {
                        this.b.putValue((Object)contentEntry, (Object)VirtualFilePointerManager.getInstance().create(string2, this.d, this.a));
                    }
                }
            }
            if (this.myRootTreeEditor != null) {
                contentEntryEditor = this.myRootTreeEditor.getContentEntryEditor();
                if (contentEntryEditor != null) {
                    contentEntryEditor.update();
                }
                this.myRootTreeEditor.update();
            }
        }

        @Nullable
        private ContentEntry a(String string) {
            for (ContentEntry contentEntry : this.getModel().getContentEntries()) {
                if (!contentEntry.getUrl().equals(string)) continue;
                return contentEntry;
            }
            return null;
        }

        public void disposeUIResources() {
            super.disposeUIResources();
            if (this.d != null) {
                Disposer.dispose((Disposable)this.d);
            }
        }

        public void apply() throws ConfigurationException {
            super.apply();
            MultiMap<String, String> multiMap = this.a();
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(this.c);
            if (webResourcesPathsConfiguration != null) {
                webResourcesPathsConfiguration.setResourceRoots(multiMap);
            }
        }

        private MultiMap<String, String> a() {
            MultiMap multiMap = new MultiMap();
            for (ContentEntry contentEntry : this.b.keySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (VirtualFilePointer virtualFilePointer : this.b.get((Object)contentEntry)) {
                    arrayList.add(virtualFilePointer.getUrl());
                }
                multiMap.put((Object)contentEntry.getUrl(), arrayList);
            }
            return multiMap;
        }

        public boolean isModified() {
            if (super.isModified()) {
                return true;
            }
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(this.c);
            if (webResourcesPathsConfiguration != null) {
                MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
                MultiMap<String, String> multiMap2 = this.a();
                if (!Comparing.haveEqualElements((Collection)multiMap.keySet(), (Collection)multiMap2.keySet())) {
                    return true;
                }
                for (String string : multiMap.keySet()) {
                    if (Comparing.haveEqualElements((Collection)multiMap.get((Object)string), (Collection)multiMap2.get((Object)string))) continue;
                    return true;
                }
            }
            return false;
        }

        protected MyContentEntryEditor createContentEntryEditor(String string) {
            return new MyContentEntryEditor(string, this.getEditHandlers());
        }

        protected class MyContentEntryEditor
        extends ContentEntryEditor {
            private final EventDispatcher<ChangeListener> a;

            public MyContentEntryEditor(String string, List<ModuleSourceRootEditHandler<?>> list2) {
                super(string, list2);
                this.a = EventDispatcher.create(ChangeListener.class);
            }

            protected ModifiableRootModel getModel() {
                return MyCommonContentEntriesEditor.this.getModel();
            }

            public void addListener(ChangeListener changeListener) {
                this.a.addListener((EventListener)changeListener);
            }

            public void removeListener(ChangeListener changeListener) {
                this.a.removeListener((EventListener)changeListener);
            }

            protected ContentRootPanel createContentRootPane() {
                return new MyContentRootPanel();
            }

            public void deleteContentFolder(ContentEntry contentEntry, ContentFolder contentFolder) {
                if (contentFolder instanceof ResourceRootFolder) {
                    this.removeResourceRoot(contentFolder.getUrl());
                } else {
                    super.deleteContentFolder(contentEntry, contentFolder);
                }
            }

            public void addResourceRoot(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    MyContentEntryEditor.a(0);
                }
                VirtualFilePointer virtualFilePointer = VirtualFilePointerManager.getInstance().create(virtualFile, MyCommonContentEntriesEditor.this.d, MyCommonContentEntriesEditor.this.a);
                MyCommonContentEntriesEditor.this.b.putValue((Object)this.getContentEntry(), (Object)virtualFilePointer);
                ((ChangeListener)this.a.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
                this.update();
            }

            public void removeResourceRoot(@NotNull String string) {
                VirtualFilePointer virtualFilePointer;
                if (string == null) {
                    MyContentEntryEditor.a(1);
                }
                if ((virtualFilePointer = this.getResourceRoot(string)) != null) {
                    MyCommonContentEntriesEditor.this.b.remove((Object)this.getContentEntry(), (Object)virtualFilePointer);
                    ((ChangeListener)this.a.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
                    this.update();
                }
            }

            public boolean hasResourceRoot(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    MyContentEntryEditor.a(2);
                }
                return this.getResourceRoot(virtualFile.getUrl()) != null;
            }

            @Nullable
            public VirtualFilePointer getResourceRoot(@NotNull String string) {
                if (string == null) {
                    MyContentEntryEditor.a(3);
                }
                for (VirtualFilePointer virtualFilePointer : MyCommonContentEntriesEditor.this.b.get((Object)this.getContentEntry())) {
                    if (!Comparing.equal((String)virtualFilePointer.getUrl(), (String)string)) continue;
                    return virtualFilePointer;
                }
                return null;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "url";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addResourceRoot";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removeResourceRoot";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasResourceRoot";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getResourceRoot";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            protected class MyContentRootPanel
            extends ContentRootPanel {
                public MyContentRootPanel() {
                    super((ContentRootPanel.ActionCallback)MyContentEntryEditor.this, MyContentEntryEditor.this.getEditHandlers());
                }

                @NotNull
                protected ContentEntryImpl getContentEntry() {
                    ContentEntryImpl contentEntryImpl = (ContentEntryImpl)MyContentEntryEditor.this.getContentEntry();
                    if (contentEntryImpl == null) {
                        MyContentRootPanel.a(0);
                    }
                    return contentEntryImpl;
                }

                protected void addFolderGroupComponents() {
                    super.addFolderGroupComponents();
                    if (!MyCommonContentEntriesEditor.this.b.get((Object)this.getContentEntry()).isEmpty()) {
                        ArrayList<ResourceRootFolder> arrayList = new ArrayList<ResourceRootFolder>(MyCommonContentEntriesEditor.this.b.size());
                        for (VirtualFilePointer virtualFilePointer : MyCommonContentEntriesEditor.this.b.get((Object)this.getContentEntry())) {
                            arrayList.add(new ResourceRootFolder(virtualFilePointer, this.getContentEntry()));
                        }
                        JComponent jComponent = this.createFolderGroupComponent(WebCoreBundle.message((String)"resource.root.path.component.title", (Object[])new Object[0]), arrayList.toArray(new ContentFolder[0]), a, null);
                        this.add(jComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/resourceRoots/WebIdeProjectStructureConfigurable$MyCommonContentEntriesEditor$MyContentEntryEditor$MyContentRootPanel", "getContentEntry"));
                }
            }
        }
    }

    private static class MyContentEntryTreeEditor
    extends ContentEntryTreeEditor {
        private final ChangeListener a = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                this.update();
            }
        };

        public MyContentEntryTreeEditor(Project project2, List<ModuleSourceRootEditHandler<?>> list2) {
            super(project2, list2);
        }

        public void setContentEntryEditor(ContentEntryEditor contentEntryEditor) {
            MyCommonContentEntriesEditor.MyContentEntryEditor myContentEntryEditor = this.getContentEntryEditor();
            if (Comparing.equal((Object)((Object)myContentEntryEditor), (Object)contentEntryEditor)) {
                return;
            }
            if (myContentEntryEditor != null) {
                myContentEntryEditor.removeListener(this.a);
            }
            if (contentEntryEditor != null) {
                ((MyCommonContentEntriesEditor.MyContentEntryEditor)contentEntryEditor).addListener(this.a);
            }
            super.setContentEntryEditor(contentEntryEditor);
        }

        public MyCommonContentEntriesEditor.MyContentEntryEditor getContentEntryEditor() {
            return (MyCommonContentEntriesEditor.MyContentEntryEditor)super.getContentEntryEditor();
        }

        protected void createEditingActions() {
            super.createEditingActions();
            ContentEntryEditingAction contentEntryEditingAction = new ContentEntryEditingAction((JTree)this.myTree){
                {
                    super(jTree);
                    Presentation presentation = this.getTemplatePresentation();
                    presentation.setText(WebCoreBundle.message((String)"resource.root.action.title", (Object[])new Object[0]));
                    presentation.setDescription(WebCoreBundle.message((String)"resource.root.action.description", (Object[])new Object[0]));
                    presentation.setIcon(ResourceRootIconProvider.RESOURCE_ROOT_ICON);
                }

                public boolean isSelected(AnActionEvent anActionEvent) {
                    VirtualFile[] virtualFileArray = this.getSelectedFiles();
                    return virtualFileArray.length != 0 && this.getContentEntryEditor().hasResourceRoot(virtualFileArray[0]);
                }

                public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
                    VirtualFile[] virtualFileArray = this.getSelectedFiles();
                    assert (virtualFileArray.length != 0);
                    for (VirtualFile virtualFile : virtualFileArray) {
                        boolean bl3 = this.getContentEntryEditor().hasResourceRoot(virtualFile);
                        if (bl2) {
                            if (bl3) continue;
                            this.getContentEntryEditor().addResourceRoot(virtualFile);
                            continue;
                        }
                        if (!bl3) continue;
                        this.getContentEntryEditor().removeResourceRoot(virtualFile.getUrl());
                    }
                }
            };
            this.myEditingActionsGroup.add((AnAction)contentEntryEditingAction);
            contentEntryEditingAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 8)), (JComponent)this.myTree);
        }

        protected TreeCellRenderer getContentEntryCellRenderer() {
            return new ContentEntryTreeCellRenderer(this, this.getEditHandlers()){

                protected Icon updateIcon(ContentEntry contentEntry, VirtualFile virtualFile, Icon icon) {
                    if (this.getContentEntryEditor().hasResourceRoot(virtualFile)) {
                        return ResourceRootIconProvider.RESOURCE_ROOT_ICON;
                    }
                    return super.updateIcon(contentEntry, virtualFile, icon);
                }
            };
        }
    }
}

