/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    private JsonUtil() {
    }

    @Nullable
    public static JsonObject tryParseJsonObject(@Nullable String string) {
        return JsonUtil.tryParseJsonObject(string, true);
    }

    @Nullable
    public static JsonObject tryParseJsonObject(@Nullable String string, boolean bl2) {
        try {
            return JsonUtil.parseJsonObject(string, bl2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    public static JsonObject parseJsonObject(@Nullable String string) throws JsonIOException, JsonSyntaxException, IllegalStateException {
        JsonObject jsonObject = JsonUtil.parseJsonObject(string, true);
        if (jsonObject == null) {
            JsonUtil.a(0);
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsonObject parseJsonObject(@Nullable String string, boolean bl2) throws JsonIOException, JsonSyntaxException, IllegalStateException {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(StringUtil.notNullize((String)string)));
        jsonReader.setLenient(bl2);
        JsonElement jsonElement = new JsonParser().parse(jsonReader);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 == null) {
            JsonUtil.a(1);
        }
        return jsonObject2;
        finally {
            try {
                jsonReader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JsonArray parseJsonArray(@Nullable String string) throws JsonParseException {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(StringUtil.notNullize((String)string)));
        JsonElement jsonElement = new JsonParser().parse(jsonReader);
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        JsonArray jsonArray2 = jsonArray;
        if (jsonArray2 == null) {
            JsonUtil.a(2);
        }
        return jsonArray2;
        finally {
            try {
                jsonReader.close();
            }
            catch (Exception exception) {}
        }
    }

    @NotNull
    public static List<Object> nextList(@NotNull JsonReader jsonReader) throws IOException {
        if (jsonReader == null) {
            JsonUtil.a(3);
        }
        jsonReader.beginArray();
        if (!jsonReader.hasNext()) {
            jsonReader.endArray();
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonUtil.a(4);
            }
            return list2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        while (jsonReader.hasNext()) {
            arrayList.add(JsonUtil.nextAny(jsonReader));
        }
        jsonReader.endArray();
        ArrayList<Object> arrayList2 = arrayList;
        if (arrayList2 == null) {
            JsonUtil.a(5);
        }
        return arrayList2;
    }

    @NotNull
    public static List<String> nextStringList(@NotNull JsonReader jsonReader) throws IOException {
        if (jsonReader == null) {
            JsonUtil.a(6);
        }
        jsonReader.beginArray();
        if (!jsonReader.hasNext()) {
            jsonReader.endArray();
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JsonUtil.a(7);
            }
            return list2;
        }
        ArrayList arrayList = ContainerUtil.newArrayListWithCapacity((int)2);
        while (jsonReader.hasNext()) {
            String string = JsonUtil.nextStringOrSkip(jsonReader);
            if (string == null) continue;
            arrayList.add(string);
        }
        jsonReader.endArray();
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            JsonUtil.a(8);
        }
        return arrayList2;
    }

    @NotNull
    public static Map<String, Object> nextMap(@NotNull JsonReader jsonReader) throws IOException {
        if (jsonReader == null) {
            JsonUtil.a(9);
        }
        jsonReader.beginObject();
        if (!jsonReader.hasNext()) {
            jsonReader.endObject();
            Map<String, Object> map = Collections.emptyMap();
            if (map == null) {
                JsonUtil.a(10);
            }
            return map;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        while (jsonReader.hasNext()) {
            hashMap.put(jsonReader.nextName(), JsonUtil.nextAny(jsonReader));
        }
        jsonReader.endObject();
        HashMap<String, Object> hashMap2 = hashMap;
        if (hashMap2 == null) {
            JsonUtil.a(11);
        }
        return hashMap2;
    }

    @Nullable
    public static String nextStringOrSkip(@NotNull JsonReader jsonReader) throws IOException {
        JsonToken jsonToken;
        if (jsonReader == null) {
            JsonUtil.a(12);
        }
        if ((jsonToken = jsonReader.peek()) == JsonToken.STRING) {
            return jsonReader.nextString();
        }
        jsonReader.skipValue();
        return null;
    }

    @Nullable
    public static Object nextAny(@NotNull JsonReader jsonReader) throws IOException {
        if (jsonReader == null) {
            JsonUtil.a(13);
        }
        switch (jsonReader.peek()) {
            case BEGIN_ARRAY: {
                return JsonUtil.nextList(jsonReader);
            }
            case BEGIN_OBJECT: {
                return JsonUtil.nextMap(jsonReader);
            }
            case STRING: {
                return jsonReader.nextString();
            }
            case NUMBER: {
                return jsonReader.nextDouble();
            }
            case BOOLEAN: {
                return jsonReader.nextBoolean();
            }
            case NULL: {
                jsonReader.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Deprecated
    @Nullable
    public static String getString(@NotNull JsonObject jsonObject, @NotNull String string) {
        if (jsonObject == null) {
            JsonUtil.a(14);
        }
        if (string == null) {
            JsonUtil.a(15);
        }
        return JsonUtil.getChildAsString(jsonObject, string);
    }

    @Nullable
    public static String getChildAsString(@Nullable JsonObject jsonObject, @NotNull String string) {
        if (string == null) {
            JsonUtil.a(16);
        }
        JsonElement jsonElement = jsonObject != null ? jsonObject.get(string) : null;
        return JsonUtil.getString(jsonElement);
    }

    @Nullable
    public static JsonArray getChildAsArray(@Nullable JsonObject jsonObject, @NotNull String string) {
        JsonElement jsonElement;
        if (string == null) {
            JsonUtil.a(17);
        }
        JsonElement jsonElement2 = jsonElement = jsonObject != null ? jsonObject.get(string) : null;
        if (jsonElement != null && jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        return null;
    }

    @Nullable
    public static List<String> getChildAsStringList(@Nullable JsonObject jsonObject, @NotNull String string) {
        if (string == null) {
            JsonUtil.a(18);
        }
        JsonElement jsonElement = jsonObject != null ? jsonObject.get(string) : null;
        return JsonUtil.getAsStringList(jsonElement);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static List<String> getAsStringList(@Nullable JsonElement jsonElement) {
        if (jsonElement != null && jsonElement.isJsonArray()) {
            return ContainerUtil.mapNotNull((Iterable)jsonElement.getAsJsonArray(), JsonUtil::getString);
        }
        return null;
    }

    @Nullable
    public static JsonObject getChildAsObject(@Nullable JsonObject jsonObject, @NotNull String string) {
        if (string == null) {
            JsonUtil.a(19);
        }
        return JsonUtil.getAsObject(jsonObject != null ? jsonObject.get(string) : null);
    }

    @Nullable
    public static JsonObject getAsObject(@Nullable JsonElement jsonElement) {
        return jsonElement != null && jsonElement.isJsonObject() ? jsonElement.getAsJsonObject() : null;
    }

    @Nullable
    public static JsonElement findChild(@Nullable JsonObject jsonObject, String ... stringArray) {
        if (jsonObject == null) {
            return null;
        }
        for (String string : stringArray) {
            JsonElement jsonElement = jsonObject.get(string);
            if (jsonElement == null) continue;
            return jsonElement;
        }
        return null;
    }

    @NotNull
    public static List<String> keys(@NotNull JsonObject jsonObject) {
        if (jsonObject == null) {
            JsonUtil.a(20);
        }
        List list2 = ContainerUtil.map((Collection)jsonObject.entrySet(), entry -> (String)entry.getKey());
        if (list2 == null) {
            JsonUtil.a(21);
        }
        return list2;
    }

    @Nullable
    public static Boolean getChildAsBooleanObj(@Nullable JsonObject jsonObject, @NotNull String string) {
        JsonPrimitive jsonPrimitive;
        JsonElement jsonElement;
        if (string == null) {
            JsonUtil.a(22);
        }
        JsonElement jsonElement2 = jsonElement = jsonObject != null ? jsonObject.get(string) : null;
        if (jsonElement != null && jsonElement.isJsonPrimitive() && (jsonPrimitive = jsonElement.getAsJsonPrimitive()).isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        return null;
    }

    public static boolean getChildAsBoolean(@Nullable JsonObject jsonObject, @NotNull String string, boolean bl2) {
        if (string == null) {
            JsonUtil.a(23);
        }
        return (Boolean)ObjectUtils.notNull((Object)JsonUtil.getChildAsBooleanObj(jsonObject, string), (Object)bl2);
    }

    @Nullable
    public static String getString(@Nullable JsonElement jsonElement) {
        JsonPrimitive jsonPrimitive;
        if (jsonElement != null && jsonElement.isJsonPrimitive() && (jsonPrimitive = jsonElement.getAsJsonPrimitive()).isString()) {
            return jsonPrimitive.getAsString();
        }
        return null;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader jsonReader, @NotNull String string) throws IOException {
        if (jsonReader == null) {
            JsonUtil.a(24);
        }
        if (string == null) {
            JsonUtil.a(25);
        }
        return JsonUtil.getChildAsString(jsonReader, string, null);
    }

    @NotNull
    public static Map<String, String> getTopLevelStringValues(@NotNull JsonReader jsonReader, @NotNull Set<String> set) throws IOException {
        JsonToken jsonToken;
        if (jsonReader == null) {
            JsonUtil.a(26);
        }
        if (set == null) {
            JsonUtil.a(27);
        }
        if ((jsonToken = jsonReader.peek()) != JsonToken.BEGIN_OBJECT) {
            jsonReader.skipValue();
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                JsonUtil.a(28);
            }
            return map;
        }
        jsonReader.beginObject();
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size(), 1.0f);
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (set.contains(string)) {
                String string2 = JsonUtil.nextStringOrSkip(jsonReader);
                if (string2 == null) continue;
                hashMap.put(string, string2);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            JsonUtil.a(29);
        }
        return hashMap2;
    }

    @Nullable
    public static String getChildAsString(@NotNull JsonReader jsonReader, @NotNull String string, @Nullable String string2) throws IOException {
        if (jsonReader == null) {
            JsonUtil.a(30);
        }
        if (string == null) {
            JsonUtil.a(31);
        }
        Set set = string2 == null ? Collections.singleton(string) : ContainerUtil.set((Object[])new String[]{string, string2});
        Map<String, String> map = JsonUtil.getTopLevelStringValues(jsonReader, set);
        String string3 = map.get(string);
        return string3 != null ? string3 : map.get(string2);
    }

    public static int getChildAsInteger(@Nullable JsonObject jsonObject, @NotNull String string, int n2) {
        if (string == null) {
            JsonUtil.a(32);
        }
        JsonElement jsonElement = jsonObject != null ? jsonObject.get(string) : null;
        return JsonUtil.a(jsonElement, n2);
    }

    private static int a(@Nullable JsonElement jsonElement, int n2) {
        if (jsonElement instanceof JsonPrimitive && ((JsonPrimitive)jsonElement).isNumber()) {
            return jsonElement.getAsInt();
        }
        return n2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/util/JsonUtil";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 15: 
            case 16: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsonObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJsonArray";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/util/JsonUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "nextList";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nextStringList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "nextMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelStringValues";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nextStringList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nextMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nextStringOrSkip";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "nextAny";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 16: 
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsArray";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsStringList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsObject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "keys";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsBooleanObj";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsBoolean";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelStringValues";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsInteger";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

