/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ls.requests;

import com.jetbrains.ls.requests.AbstractObtainTicketRequest;
import com.jetbrains.ls.responses.ObtainPermanentTicketGroupResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class ObtainPermanentTicketGroupRequest
extends AbstractObtainTicketRequest<ObtainPermanentTicketGroupResponse> {
    public static final String ACTION_NAME = "obtainPermanentTicketGroup.action";
    private String n;
    private String p;
    private Collection<ProductSelector> o;

    public ObtainPermanentTicketGroupRequest() {
    }

    public ObtainPermanentTicketGroupRequest(long l2, Collection<ProductSelector> collection, String string, String string2, String string3, String string4, String string5) {
        super(l2, ObtainPermanentTicketGroupRequest.a(collection), string, string2, string3, 0, 0, false);
        this.n = string4;
        this.p = string5;
        this.o = collection;
    }

    public String getEmail() {
        return this.n;
    }

    public void setEmail(String string) {
        this.n = string;
    }

    public String getActivationCode() {
        return this.p;
    }

    public void setActivationCode(String string) {
        this.p = string;
    }

    public String getProductSelectors() {
        if (this.o == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductSelector productSelector : this.o) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(productSelector.toString());
        }
        return stringBuilder.toString();
    }

    public void setProductSelectors(String string) {
        ArrayList<ProductSelector> arrayList = new ArrayList<ProductSelector>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                ProductSelector productSelector = ProductSelector.fromString(string2, 0);
                if (productSelector == null) continue;
                arrayList.add(productSelector);
            }
        }
        this.o = arrayList.isEmpty() ? null : arrayList;
    }

    @NotNull
    public Collection<ProductSelector> getAllProductSelectors() {
        Collection<Object> collection = this.o == null ? Collections.emptyList() : this.o;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/ls/requests/ObtainPermanentTicketGroupRequest", "getAllProductSelectors"));
        }
        return collection;
    }

    @Override
    public String getActionName() {
        return ACTION_NAME;
    }

    private static String a(Collection<ProductSelector> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ProductSelector productSelector : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(productSelector.getProductFamilyId());
        }
        return stringBuilder.toString();
    }

    public static final class ProductSelector {
        public final String productFamilyId;
        public final int version;
        public final int buildDate;
        public final String edition;

        public ProductSelector(String string, int n2, int n3, String string2) {
            this.productFamilyId = string;
            this.version = n2;
            this.buildDate = n3;
            this.edition = string2 == null || string2.length() == 0 || "null".equalsIgnoreCase(string2) ? null : string2;
        }

        public String getProductFamilyId() {
            return this.productFamilyId;
        }

        public int getVersion() {
            return this.version;
        }

        public int getBuildDate() {
            return this.buildDate;
        }

        public String getEdition() {
            return this.edition;
        }

        public String toString() {
            return "{" + this.productFamilyId + "|" + this.version + "|" + this.buildDate + "|" + this.edition + "}";
        }

        public static ProductSelector fromString(String string, int n2) {
            int n3;
            if (n2 >= string.length()) {
                return null;
            }
            if (string.charAt(n2) != '{') {
                return null;
            }
            if ((n3 = string.indexOf(124, ++n2)) < 0) {
                return null;
            }
            String string2 = string.substring(n2, n3).trim();
            n2 = n3 + 1;
            if ((n3 = string.indexOf(124, n2)) < 0) {
                return null;
            }
            String string3 = string.substring(n2, n3).trim();
            n2 = n3 + 1;
            if ((n3 = string.indexOf(124, n2)) < 0) {
                return null;
            }
            String string4 = string.substring(n2, n3).trim();
            n2 = n3 + 1;
            if ((n3 = string.indexOf(125, n2)) < 0) {
                return null;
            }
            String string5 = string.substring(n2, n3).trim();
            try {
                return new ProductSelector(string2, Integer.parseInt(string3), Integer.parseInt(string4), string5);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

