/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.addproperty;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.rpp.RefactorJConfig;
import com.sixrr.rpp.utils.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class AddPropertyDialog
extends RefactoringDialog {
    private JCheckBox b;
    private JCheckBox d;
    private JCheckBox a;
    private JCheckBox e;
    private JTextField h;
    private JTextField g;
    private JTextField f;
    private final PsiClass c;

    AddPropertyDialog(PsiClass psiClass) {
        super(psiClass.getProject(), true);
        this.setModal(true);
        this.c = psiClass;
        this.setTitle(RefactorJBundle.message((String)"add.property", (Object[])new Object[0]));
        this.init();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        this.b.setSelected(refactorJConfig.ADD_PROPERTY_ADD_SETTER);
        this.d.setSelected(refactorJConfig.ADD_PROPERTY_ADD_GETTER);
        this.e.setSelected(refactorJConfig.ADD_PROPERTY_ADD_TO_CONSTRUCTOR);
        this.a.setSelected(false);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPropertyDialog.this.validateButtons();
            }
        });
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                AddPropertyDialog.this.validateButtons();
            }
        };
        this.h.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.g.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.f.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.validateButtons();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.AddProperty";
    }

    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel();
        String string = RefactorJBundle.message((String)"add.property.dialog.title", (Object[])new Object[]{this.c.getName()});
        IdeaTitledBorder ideaTitledBorder = IdeBorderFactory.createTitledBorder((String)string, (boolean)true);
        jPanel.setBorder((Border)ideaTitledBorder);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"property.name.field.label", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.h = new JTextField(30);
        jPanel.add((Component)this.h, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"property.type.field.label", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.g = new JTextField(30);
        jPanel.add((Component)this.g, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.d = new JCheckBox(RefactorJBundle.message((String)"create.property.getter.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.d, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.b = new JCheckBox(RefactorJBundle.message((String)"create.property.setter.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.b, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.e = new JCheckBox(RefactorJBundle.message((String)"add.property.to.constructors.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.e, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.a = new JCheckBox(RefactorJBundle.message((String)"make.property.final.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.a, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"initialization.expression.checkbox", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.f = new JTextField(30);
        jPanel.add((Component)this.f, gridBagConstraints);
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.h;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.addProperty");
    }

    protected void doAction() {
    }

    protected boolean areButtonsValid() {
        return this.b() && this.c() && this.a();
    }

    private boolean b() {
        String string = this.getInitializationExpression();
        if (string.length() == 0) {
            return true;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.c.getManager().getProject()).getElementFactory();
        try {
            psiElementFactory.createExpressionFromText(string, (PsiElement)this.c);
            return true;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return false;
        }
    }

    private boolean a() {
        String string = this.getFieldType();
        if (string.length() == 0) {
            return false;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.c.getManager().getProject()).getElementFactory();
        try {
            psiElementFactory.createTypeFromText(string, (PsiElement)this.c);
            return true;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return false;
        }
    }

    private boolean c() {
        String string = this.getFieldName();
        if (string.length() == 0) {
            return false;
        }
        if (StringUtils.isKeyword(string)) {
            return false;
        }
        return string.matches("[a-zA-Z0-9_]*");
    }

    protected void validateButtons() {
        if (this.b()) {
            this.f.setForeground(JBColor.foreground());
        } else {
            this.f.setForeground((Color)JBColor.RED);
        }
        if (this.c()) {
            this.h.setForeground(JBColor.foreground());
        } else {
            this.h.setForeground((Color)JBColor.RED);
        }
        if (this.a()) {
            this.g.setForeground(JBColor.foreground());
        } else {
            this.g.setForeground((Color)JBColor.RED);
        }
        this.a.setEnabled(!this.b.isSelected());
        super.validateButtons();
    }

    public boolean getAddSetter() {
        return this.b.isSelected();
    }

    public boolean getAddGetter() {
        return this.d.isSelected();
    }

    public String getInitializationExpression() {
        return this.f.getText();
    }

    public String getFieldName() {
        return this.h.getText().trim();
    }

    public String getFieldType() {
        return this.g.getText().trim();
    }

    public boolean getAddToConstructor() {
        return this.e.isSelected();
    }

    public boolean getMakeFinal() {
        return this.a.isSelected() && !this.b.isSelected();
    }
}

