/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.generatecollectionmethods;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.sixrr.rpp.utils.CollectionUtils;
import com.sixrr.rpp.utils.PsiUtils;
import com.sixrr.rpp.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

class GenerateCollectionMethodsHandler
extends EditorWriteActionHandler {
    GenerateCollectionMethodsHandler() {
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        PsiElement psiElement;
        CaretModel caretModel = editor.getCaretModel();
        int n2 = caretModel.getOffset();
        PsiFile psiFile = (PsiFile)dataContext.getData("psi.File");
        Project project2 = (Project)dataContext.getData(DataConstants.PROJECT);
        if (psiFile == null) {
            return;
        }
        PsiElement psiElement2 = psiFile.findElementAt(n2);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        for (psiElement = psiElement2; psiElement != null && !psiElement.getParent().equals(psiClass); psiElement = psiElement.getParent()) {
        }
        if (psiElement != null) {
            psiElement = PsiTreeUtil.getNextSiblingOfType((PsiElement)psiElement, PsiMember.class);
        }
        List<PsiField> list2 = CollectionUtils.getUnimplementedCollectionFields(psiClass);
        GenerateCollectionMethodsHandler.a(list2, project2, psiElement);
    }

    private static void a(PsiField psiField, PsiElement psiElement) {
        PsiClass psiClass = psiField.getContainingClass();
        String string = psiField.getName();
        String string2 = PsiUtils.stripFieldName(psiField);
        String string3 = StringUtils.createSingularFromName(string2);
        PsiClassType psiClassType = (PsiClassType)psiField.getType();
        PsiType[] psiTypeArray = psiClassType.getParameters();
        String string4 = psiTypeArray.length == 0 || psiTypeArray[0] instanceof PsiWildcardType ? "java.lang.Object" : psiTypeArray[0].getPresentableText();
        GenerateCollectionMethodsHandler.b(psiClass, psiField, string, string3, string4, psiElement);
        GenerateCollectionMethodsHandler.a(psiClass, psiField, string, string3, string4, psiElement);
        GenerateCollectionMethodsHandler.a(psiClass, psiField, string, string2, psiClassType, psiElement);
    }

    private static void b(PsiClass psiClass, PsiField psiField, String string, String string2, String string3, PsiElement psiElement) {
        PsiManager psiManager = psiClass.getManager();
        Project project2 = psiManager.getProject();
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project2);
        JavaCodeStyleSettings javaCodeStyleSettings = (JavaCodeStyleSettings)codeStyleSettingsManager.getCurrentSettings().getCustomSettings(JavaCodeStyleSettings.class);
        String string4 = "add" + StringUtil.capitalize((String)string2);
        if (PsiUtils.classHasMethod(psiClass, string4)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        String string5 = psiField.hasModifierProperty("static") ? "static " : "";
        stringBuilder.append("public " + string5 + "void ");
        stringBuilder.append(string4);
        stringBuilder.append('(');
        stringBuilder.append(javaCodeStyleSettings.GENERATE_FINAL_PARAMETERS ? "final " : "");
        stringBuilder.append(string3);
        stringBuilder.append(' ');
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
        stringBuilder.append(string2);
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        stringBuilder.append(')');
        stringBuilder.append('{');
        stringBuilder.append(string);
        stringBuilder.append(".add(");
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
        stringBuilder.append(string2);
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        stringBuilder.append(");");
        stringBuilder.append('}');
        String string6 = stringBuilder.toString();
        PsiUtils.addMethodToClass(psiClass, string6, psiElement);
    }

    private static void a(PsiClass psiClass, PsiField psiField, String string, String string2, String string3, PsiElement psiElement) {
        PsiManager psiManager = psiClass.getManager();
        Project project2 = psiManager.getProject();
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project2);
        JavaCodeStyleSettings javaCodeStyleSettings = (JavaCodeStyleSettings)codeStyleSettingsManager.getCurrentSettings().getCustomSettings(JavaCodeStyleSettings.class);
        String string4 = "remove" + StringUtil.capitalize((String)string2);
        if (PsiUtils.classHasMethod(psiClass, string4)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        String string5 = psiField.hasModifierProperty("static") ? "static " : "";
        stringBuilder.append("public " + string5 + "void ");
        stringBuilder.append(string4);
        stringBuilder.append('(');
        stringBuilder.append(javaCodeStyleSettings.GENERATE_FINAL_PARAMETERS ? "final " : "");
        stringBuilder.append(string3);
        stringBuilder.append(' ');
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
        stringBuilder.append(string2);
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        stringBuilder.append(')');
        stringBuilder.append('{');
        stringBuilder.append(string);
        stringBuilder.append(".remove(");
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_PREFIX);
        stringBuilder.append(string2);
        stringBuilder.append(javaCodeStyleSettings.PARAMETER_NAME_SUFFIX);
        stringBuilder.append(");");
        stringBuilder.append('}');
        String string6 = stringBuilder.toString();
        PsiUtils.addMethodToClass(psiClass, string6, psiElement);
    }

    private static void a(PsiClass psiClass, PsiField psiField, String string, String string2, PsiClassType psiClassType, PsiElement psiElement) {
        String string3 = "get" + StringUtil.capitalize((String)string2);
        if (PsiUtils.classHasMethod(psiClass, string3)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        String string4 = psiField.hasModifierProperty("static") ? "static " : "";
        String string5 = psiClassType.getPresentableText();
        stringBuilder.append("public " + string4 + string5 + ' ');
        stringBuilder.append(string3 + "()");
        stringBuilder.append('{');
        String string6 = GenerateCollectionMethodsHandler.a(string, psiClassType);
        stringBuilder.append("return " + string6 + ';');
        stringBuilder.append('}');
        String string7 = stringBuilder.toString();
        PsiUtils.addMethodToClass(psiClass, string7, psiElement);
    }

    @NonNls
    private static String a(String string, PsiClassType psiClassType) {
        PsiClass psiClass = psiClassType.resolve();
        if (psiClass == null) {
            return string;
        }
        if (psiClass.isInterface()) {
            String string2 = psiClass.getQualifiedName();
            if ("java.util.List".equals(string2)) {
                return "java.util.Collections.unmodifiableList(" + string + ')';
            }
            if ("java.util.Set".equals(string2)) {
                return "java.util.Collections.unmodifiableSet(" + string + ')';
            }
            if ("java.util.SortedSet".equals(string2)) {
                return "java.util.Collections.unmodifiableSortedSet(" + string + ')';
            }
            if ("java.util.Collection".equals(string2)) {
                return "java.util.Collections.unmodifiableCollection(" + string + ')';
            }
        } else if (GenerateCollectionMethodsHandler.a(psiClass)) {
            return "new " + psiClassType.getPresentableText() + '(' + string + ')';
        }
        return string;
    }

    private static boolean a(PsiClass psiClass) {
        PsiMethod[] psiMethodArray;
        for (PsiMethod psiMethod : psiMethodArray = psiClass.getConstructors()) {
            if (!GenerateCollectionMethodsHandler.a(psiMethod, psiClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean a(PsiMethod psiMethod, PsiClass psiClass) {
        PsiParameterList psiParameterList = psiMethod.getParameterList();
        PsiParameter[] psiParameterArray = psiParameterList.getParameters();
        if (psiParameterArray.length != 1) {
            return false;
        }
        PsiParameter psiParameter = psiParameterArray[0];
        if (psiParameter == null) {
            return false;
        }
        PsiType psiType = psiParameter.getType();
        if (!(psiType instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass2 = ((PsiClassType)psiType).resolve();
        return InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)psiClass2, (boolean)true);
    }

    private static void a(List<PsiField> list2, Project project2, PsiElement psiElement) {
        int n2 = list2.size();
        PsiFieldMember[] psiFieldMemberArray = new PsiFieldMember[n2];
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            psiFieldMemberArray[i2] = new PsiFieldMember(list2.get(i2));
        }
        MemberChooser memberChooser = new MemberChooser((ClassMember[])psiFieldMemberArray, true, true, project2);
        memberChooser.setCopyJavadocVisible(false);
        memberChooser.setTitle(RefactorJBundle.message((String)"generate.collection.access.methods.title", (Object[])new Object[0]));
        memberChooser.setSize(200, 200);
        SwingUtilities.invokeLater(() -> {
            memberChooser.show();
            if (memberChooser.getExitCode() == 1) {
                return;
            }
            List list2 = memberChooser.getSelectedElements();
            if (list2 != null) {
                ArrayList<PsiField> arrayList = new ArrayList<PsiField>();
                for (PsiFieldMember psiFieldMember : list2) {
                    arrayList.add((PsiField)psiFieldMember.getPsiElement());
                }
                GenerateCollectionMethodsHandler.b(arrayList, project2, psiElement);
            }
        });
    }

    private static void b(List<PsiField> list2, Project project2, PsiElement psiElement) {
        Runnable runnable = () -> {
            Application application = ApplicationManager.getApplication();
            application.runWriteAction(() -> GenerateCollectionMethodsHandler.c(list2, psiElement));
        };
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project2, runnable, RefactorJBundle.message((String)"generate.collection.methods.undo.string", (Object[])new Object[0]), null);
    }

    private static void c(List<PsiField> list2, PsiElement psiElement) {
        PsiField psiField2;
        for (PsiField psiField2 : list2) {
            GenerateCollectionMethodsHandler.a(psiField2, psiElement);
        }
        PsiField psiField3 = list2.get(0);
        psiField2 = psiField3.getContainingClass();
        PsiUtils.reformatClass((PsiClass)psiField2);
    }
}

