/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header.impl;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public class ClassReferenceParser
extends StandardHeaderParser {
    public static final String MAIN_CLASS = "Main-Class";
    public static final String PREMAIN_CLASS = "Premain-Class";
    public static final String AGENT_CLASS = "Agent-Class";
    public static final String LAUNCHER_AGENT_CLASS = "Launcher-Agent-Class";
    public static final HeaderParser INSTANCE = new ClassReferenceParser();

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        Module module2;
        if (headerValuePart == null) {
            ClassReferenceParser.b(0);
        }
        JavaClassReferenceProvider javaClassReferenceProvider = (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)headerValuePart)) != null ? new JavaClassReferenceProvider(){

            public GlobalSearchScope getScope(Project project2) {
                return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
            }
        } : new JavaClassReferenceProvider();
        PsiReference[] psiReferenceArray = javaClassReferenceProvider.getReferencesByElement((PsiElement)headerValuePart);
        if (psiReferenceArray == null) {
            ClassReferenceParser.b(1);
        }
        return psiReferenceArray;
    }

    @Override
    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder annotationHolder) {
        HeaderValue headerValue;
        if (header == null) {
            ClassReferenceParser.b(2);
        }
        if (annotationHolder == null) {
            ClassReferenceParser.b(3);
        }
        if (!((headerValue = header.getHeaderValue()) instanceof HeaderValuePart)) {
            return false;
        }
        HeaderValuePart headerValuePart = (HeaderValuePart)headerValue;
        String string = headerValuePart.getUnwrappedText();
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            annotationHolder.createErrorAnnotation(headerValuePart.getHighlightingRange(), ManifestBundle.message("header.reference.invalid", new Object[0]));
            return true;
        }
        Project project2 = header.getProject();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)header);
        GlobalSearchScope globalSearchScope = module2 != null ? module2.getModuleWithDependenciesAndLibrariesScope(false) : ProjectScope.getAllScope((Project)project2);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project2).findClass(string, globalSearchScope);
        if (psiClass == null) {
            String string2 = JavaErrorMessages.message((String)"error.cannot.resolve.class", (Object[])new Object[]{string});
            Annotation annotation = annotationHolder.createErrorAnnotation(headerValuePart.getHighlightingRange(), string2);
            annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            return true;
        }
        return this.checkClass(headerValuePart, psiClass, annotationHolder);
    }

    protected boolean checkClass(@NotNull HeaderValuePart headerValuePart, @NotNull PsiClass psiClass, @NotNull AnnotationHolder annotationHolder) {
        String string;
        if (headerValuePart == null) {
            ClassReferenceParser.b(4);
        }
        if (psiClass == null) {
            ClassReferenceParser.b(5);
        }
        if (annotationHolder == null) {
            ClassReferenceParser.b(6);
        }
        if (MAIN_CLASS.equals(string = ((Header)headerValuePart.getParent()).getName()) && !PsiMethodUtil.hasMainMethod((PsiClass)psiClass)) {
            annotationHolder.createErrorAnnotation(headerValuePart.getHighlightingRange(), ManifestBundle.message("header.main.class.invalid", new Object[0]));
            return true;
        }
        if (PREMAIN_CLASS.equals(string) && !ClassReferenceParser.a(psiClass, "premain")) {
            annotationHolder.createErrorAnnotation(headerValuePart.getHighlightingRange(), ManifestBundle.message("header.pre-main.class.invalid", new Object[0]));
            return true;
        }
        if ((AGENT_CLASS.equals(string) || LAUNCHER_AGENT_CLASS.equals(string)) && !ClassReferenceParser.a(psiClass, "agentmain")) {
            annotationHolder.createErrorAnnotation(headerValuePart.getHighlightingRange(), ManifestBundle.message("header.agent.class.invalid", new Object[0]));
            return true;
        }
        return false;
    }

    private static boolean a(PsiClass psiClass, String string) {
        for (PsiMethod psiMethod : psiClass.findMethodsByName(string, false)) {
            if (!PsiType.VOID.equals((Object)psiMethod.getReturnType()) || !psiMethod.hasModifierProperty("public") || !psiMethod.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValuePart";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePart";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/header/impl/ClassReferenceParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

