/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.EditDistance;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.highlighting.AbstractManifestQuickFix;
import org.jetbrains.lang.manifest.psi.Header;

public class MisspelledHeaderInspection
extends LocalInspectionTool {
    private static final int d = 5;
    private static final int c = 4;
    private static final int b = 2;
    @XCollection(elementName="header")
    public final Set<String> CUSTOM_HEADERS = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private final HeaderParserRepository a = HeaderParserRepository.getInstance();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean bl2) {
        if (problemsHolder == null) {
            MisspelledHeaderInspection.a(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement psiElement) {
                if (psiElement instanceof Header) {
                    Header header = (Header)psiElement;
                    String string = header.getName();
                    TreeSet<Suggestion> treeSet = new TreeSet<Suggestion>();
                    this.a(string, MisspelledHeaderInspection.this.CUSTOM_HEADERS, treeSet);
                    this.a(string, MisspelledHeaderInspection.this.a.getAllHeaderNames(), treeSet);
                    Suggestion suggestion = (Suggestion)ContainerUtil.getFirstItem(treeSet);
                    if (suggestion != null && string.equals(suggestion.getWord())) {
                        return;
                    }
                    ArrayList<AbstractManifestQuickFix> arrayList = new ArrayList<AbstractManifestQuickFix>();
                    for (Suggestion suggestion2 : treeSet) {
                        arrayList.add(new HeaderRenameQuickFix(header, suggestion2.getWord()));
                        if (arrayList.size() != 5) continue;
                        break;
                    }
                    if (suggestion == null || suggestion.getMetrics() > 2) {
                        arrayList.add(new CustomHeaderQuickFix(header, MisspelledHeaderInspection.this.CUSTOM_HEADERS));
                    }
                    problemsHolder.registerProblem((PsiElement)header.getNameElement(), ManifestBundle.message("inspection.header.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }

            private void a(String string, Collection<String> collection, SortedSet<Suggestion> sortedSet) {
                for (String string2 : collection) {
                    int n2 = EditDistance.optimalAlignment((CharSequence)string, (CharSequence)string2, (boolean)false);
                    if (n2 > 4) continue;
                    sortedSet.add(new Suggestion(string2, n2));
                }
            }
        };
        if (psiElementVisitor == null) {
            MisspelledHeaderInspection.a(1);
        }
        return psiElementVisitor;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel(this.CUSTOM_HEADERS);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CustomHeaderQuickFix
    extends AbstractManifestQuickFix {
        private final String a;
        private final Collection<String> b;

        private CustomHeaderQuickFix(Header header, Collection<String> collection) {
            super((PsiElement)header);
            this.a = header.getName();
            this.b = collection;
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.header.remember.fix", this.a);
            if (string == null) {
                CustomHeaderQuickFix.b(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile psiFile, @NotNull PsiElement psiElement, @NotNull PsiElement psiElement2) {
            if (project2 == null) {
                CustomHeaderQuickFix.b(1);
            }
            if (psiFile == null) {
                CustomHeaderQuickFix.b(2);
            }
            if (psiElement == null) {
                CustomHeaderQuickFix.b(3);
            }
            if (psiElement2 == null) {
                CustomHeaderQuickFix.b(4);
            }
            this.b.add(this.a);
            ProjectInspectionProfileManager.getInstance((Project)project2).fireProfileChanged();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$CustomHeaderQuickFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HeaderRenameQuickFix
    extends AbstractManifestQuickFix {
        private final String a;

        private HeaderRenameQuickFix(Header header, String string) {
            super((PsiElement)header);
            this.a = string;
        }

        @NotNull
        public String getText() {
            String string = ManifestBundle.message("inspection.header.rename.fix", this.a);
            if (string == null) {
                HeaderRenameQuickFix.b(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project2, @NotNull PsiFile psiFile, @NotNull PsiElement psiElement, @NotNull PsiElement psiElement2) {
            if (project2 == null) {
                HeaderRenameQuickFix.b(1);
            }
            if (psiFile == null) {
                HeaderRenameQuickFix.b(2);
            }
            if (psiElement == null) {
                HeaderRenameQuickFix.b(3);
            }
            if (psiElement2 == null) {
                HeaderRenameQuickFix.b(4);
            }
            ((Header)psiElement).setName(this.a);
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OptionsPanel
    extends JPanel {
        public OptionsPanel(final Set<String> set) {
            super(new BorderLayout(5, 5));
            this.add((Component)new JLabel(ManifestBundle.message("inspection.header.ui.label", new Object[0])), "North");
            final JTextArea jTextArea = new JTextArea("");
            this.add((Component)jTextArea, "Center");
            if (!set.isEmpty()) {
                jTextArea.setText(StringUtil.join(new TreeSet<String>(set), (String)"\n"));
            }
            jTextArea.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent documentEvent) {
                    set.clear();
                    for (String string : StringUtil.split((String)jTextArea.getText(), (String)"\n")) {
                        String string2 = string.trim();
                        if (string2.isEmpty()) continue;
                        set.add(string2);
                    }
                }
            });
        }
    }
}

