/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.header.impl.StandardHeaderParser;
import org.jetbrains.lang.manifest.psi.ManifestElementType;
import org.jetbrains.lang.manifest.psi.ManifestTokenType;

public class ManifestParser
implements PsiParser {
    public static final TokenSet HEADER_END_TOKENS = TokenSet.create((IElementType[])new IElementType[]{ManifestTokenType.SECTION_END, ManifestTokenType.HEADER_NAME});
    private final HeaderParserRepository a = (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);

    @NotNull
    public ASTNode parse(@NotNull IElementType iElementType, @NotNull PsiBuilder psiBuilder) {
        if (iElementType == null) {
            ManifestParser.a(0);
        }
        if (psiBuilder == null) {
            ManifestParser.a(1);
        }
        psiBuilder.setDebugMode(ApplicationManager.getApplication().isUnitTestMode());
        PsiBuilder.Marker marker = psiBuilder.mark();
        while (!psiBuilder.eof()) {
            this.c(psiBuilder);
        }
        marker.done(iElementType);
        ASTNode aSTNode = psiBuilder.getTreeBuilt();
        if (aSTNode == null) {
            ManifestParser.a(2);
        }
        return aSTNode;
    }

    private void c(PsiBuilder psiBuilder) {
        PsiBuilder.Marker marker = psiBuilder.mark();
        while (!psiBuilder.eof()) {
            IElementType iElementType = psiBuilder.getTokenType();
            if (iElementType == ManifestTokenType.HEADER_NAME) {
                this.a(psiBuilder);
                continue;
            }
            if (iElementType == ManifestTokenType.SECTION_END) {
                psiBuilder.advanceLexer();
                break;
            }
            PsiBuilder.Marker marker2 = psiBuilder.mark();
            ManifestParser.b(psiBuilder);
            marker2.error(ManifestBundle.message("manifest.header.expected", new Object[0]));
        }
        marker.done(ManifestElementType.SECTION);
    }

    private void a(PsiBuilder psiBuilder) {
        PsiBuilder.Marker marker = psiBuilder.mark();
        String string = psiBuilder.getTokenText();
        assert (string != null) : "[" + psiBuilder.getOriginalText() + "]@" + psiBuilder.getCurrentOffset();
        psiBuilder.advanceLexer();
        if (psiBuilder.getTokenType() == ManifestTokenType.COLON) {
            psiBuilder.advanceLexer();
            if (!PsiBuilderUtil.expect((PsiBuilder)psiBuilder, (IElementType)ManifestTokenType.SIGNIFICANT_SPACE)) {
                psiBuilder.error(ManifestBundle.message("manifest.whitespace.expected", new Object[0]));
            }
            HeaderParser headerParser = (HeaderParser)ObjectUtils.notNull((Object)this.a.getHeaderParser(string), (Object)StandardHeaderParser.INSTANCE);
            headerParser.parse(psiBuilder);
        } else {
            PsiBuilder.Marker marker2 = psiBuilder.mark();
            ManifestParser.b(psiBuilder);
            marker2.error(ManifestBundle.message("manifest.colon.expected", new Object[0]));
        }
        marker.done(ManifestElementType.HEADER);
    }

    private static void b(PsiBuilder psiBuilder) {
        while (!psiBuilder.eof() && !HEADER_END_TOKENS.contains(psiBuilder.getTokenType())) {
            psiBuilder.advanceLexer();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/parser/ManifestParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/parser/ManifestParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

