/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleComponentAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class ModuleMetadataStore {
    private final PathKeyFileStore metaDataStore;
    private final ModuleMetadataSerializer moduleMetadataSerializer;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ModuleMetadataStore(PathKeyFileStore metaDataStore, ModuleMetadataSerializer moduleMetadataSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.metaDataStore = metaDataStore;
        this.moduleMetadataSerializer = moduleMetadataSerializer;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableModuleComponentResolveMetadata getModuleDescriptor(ModuleComponentAtRepositoryKey component) {
        String filePath = this.getFilePath(component);
        LocallyAvailableResource resource = this.metaDataStore.get(filePath);
        if (resource != null) {
            MutableModuleComponentResolveMetadata mutableModuleComponentResolveMetadata;
            KryoBackedDecoder decoder = new KryoBackedDecoder(new FileInputStream(resource.getFile()));
            try {
                mutableModuleComponentResolveMetadata = this.moduleMetadataSerializer.read(decoder, this.moduleIdentifierFactory);
            }
            catch (Throwable throwable) {
                try {
                    decoder.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load module metadata from " + resource.getDisplayName(), e);
                }
            }
            decoder.close();
            return mutableModuleComponentResolveMetadata;
        }
        return null;
    }

    public LocallyAvailableResource putModuleDescriptor(ModuleComponentAtRepositoryKey component, final ModuleComponentResolveMetadata metadata) {
        String filePath = this.getFilePath(component);
        return this.metaDataStore.add(filePath, new Action<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(File moduleDescriptorFile) {
                try {
                    KryoBackedEncoder encoder = new KryoBackedEncoder(new FileOutputStream(moduleDescriptorFile));
                    try {
                        ModuleMetadataStore.this.moduleMetadataSerializer.write(encoder, metadata);
                    }
                    finally {
                        encoder.close();
                    }
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        });
    }

    private String getFilePath(ModuleComponentAtRepositoryKey componentId) {
        ModuleComponentIdentifier moduleComponentIdentifier = componentId.getComponentId();
        return moduleComponentIdentifier.getGroup() + "/" + moduleComponentIdentifier.getModule() + "/" + moduleComponentIdentifier.getVersion() + "/" + componentId.getRepositoryId() + "/descriptor.bin";
    }
}

