/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.gradle.api.GradleException;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.internal.component.model.ComponentResolveMetadata;

class LatestModuleConflictResolver
implements ModuleConflictResolver {
    private final Comparator<Version> versionComparator;

    LatestModuleConflictResolver(VersionComparator versionComparator) {
        this.versionComparator = versionComparator.asVersionComparator();
    }

    @Override
    public <T extends ComponentResolutionState> void select(ConflictResolverDetails<T> details) {
        Version baseVersion = null;
        LinkedHashMap<Version, ComponentResolutionState> matches = new LinkedHashMap<Version, ComponentResolutionState>();
        Collection<T> candidates = details.getCandidates();
        for (ComponentResolutionState candidate : candidates) {
            Version version = VersionParser.INSTANCE.transform(candidate.getVersion());
            if (baseVersion == null || this.versionComparator.compare(version.getBaseVersion(), baseVersion) > 0) {
                boolean accept = true;
                for (ComponentResolutionState t : candidates) {
                    VersionSelector rejectedVersionSelector;
                    ResolvedVersionConstraint candidateConstraints = t.getVersionConstraint();
                    if (t == candidate || candidateConstraints == null || (rejectedVersionSelector = candidateConstraints.getRejectedSelector()) == null || !rejectedVersionSelector.accept(version)) continue;
                    accept = false;
                    break;
                }
                baseVersion = version.getBaseVersion();
                if (accept) {
                    matches.put(version, candidate);
                    continue;
                }
                matches.clear();
                continue;
            }
            if (!version.getBaseVersion().equals(baseVersion)) continue;
            matches.put(version, candidate);
        }
        if (matches.isEmpty()) {
            StringBuilder sb = new StringBuilder("Cannot find a version of ");
            boolean first = true;
            for (ComponentResolutionState candidate : candidates) {
                if (first) {
                    sb.append("'").append(candidate.getId().getModule()).append("'");
                    sb.append(" that satisfies the constraints: ");
                } else {
                    sb.append(", ");
                }
                sb.append(LatestModuleConflictResolver.render(candidate.getVersionConstraint()));
                first = false;
            }
            details.fail(new GradleException(sb.toString()));
            return;
        }
        if (matches.size() == 1) {
            details.select((ComponentResolutionState)matches.values().iterator().next());
            return;
        }
        ArrayList sorted = new ArrayList(matches.keySet());
        Collections.sort(sorted, Collections.reverseOrder(this.versionComparator));
        for (Version version : sorted) {
            ComponentResolutionState component = (ComponentResolutionState)matches.get(version);
            if (!version.isQualified()) {
                details.select(component);
                return;
            }
            ComponentResolveMetadata metaData = component.getMetaData();
            if (metaData == null || !"release".equals(metaData.getStatus())) continue;
            details.select(component);
            return;
        }
        details.select((ComponentResolutionState)matches.get(sorted.get(0)));
    }

    private static String render(ResolvedVersionConstraint constraint) {
        VersionSelector preferredSelector = constraint.getPreferredSelector();
        VersionSelector rejectedSelector = constraint.getRejectedSelector();
        StringBuilder sb = new StringBuilder("prefers ");
        sb.append(preferredSelector.getSelector());
        if (rejectedSelector != null) {
            sb.append(", rejects ").append(rejectedSelector.getSelector());
        }
        return sb.toString();
    }
}

