/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetaData;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.internal.artifacts.transform.TransformedFileCache;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.changedetection.state.Snapshot;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resource.local.DefaultPathKeyFileStore;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.FileStoreAddActionException;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.util.BiFunction;

public class DefaultTransformedFileCache
implements TransformedFileCache,
Stoppable,
RootBuildLifecycleListener {
    private final PersistentCache cache;
    private final PersistentIndexedCache<HashCode, List<File>> indexedCache;
    private final FileStore<String> fileStore;
    private final ProducerGuard<HashCode> producing = ProducerGuard.adaptive();
    private final Map<HashCode, List<File>> resultHashToResult = new ConcurrentHashMap<HashCode, List<File>>();
    private final FileSystemSnapshotter fileSystemSnapshotter;

    public DefaultTransformedFileCache(ArtifactCacheMetaData artifactCacheMetaData, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory cacheDecoratorFactory, FileSystemSnapshotter fileSystemSnapshotter) {
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        File transformsStoreDirectory = artifactCacheMetaData.getTransformsStoreDirectory();
        File filesOutputDirectory = new File(transformsStoreDirectory, CacheLayout.TRANSFORMS_STORE.getKey());
        this.fileStore = new DefaultPathKeyFileStore(filesOutputDirectory);
        this.cache = cacheRepository.cache(transformsStoreDirectory).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withDisplayName("Artifact transforms cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
        String cacheName = CacheLayout.TRANSFORMS_META_DATA.getKey() + "/results";
        PersistentIndexedCacheParameters<HashCode, File> cacheParameters = new PersistentIndexedCacheParameters<HashCode, File>(cacheName, new HashCodeSerializer(), new ListSerializer<File>(BaseSerializerFactory.FILE_SERIALIZER)).cacheDecorator(cacheDecoratorFactory.decorator(1000, true));
        this.indexedCache = this.cache.createCache(cacheParameters);
    }

    @Override
    public void stop() {
        this.cache.close();
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeComplete() {
        this.resultHashToResult.clear();
    }

    @Override
    public List<File> getResult(final File inputFile, HashCode inputsHash, final BiFunction<List<File>, File, File> transformer) {
        Snapshot inputFileSnapshot = this.fileSystemSnapshotter.snapshotAll(inputFile);
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        hasher.putHash(inputsHash);
        inputFileSnapshot.appendToHasher(hasher);
        final HashCode resultHash = hasher.hash();
        return this.producing.guardByKey(resultHash, new Factory<List<File>>(){

            @Override
            public List<File> create() {
                List<File> files = (List<File>)DefaultTransformedFileCache.this.resultHashToResult.get(resultHash);
                if (files != null) {
                    return files;
                }
                files = DefaultTransformedFileCache.this.cache.withFileLock(new Factory<List<File>>(){

                    @Override
                    public List<File> create() {
                        List files = (List)DefaultTransformedFileCache.this.indexedCache.get(resultHash);
                        if (files != null) {
                            boolean allExist = true;
                            for (File file : files) {
                                if (file.exists()) continue;
                                allExist = false;
                                break;
                            }
                            if (allExist) {
                                return files;
                            }
                        }
                        String key = inputFile.getName() + "/" + resultHash;
                        TransformAction action = new TransformAction(transformer, inputFile);
                        try {
                            DefaultTransformedFileCache.this.fileStore.add(key, action);
                        }
                        catch (FileStoreAddActionException e) {
                            throw UncheckedException.throwAsUncheckedException(e.getCause());
                        }
                        DefaultTransformedFileCache.this.indexedCache.put(resultHash, action.result);
                        return action.result;
                    }
                });
                DefaultTransformedFileCache.this.resultHashToResult.put(resultHash, files);
                return files;
            }
        });
    }

    private static class TransformAction
    implements Action<File> {
        private final BiFunction<List<File>, File, File> transformer;
        private final File inputFile;
        private ImmutableList<File> result;

        TransformAction(BiFunction<List<File>, File, File> transformer, File inputFile) {
            this.transformer = transformer;
            this.inputFile = inputFile;
        }

        @Override
        public void execute(File outputDir) {
            outputDir.mkdirs();
            this.result = ImmutableList.copyOf((Collection)this.transformer.apply(this.inputFile, outputDir));
        }
    }
}

