/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.tasks.TaskFilePropertyBuilder;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class TaskPropertyUtils {
    public static <T extends TaskFilePropertySpec> ImmutableSortedSet<T> collectFileProperties(String displayName, Iterator<? extends T> fileProperties) {
        HashSet names = Sets.newHashSet();
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (fileProperties.hasNext()) {
            TaskFilePropertySpec propertySpec = (TaskFilePropertySpec)fileProperties.next();
            String propertyName = propertySpec.getPropertyName();
            if (!names.add(propertyName)) {
                throw new IllegalArgumentException(String.format("Multiple %s file properties with name '%s'", displayName, propertyName));
            }
            builder.add((Object)propertySpec);
        }
        return builder.build();
    }

    public static <T extends TaskPropertySpec & TaskFilePropertyBuilder> void ensurePropertiesHaveNames(Iterable<T> properties) {
        int unnamedPropertyCounter = 0;
        for (TaskPropertySpec propertySpec : properties) {
            String propertyName = propertySpec.getPropertyName();
            if (propertyName != null) continue;
            propertyName = "$" + ++unnamedPropertyCounter;
            ((TaskFilePropertyBuilder)((Object)propertySpec)).withPropertyName(propertyName);
        }
    }

    public static <T extends TaskFilePropertySpec> SortedSet<ResolvedTaskOutputFilePropertySpec> resolveFileProperties(ImmutableSortedSet<T> properties) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (TaskFilePropertySpec property : properties) {
            CacheableTaskOutputFilePropertySpec cacheableProperty = (CacheableTaskOutputFilePropertySpec)Cast.uncheckedCast(property);
            builder.add((Object)new ResolvedTaskOutputFilePropertySpec(cacheableProperty.getPropertyName(), cacheableProperty.getOutputType(), cacheableProperty.getOutputFile()));
        }
        return builder.build();
    }

    @Nullable
    public static String checkPropertyName(@Nullable String propertyName) {
        if (propertyName != null) {
            if (propertyName.length() == 0) {
                throw new IllegalArgumentException("Property name must not be empty string");
            }
            if (!Character.isJavaIdentifierStart(propertyName.codePointAt(0))) {
                throw new IllegalArgumentException(String.format("Property name '%s' must be a valid Java identifier", propertyName));
            }
            boolean previousCharWasADot = false;
            for (int idx = 1; idx < propertyName.length(); ++idx) {
                int chr = propertyName.codePointAt(idx);
                if (chr == 46 && !previousCharWasADot && idx < propertyName.length() - 1) {
                    previousCharWasADot = true;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(chr)) {
                    throw new IllegalArgumentException(String.format("Property name '%s' must be a valid Java identifier", propertyName));
                }
                previousCharWasADot = false;
            }
        }
        return propertyName;
    }
}

