/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.util.Collections;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;

class JavaChangeProcessor {
    private final SourceToNameConverter sourceToNameConverter;
    private final PreviousCompilation previousCompilation;

    public JavaChangeProcessor(PreviousCompilation previousCompilation, SourceToNameConverter sourceToNameConverter) {
        this.previousCompilation = previousCompilation;
        this.sourceToNameConverter = sourceToNameConverter;
    }

    public void processChange(InputFileDetails input, RecompilationSpec spec) {
        String className = this.sourceToNameConverter.getClassName(input.getFile());
        spec.getClassNames().add(className);
        DependentsSet actualDependents = this.previousCompilation.getDependents(className, Collections.<Integer>emptySet());
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription(), input.getFile());
            return;
        }
        spec.getClassNames().addAll(actualDependents.getDependentClasses());
    }
}

