/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;

public class ClassFilesAnalyzer
implements FileVisitor {
    private final ClassDependenciesAnalyzer analyzer;
    private final ClassDependentsAccumulator accumulator;
    private final FileHasher hasher;

    public ClassFilesAnalyzer(ClassDependenciesAnalyzer analyzer, FileHasher fileHasher) {
        this(analyzer, fileHasher, new ClassDependentsAccumulator());
    }

    ClassFilesAnalyzer(ClassDependenciesAnalyzer analyzer, FileHasher fileHasher, ClassDependentsAccumulator accumulator) {
        this.analyzer = analyzer;
        this.hasher = fileHasher;
        this.accumulator = accumulator;
    }

    @Override
    public void visitDir(FileVisitDetails dirDetails) {
    }

    @Override
    public void visitFile(FileVisitDetails fileDetails) {
        if (!fileDetails.getName().endsWith(".class")) {
            return;
        }
        HashCode hash = this.hasher.hash(fileDetails);
        ClassAnalysis analysis = this.analyzer.getClassAnalysis(hash, fileDetails);
        this.accumulator.addClass(fileDetails.getFile(), analysis);
    }

    public ClassSetAnalysisData getAnalysis() {
        return this.accumulator.getAnalysis();
    }
}

