/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.Named;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.impldep.com.google.gson.stream.JsonWriter;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.util.GradleVersion;

public class ModuleMetadataFileGenerator {
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;

    public ModuleMetadataFileGenerator(BuildInvocationScopeId buildInvocationScopeId, ProjectDependencyPublicationResolver projectDependencyResolver) {
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.projectDependencyResolver = projectDependencyResolver;
    }

    public void generateTo(PublicationInternal publication, Collection<? extends PublicationInternal> publications, Writer writer) throws IOException {
        HashMap<SoftwareComponent, ModuleVersionIdentifier> coordinates = new HashMap<SoftwareComponent, ModuleVersionIdentifier>();
        this.collectCoordinates(publications, coordinates);
        HashMap<SoftwareComponent, SoftwareComponent> owners = new HashMap<SoftwareComponent, SoftwareComponent>();
        this.collectOwners(publications, owners);
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setIndent("  ");
        this.writeComponentWithVariants(publication, publication.getComponent(), coordinates, owners, jsonWriter);
        jsonWriter.flush();
        writer.append('\n');
    }

    private void collectOwners(Collection<? extends PublicationInternal> publications, Map<SoftwareComponent, SoftwareComponent> owners) {
        for (PublicationInternal publicationInternal : publications) {
            if (!(publicationInternal.getComponent() instanceof ComponentWithVariants)) continue;
            ComponentWithVariants componentWithVariants = (ComponentWithVariants)((Object)publicationInternal.getComponent());
            for (SoftwareComponent softwareComponent : componentWithVariants.getVariants()) {
                owners.put(softwareComponent, publicationInternal.getComponent());
            }
        }
    }

    private void collectCoordinates(Collection<? extends PublicationInternal> publications, Map<SoftwareComponent, ModuleVersionIdentifier> coordinates) {
        for (PublicationInternal publicationInternal : publications) {
            if (publicationInternal.getComponent() == null) continue;
            coordinates.put(publicationInternal.getComponent(), publicationInternal.getCoordinates());
        }
    }

    private void writeComponentWithVariants(PublicationInternal publication, SoftwareComponent component, Map<SoftwareComponent, ModuleVersionIdentifier> componentCoordinates, Map<SoftwareComponent, SoftwareComponent> owners, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        this.writeFormat(jsonWriter);
        this.writeIdentity(publication.getCoordinates(), component, componentCoordinates, owners, jsonWriter);
        this.writeCreator(jsonWriter);
        this.writeVariants(publication, component, componentCoordinates, jsonWriter);
        jsonWriter.endObject();
    }

    private void writeVersionConstraint(VersionConstraint versionConstraint, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("version");
        jsonWriter.beginObject();
        jsonWriter.name("prefers");
        jsonWriter.value(versionConstraint.getPreferredVersion());
        jsonWriter.name("rejects");
        jsonWriter.beginArray();
        List<String> rejectedVersions = versionConstraint.getRejectedVersions();
        for (String reject : rejectedVersions) {
            jsonWriter.value(reject);
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }

    private void writeIdentity(ModuleVersionIdentifier coordinates, SoftwareComponent component, Map<SoftwareComponent, ModuleVersionIdentifier> componentCoordinates, Map<SoftwareComponent, SoftwareComponent> owners, JsonWriter jsonWriter) throws IOException {
        SoftwareComponent owner = owners.get(component);
        if (owner == null) {
            jsonWriter.name("component");
            jsonWriter.beginObject();
            jsonWriter.name("group");
            jsonWriter.value(coordinates.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(coordinates.getName());
            jsonWriter.name("version");
            jsonWriter.value(coordinates.getVersion());
            jsonWriter.endObject();
        } else {
            ModuleVersionIdentifier ownerCoordinates = componentCoordinates.get(owner);
            jsonWriter.name("component");
            jsonWriter.beginObject();
            jsonWriter.name("url");
            jsonWriter.value(this.relativeUrlTo(coordinates, ownerCoordinates));
            jsonWriter.name("group");
            jsonWriter.value(ownerCoordinates.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(ownerCoordinates.getName());
            jsonWriter.name("version");
            jsonWriter.value(ownerCoordinates.getVersion());
            jsonWriter.endObject();
        }
    }

    private void writeVariants(PublicationInternal publication, SoftwareComponent component, Map<SoftwareComponent, ModuleVersionIdentifier> componentCoordinates, JsonWriter jsonWriter) throws IOException {
        boolean started = false;
        for (UsageContext usageContext : ((SoftwareComponentInternal)component).getUsages()) {
            if (!started) {
                jsonWriter.name("variants");
                jsonWriter.beginArray();
                started = true;
            }
            this.writeVariantHostedInThisModule(publication, usageContext, jsonWriter);
        }
        if (component instanceof ComponentWithVariants) {
            for (SoftwareComponent softwareComponent : ((ComponentWithVariants)((Object)component)).getVariants()) {
                ModuleVersionIdentifier childCoordinates = componentCoordinates.get(softwareComponent);
                if (childCoordinates == null || !(softwareComponent instanceof SoftwareComponentInternal)) continue;
                for (UsageContext usageContext : ((SoftwareComponentInternal)softwareComponent).getUsages()) {
                    if (!started) {
                        jsonWriter.name("variants");
                        jsonWriter.beginArray();
                        started = true;
                    }
                    this.writeVariantHostedInAnotherModule(publication.getCoordinates(), childCoordinates, usageContext, jsonWriter);
                }
            }
        }
        if (started) {
            jsonWriter.endArray();
        }
    }

    private void writeCreator(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("createdBy");
        jsonWriter.beginObject();
        jsonWriter.name("gradle");
        jsonWriter.beginObject();
        jsonWriter.name("version");
        jsonWriter.value(GradleVersion.current().getVersion());
        jsonWriter.name("buildId");
        jsonWriter.value(this.buildInvocationScopeId.getId().asString());
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private void writeFormat(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("formatVersion");
        jsonWriter.value("0.2");
    }

    private void writeVariantHostedInAnotherModule(ModuleVersionIdentifier coordinates, ModuleVersionIdentifier targetCoordinates, UsageContext variant, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("name");
        jsonWriter.value(variant.getName());
        this.writeAttributes(variant.getAttributes(), jsonWriter);
        jsonWriter.name("available-at");
        jsonWriter.beginObject();
        jsonWriter.name("url");
        jsonWriter.value(this.relativeUrlTo(coordinates, targetCoordinates));
        jsonWriter.name("group");
        jsonWriter.value(targetCoordinates.getGroup());
        jsonWriter.name("module");
        jsonWriter.value(targetCoordinates.getName());
        jsonWriter.name("version");
        jsonWriter.value(targetCoordinates.getVersion());
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private String relativeUrlTo(ModuleVersionIdentifier from, ModuleVersionIdentifier to) {
        StringBuilder path = new StringBuilder();
        path.append("../../");
        path.append(to.getName());
        path.append("/");
        path.append(to.getVersion());
        path.append("/");
        path.append(to.getName());
        path.append("-");
        path.append(to.getVersion());
        path.append(".module");
        return path.toString();
    }

    private void writeVariantHostedInThisModule(PublicationInternal publication, UsageContext variant, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("name");
        jsonWriter.value(variant.getName());
        this.writeAttributes(variant.getAttributes(), jsonWriter);
        this.writeDependencies(variant, jsonWriter);
        this.writeArtifacts(publication, variant, jsonWriter);
        jsonWriter.endObject();
    }

    private void writeAttributes(AttributeContainer attributes, JsonWriter jsonWriter) throws IOException {
        if (attributes.isEmpty()) {
            return;
        }
        jsonWriter.name("attributes");
        jsonWriter.beginObject();
        TreeMap sortedAttributes = new TreeMap();
        for (Attribute<?> attribute : attributes.keySet()) {
            sortedAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute<Object> attribute : sortedAttributes.values()) {
            jsonWriter.name(attribute.getName());
            Object value = attributes.getAttribute(attribute);
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                jsonWriter.value(b);
                continue;
            }
            if (value instanceof String) {
                String s = (String)value;
                jsonWriter.value(s);
                continue;
            }
            if (value instanceof Named) {
                Named named = (Named)value;
                jsonWriter.value(named.getName());
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot write attribute %s with unsupported value %s of type %s.", attribute.getName(), value, value.getClass().getName()));
        }
        jsonWriter.endObject();
    }

    private void writeArtifacts(PublicationInternal publication, UsageContext variant, JsonWriter jsonWriter) throws IOException {
        if (variant.getArtifacts().isEmpty()) {
            return;
        }
        jsonWriter.name("files");
        jsonWriter.beginArray();
        for (PublishArtifact publishArtifact : variant.getArtifacts()) {
            this.writeArtifact(publication, publishArtifact, jsonWriter);
        }
        jsonWriter.endArray();
    }

    private void writeArtifact(PublicationInternal publication, PublishArtifact artifact, JsonWriter jsonWriter) throws IOException {
        PublicationInternal.PublishedFile publishedFile = publication.getPublishedFile(artifact);
        jsonWriter.beginObject();
        jsonWriter.name("name");
        jsonWriter.value(publishedFile.getName());
        jsonWriter.name("url");
        jsonWriter.value(publishedFile.getUri());
        jsonWriter.name("size");
        jsonWriter.value(artifact.getFile().length());
        jsonWriter.name("sha1");
        jsonWriter.value(HashUtil.sha1(artifact.getFile()).asHexString());
        jsonWriter.name("md5");
        jsonWriter.value(HashUtil.createHash(artifact.getFile(), "md5").asHexString());
        jsonWriter.endObject();
    }

    private void writeDependencies(UsageContext variant, JsonWriter jsonWriter) throws IOException {
        if (variant.getDependencies().isEmpty()) {
            return;
        }
        jsonWriter.name("dependencies");
        jsonWriter.beginArray();
        for (ModuleDependency moduleDependency : variant.getDependencies()) {
            this.writeDependency(moduleDependency, jsonWriter);
        }
        jsonWriter.endArray();
    }

    private void writeDependency(ModuleDependency moduleDependency, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        if (moduleDependency instanceof ProjectDependency) {
            ProjectDependency dependency = (ProjectDependency)moduleDependency;
            ModuleVersionIdentifier identifier = this.projectDependencyResolver.resolve(dependency);
            jsonWriter.name("group");
            jsonWriter.value(identifier.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(identifier.getName());
            this.writeVersionConstraint(DefaultImmutableVersionConstraint.of(identifier.getVersion()), jsonWriter);
        } else {
            jsonWriter.name("group");
            jsonWriter.value(moduleDependency.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(moduleDependency.getName());
            VersionConstraint vc = moduleDependency instanceof ModuleVersionSelector ? ((ExternalDependency)moduleDependency).getVersionConstraint() : DefaultImmutableVersionConstraint.of(moduleDependency.getVersion());
            this.writeVersionConstraint(vc, jsonWriter);
        }
        jsonWriter.endObject();
    }
}

