/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DisconnectedDescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DisconnectedIvyXmlModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.publish.internal.PublicationFieldValidator;
import org.gradle.api.publish.ivy.InvalidIvyPublicationException;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.internal.component.external.model.MutableIvyModuleResolveMetadata;
import org.gradle.internal.impldep.org.apache.commons.lang.ObjectUtils;
import org.gradle.internal.resource.local.FileResourceRepository;

public class ValidatingIvyPublisher
implements IvyPublisher {
    private final DescriptorParseContext parserSettings = new DisconnectedDescriptorParseContext();
    private final IvyPublisher delegate;
    private final DisconnectedIvyXmlModuleDescriptorParser moduleDescriptorParser;

    public ValidatingIvyPublisher(IvyPublisher delegate, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileResourceRepository fileResourceRepository) {
        this.delegate = delegate;
        this.moduleDescriptorParser = new DisconnectedIvyXmlModuleDescriptorParser(new IvyModuleDescriptorConverter(moduleIdentifierFactory), moduleIdentifierFactory, fileResourceRepository);
    }

    @Override
    public void publish(IvyNormalizedPublication publication, PublicationAwareRepository repository) {
        this.validateMetadata(publication);
        this.validateArtifacts(publication);
        this.checkNoDuplicateArtifacts(publication);
        this.delegate.publish(publication, repository);
    }

    private void validateMetadata(IvyNormalizedPublication publication) {
        IvyPublicationIdentity identity = publication.getProjectIdentity();
        IvyFieldValidator organisation = (IvyFieldValidator)((IvyFieldValidator)this.field(publication, "organisation", identity.getOrganisation()).notEmpty()).validInFileName();
        IvyFieldValidator moduleName = (IvyFieldValidator)((IvyFieldValidator)this.field(publication, "module name", identity.getModule()).notEmpty()).validInFileName();
        IvyFieldValidator revision = (IvyFieldValidator)((IvyFieldValidator)this.field(publication, "revision", identity.getRevision()).notEmpty()).validInFileName();
        MutableIvyModuleResolveMetadata metadata = this.parseIvyFile(publication);
        ModuleVersionIdentifier moduleId = metadata.getId();
        organisation.matches(moduleId.getGroup());
        moduleName.matches(moduleId.getName());
        revision.matches(moduleId.getVersion());
        ((IvyFieldValidator)this.field(publication, "branch", metadata.getBranch()).optionalNotEmpty()).doesNotContainSpecialCharacters(true);
        ((IvyFieldValidator)this.field(publication, "status", metadata.getStatus()).optionalNotEmpty()).validInFileName();
    }

    private MutableIvyModuleResolveMetadata parseIvyFile(IvyNormalizedPublication publication) {
        try {
            return (MutableIvyModuleResolveMetadata)this.moduleDescriptorParser.parseMetaData(this.parserSettings, publication.getDescriptorFile());
        }
        catch (MetaDataParseException pe) {
            throw new InvalidIvyPublicationException(publication.getName(), pe.getLocalizedMessage(), pe);
        }
    }

    private void validateArtifacts(IvyNormalizedPublication publication) {
        for (IvyArtifact artifact : publication.getArtifacts()) {
            ((IvyFieldValidator)this.field(publication, "artifact name", artifact.getName()).notEmpty()).validInFileName();
            ((IvyFieldValidator)this.field(publication, "artifact type", artifact.getType()).notEmpty()).validInFileName();
            ((IvyFieldValidator)this.field(publication, "artifact extension", artifact.getExtension()).notNull()).validInFileName();
            ((IvyFieldValidator)this.field(publication, "artifact classifier", artifact.getClassifier()).optionalNotEmpty()).validInFileName();
            this.checkCanPublish(publication.getName(), artifact);
        }
    }

    private void checkNoDuplicateArtifacts(IvyNormalizedPublication publication) {
        HashSet<IvyArtifact> verified = new HashSet<IvyArtifact>();
        for (IvyArtifact artifact : publication.getArtifacts()) {
            this.checkNotDuplicate(publication, verified, artifact.getName(), artifact.getExtension(), artifact.getType(), artifact.getClassifier());
            verified.add(artifact);
        }
        this.checkNotDuplicate(publication, verified, "ivy", "xml", "xml", null);
    }

    private void checkNotDuplicate(IvyNormalizedPublication publication, Set<IvyArtifact> verified, String name, String extension, String type, String classifier) {
        for (IvyArtifact alreadyVerified : verified) {
            if (!this.hasCoordinates(alreadyVerified, name, extension, type, classifier)) continue;
            String message = String.format("multiple artifacts with the identical name, extension, type and classifier ('%s', %s', '%s', '%s').", name, extension, type, classifier);
            throw new InvalidIvyPublicationException(publication.getName(), message);
        }
    }

    private boolean hasCoordinates(IvyArtifact one, String name, String extension, String type, String classifier) {
        return ObjectUtils.equals((Object)one.getName(), (Object)name) && ObjectUtils.equals((Object)one.getType(), (Object)type) && ObjectUtils.equals((Object)one.getExtension(), (Object)extension) && ObjectUtils.equals((Object)one.getClassifier(), (Object)classifier);
    }

    private void checkCanPublish(String name, IvyArtifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile == null || !artifactFile.exists()) {
            throw new InvalidIvyPublicationException(name, String.format("artifact file does not exist: '%s'", artifactFile));
        }
        if (artifactFile.isDirectory()) {
            throw new InvalidIvyPublicationException(name, String.format("artifact file is a directory: '%s'", artifactFile));
        }
    }

    private IvyFieldValidator field(IvyNormalizedPublication publication, String name, String value) {
        return new IvyFieldValidator(publication.getName(), name, value);
    }

    private static class IvyFieldValidator
    extends PublicationFieldValidator<IvyFieldValidator> {
        private IvyFieldValidator(String publicationName, String name, String value) {
            super(IvyFieldValidator.class, publicationName, name, value);
        }

        public IvyFieldValidator matches(String expectedValue) {
            if (!this.value.equals(expectedValue)) {
                throw new InvalidIvyPublicationException(this.publicationName, String.format("supplied %s does not match ivy descriptor (cannot edit %1$s directly in the ivy descriptor file).", this.name));
            }
            return this;
        }

        @Override
        protected InvalidUserDataException failure(String message) {
            throw new InvalidIvyPublicationException(this.publicationName, message);
        }
    }
}

