/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.BuildableComponentSpec;
import org.gradle.api.internal.AbstractBuildableComponentSpec;
import org.gradle.ide.visualstudio.TextConfigFile;
import org.gradle.ide.visualstudio.TextProvider;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectResolver;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;

public class DefaultVisualStudioSolution
extends AbstractBuildableComponentSpec
implements VisualStudioSolution {
    private final DefaultVisualStudioProject rootProject;
    private final SolutionFile solutionFile;
    private final VisualStudioProjectResolver vsProjectResolver;

    public DefaultVisualStudioSolution(ComponentSpecIdentifier componentIdentifier, DefaultVisualStudioProject rootProject, PathToFileResolver fileResolver, VisualStudioProjectResolver vsProjectResolver, Instantiator instantiator) {
        super(componentIdentifier, (Class<? extends BuildableComponentSpec>)VisualStudioSolution.class);
        this.rootProject = rootProject;
        this.vsProjectResolver = vsProjectResolver;
        this.solutionFile = instantiator.newInstance(SolutionFile.class, fileResolver, this.getName() + ".sln");
    }

    @Override
    public SolutionFile getSolutionFile() {
        return this.solutionFile;
    }

    @Override
    public NativeComponentSpec getComponent() {
        return this.rootProject.getComponent();
    }

    @Override
    public Set<VisualStudioProject> getProjects() {
        LinkedHashSet<VisualStudioProject> projects = new LinkedHashSet<VisualStudioProject>();
        for (VisualStudioProjectConfiguration solutionConfig : this.getSolutionConfigurations()) {
            for (VisualStudioProjectConfiguration projectConfig : this.getProjectConfigurations(solutionConfig)) {
                projects.add(projectConfig.getProject());
            }
        }
        return projects;
    }

    public List<VisualStudioProjectConfiguration> getSolutionConfigurations() {
        return this.rootProject.getConfigurations();
    }

    public List<VisualStudioProjectConfiguration> getProjectConfigurations(VisualStudioProjectConfiguration solutionConfiguration) {
        LinkedHashSet<VisualStudioProjectConfiguration> configurations = new LinkedHashSet<VisualStudioProjectConfiguration>();
        configurations.add(solutionConfiguration);
        this.addDependentConfigurations(configurations, solutionConfiguration);
        return new ArrayList<VisualStudioProjectConfiguration>(configurations);
    }

    private void addDependentConfigurations(Set configurations, VisualStudioProjectConfiguration configuration) {
        for (NativeLibraryBinary library : configuration.getBinary().getDependentBinaries()) {
            VisualStudioProjectConfiguration libraryConfiguration;
            if (!(library instanceof NativeBinarySpecInternal) || !configurations.add(libraryConfiguration = this.vsProjectResolver.lookupProjectConfiguration((NativeBinarySpec)((Object)library)))) continue;
            this.addDependentConfigurations(configurations, libraryConfiguration);
        }
    }

    public final DefaultVisualStudioProject getRootProject() {
        return this.rootProject;
    }

    public static class SolutionFile
    implements TextConfigFile {
        private final List<Action<? super TextProvider>> actions = new ArrayList<Action<? super TextProvider>>();
        private final PathToFileResolver fileResolver;
        private Object location;

        public SolutionFile(PathToFileResolver fileResolver, String defaultLocation) {
            this.fileResolver = fileResolver;
            this.location = defaultLocation;
        }

        @Override
        public File getLocation() {
            return this.fileResolver.resolve(this.location);
        }

        @Override
        public void setLocation(Object location) {
            this.location = location;
        }

        @Override
        public void withContent(Action<? super TextProvider> action) {
            this.actions.add(action);
        }

        public List<Action<? super TextProvider>> getTextActions() {
            return this.actions;
        }
    }
}

