/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildIdentity;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public class DefaultProjectComponentSelector
implements ProjectComponentSelector {
    private final String buildName;
    private final String projectPath;
    private final String displayName;

    public DefaultProjectComponentSelector(String buildName, String projectPath) {
        assert (buildName != null) : "build cannot be null";
        assert (projectPath != null) : "project path cannot be null";
        this.buildName = buildName;
        this.projectPath = projectPath;
        this.displayName = DefaultProjectComponentSelector.createDisplayName(buildName, projectPath);
    }

    private static String createDisplayName(String buildName, String projectPath) {
        if (":".equals(buildName)) {
            return "project " + projectPath;
        }
        return "project :" + buildName + projectPath;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getBuildName() {
        return this.buildName;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)identifier;
            return Objects.equal((Object)this.buildName, (Object)projectComponentIdentifier.getBuild().getName()) && Objects.equal((Object)this.projectPath, (Object)projectComponentIdentifier.getProjectPath());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProjectComponentSelector)) {
            return false;
        }
        DefaultProjectComponentSelector that = (DefaultProjectComponentSelector)o;
        return Objects.equal((Object)this.buildName, (Object)that.buildName) && Objects.equal((Object)this.projectPath, (Object)that.projectPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.buildName, this.projectPath});
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ProjectComponentSelector newSelector(Project project) {
        BuildIdentifier buildId = ((ProjectInternal)project).getServices().get(BuildIdentity.class).getCurrentBuild();
        return new DefaultProjectComponentSelector(buildId.getName(), project.getPath());
    }

    public static ProjectComponentSelector newSelector(IncludedBuild build, String projectPath) {
        return new DefaultProjectComponentSelector(build.getName(), projectPath);
    }

    public static ProjectComponentSelector newSelector(BuildIdentifier build, String projectPath) {
        return new DefaultProjectComponentSelector(build.getName(), projectPath);
    }

    public static ProjectComponentSelector newSelector(IncludedBuild build, ProjectComponentSelector selector) {
        return DefaultProjectComponentSelector.newSelector(build, selector.getProjectPath());
    }

    public static ProjectComponentSelector newSelector(ProjectComponentIdentifier projectId) {
        return new DefaultProjectComponentSelector(projectId.getBuild().getName(), projectId.getProjectPath());
    }
}

