/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.dispatch;

import org.gradle.internal.dispatch.Dispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextClassLoaderDispatch<T>
implements Dispatch<T> {
    private final Dispatch<? super T> dispatch;
    private final ClassLoader contextClassLoader;

    public ContextClassLoaderDispatch(Dispatch<? super T> dispatch, ClassLoader contextClassLoader) {
        this.dispatch = dispatch;
        this.contextClassLoader = contextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(T message) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
        try {
            this.dispatch.dispatch(message);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }
}

