/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import java.io.Flushable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.logging.console.AnsiConsole;
import org.gradle.internal.logging.sink.AnsiConsoleUtil;
import org.gradle.internal.logging.sink.OutputEventRenderer;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.FallbackConsoleMetaData;
import org.gradle.internal.nativeintegration.services.NativeServices;

public class ConsoleConfigureAction {
    public static void execute(OutputEventRenderer renderer, ConsoleOutput consoleOutput) {
        if (consoleOutput == ConsoleOutput.Auto) {
            ConsoleConfigureAction.configureAutoConsole(renderer);
        } else if (consoleOutput == ConsoleOutput.Rich) {
            ConsoleConfigureAction.configureRichConsole(renderer, false);
        } else if (consoleOutput == ConsoleOutput.Verbose) {
            ConsoleConfigureAction.configureRichConsole(renderer, true);
        }
    }

    private static void configureRichConsole(OutputEventRenderer renderer, boolean verbose) {
        ConsoleMetaData consoleMetaData;
        ConsoleDetector consoleDetector = NativeServices.getInstance().get(ConsoleDetector.class);
        ConsoleConfigureAction.configureConsole(renderer, consoleMetaData, (consoleMetaData = consoleDetector.getConsole()) == null, verbose);
    }

    private static void configureAutoConsole(OutputEventRenderer renderer) {
        ConsoleDetector consoleDetector = NativeServices.getInstance().get(ConsoleDetector.class);
        ConsoleMetaData consoleMetaData = consoleDetector.getConsole();
        if (consoleMetaData != null) {
            ConsoleConfigureAction.configureConsole(renderer, consoleMetaData, false, false);
        }
    }

    private static void configureConsole(OutputEventRenderer renderer, ConsoleMetaData consoleMetaData, boolean force, boolean verbose) {
        ConsoleMetaData consoleMetaData2 = consoleMetaData = consoleMetaData == null ? FallbackConsoleMetaData.INSTANCE : consoleMetaData;
        if (consoleMetaData.isStdOut()) {
            OutputStream originalStdOut = renderer.getOriginalStdOut();
            OutputStreamWriter outStr = new OutputStreamWriter(force ? originalStdOut : AnsiConsoleUtil.wrapOutputStream(originalStdOut));
            AnsiConsole console = new AnsiConsole((Appendable)outStr, (Flushable)outStr, renderer.getColourMap(), consoleMetaData, force);
            renderer.addConsole(console, true, consoleMetaData.isStdErr(), consoleMetaData, verbose);
        } else if (consoleMetaData.isStdErr()) {
            OutputStream originalStdErr = renderer.getOriginalStdErr();
            OutputStreamWriter errStr = new OutputStreamWriter(force ? originalStdErr : AnsiConsoleUtil.wrapOutputStream(originalStdErr));
            AnsiConsole console = new AnsiConsole((Appendable)errStr, (Flushable)errStr, renderer.getColourMap(), consoleMetaData, force);
            renderer.addConsole(console, false, true, consoleMetaData, verbose);
        }
    }
}

