/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import net.rubygrapefruit.platform.PosixFiles;
import org.gradle.internal.nativeintegration.filesystem.FileCanonicalizer;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.Symlink;
import org.gradle.internal.nativeintegration.filesystem.services.EmptyChmod;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackFileCanonicalizer;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackStat;
import org.gradle.internal.nativeintegration.filesystem.services.GenericFileSystem;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedChmod;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedStat;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedSymlink;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.filesystem.services.UnsupportedFilePermissions;
import org.gradle.internal.nativeintegration.filesystem.services.UnsupportedSymlink;
import org.gradle.internal.nativeintegration.filesystem.services.WindowsSymlink;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemServices.class);

    public FileCanonicalizer createFileCanonicalizer() {
        return JavaReflectionUtil.newInstanceOrFallback("org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7FileCanonicalizer", FileSystemServices.class.getClassLoader(), FallbackFileCanonicalizer.class);
    }

    public FileSystem createFileSystem(OperatingSystem operatingSystem, PosixFiles posixFiles, FileMetadataAccessor metadataAccessor) throws Exception {
        if (operatingSystem.isWindows()) {
            Symlink symlink = JavaReflectionUtil.newInstanceOrFallback("org.gradle.internal.nativeintegration.filesystem.jdk7.WindowsJdk7Symlink", FileSystemServices.class.getClassLoader(), WindowsSymlink.class);
            return new GenericFileSystem(new EmptyChmod(), new FallbackStat(), symlink, metadataAccessor);
        }
        if (!(posixFiles instanceof UnavailablePosixFiles)) {
            NativePlatformBackedSymlink symlink = new NativePlatformBackedSymlink(posixFiles);
            NativePlatformBackedChmod chmod = new NativePlatformBackedChmod(posixFiles);
            NativePlatformBackedStat stat = new NativePlatformBackedStat(posixFiles);
            return new GenericFileSystem(chmod, stat, symlink, metadataAccessor);
        }
        LOGGER.debug("Native-platform file system integration is not available. Continuing with fallback.");
        Symlink symlink = JavaReflectionUtil.newInstanceOrFallback("org.gradle.internal.nativeintegration.filesystem.jdk7.Jdk7Symlink", FileSystemServices.class.getClassLoader(), UnsupportedSymlink.class);
        LOGGER.debug("Using {} implementation as symlink.", (Object)symlink.getClass().getSimpleName());
        UnsupportedFilePermissions handler = JavaReflectionUtil.newInstanceOrFallback("org.gradle.internal.nativeintegration.filesystem.jdk7.PosixJdk7FilePermissionHandler", FileSystemServices.class.getClassLoader(), UnsupportedFilePermissions.class);
        return new GenericFileSystem(handler, handler, symlink, metadataAccessor);
    }
}

