/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.GradleThread;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.ParallelismConfigurationListener;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationIdentifierRegistry;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationQueueFactory;
import org.gradle.internal.operations.BuildOperationQueueFailure;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.BuildOperationState;
import org.gradle.internal.progress.OperationFinishEvent;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.internal.resources.ResourceDeadlockException;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.time.Clock;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOperationExecutor
implements BuildOperationExecutor,
Stoppable,
ParallelismConfigurationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildOperationExecutor.class);
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final BuildOperationListener listener;
    private final Clock clock;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final BuildOperationQueueFactory buildOperationQueueFactory;
    private final ResourceLockCoordinationService resourceLockCoordinationService;
    private final ManagedExecutor fixedSizePool;
    private final ParallelismConfigurationManager parallelismConfigurationManager;
    private final BuildOperationIdFactory buildOperationIdFactory;
    private final ThreadLocal<DefaultBuildOperationState> currentOperation = new ThreadLocal();

    public DefaultBuildOperationExecutor(BuildOperationListener listener, Clock clock, ProgressLoggerFactory progressLoggerFactory, BuildOperationQueueFactory buildOperationQueueFactory, ExecutorFactory executorFactory, ResourceLockCoordinationService resourceLockCoordinationService, ParallelismConfigurationManager parallelismConfigurationManager, BuildOperationIdFactory buildOperationIdFactory) {
        this.listener = listener;
        this.clock = clock;
        this.progressLoggerFactory = progressLoggerFactory;
        this.buildOperationQueueFactory = buildOperationQueueFactory;
        this.resourceLockCoordinationService = resourceLockCoordinationService;
        this.fixedSizePool = executorFactory.create("build operations", parallelismConfigurationManager.getParallelismConfiguration().getMaxWorkerCount());
        this.parallelismConfigurationManager = parallelismConfigurationManager;
        this.buildOperationIdFactory = buildOperationIdFactory;
        parallelismConfigurationManager.addListener(this);
    }

    @Override
    public void onParallelismConfigurationChange(ParallelismConfiguration parallelismConfiguration) {
        this.fixedSizePool.setFixedPoolSize(parallelismConfiguration.getMaxWorkerCount());
    }

    @Override
    public BuildOperationState getCurrentOperation() {
        BuildOperationState current = this.currentOperation.get();
        if (current == null) {
            throw new IllegalStateException("No operation is currently running.");
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(RunnableBuildOperation buildOperation) {
        try {
            this.execute(buildOperation, new RunnableBuildOperationWorker(), this.currentOperation.get());
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T call(CallableBuildOperation<T> buildOperation) {
        CallableBuildOperationWorker worker = new CallableBuildOperationWorker();
        try {
            this.execute(buildOperation, worker, this.currentOperation.get());
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
        return worker.getReturnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction) {
        try {
            this.executeInParallel(new ParentPreservingQueueWorker(new RunnableBuildOperationWorker()), schedulingAction);
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction) {
        try {
            this.executeInParallel(new ParentPreservingQueueWorker(worker), schedulingAction);
        }
        finally {
            this.maybeStopUnmanagedThreadOperation();
        }
    }

    private <O extends BuildOperation> void executeInParallel(BuildOperationQueue.QueueWorker<O> worker, Action<BuildOperationQueue<O>> queueAction) {
        this.failIfInResourceLockTransform();
        BuildOperationQueue<O> queue = this.buildOperationQueueFactory.create(this.fixedSizePool, worker);
        ArrayList failures = Lists.newArrayList();
        try {
            queueAction.execute(queue);
        }
        catch (Exception e) {
            failures.add(new BuildOperationQueueFailure("There was a failure while populating the build operation queue: " + e.getMessage(), e));
            queue.cancel();
        }
        try {
            queue.waitForCompletion();
        }
        catch (MultipleBuildOperationFailures e) {
            failures.add(e);
        }
        if (failures.size() == 1) {
            throw (GradleException)failures.get(0);
        }
        if (failures.size() > 1) {
            throw new DefaultMultiCauseException(DefaultBuildOperationExecutor.formatMultipleFailureMessage(failures), failures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <O extends BuildOperation> void execute(O buildOperation, BuildOperationWorker<O> worker, @Nullable DefaultBuildOperationState defaultParent) {
        this.failIfInResourceLockTransform();
        BuildOperationDescriptor.Builder descriptorBuilder = buildOperation.description();
        DefaultBuildOperationState parent = (DefaultBuildOperationState)descriptorBuilder.getParentState();
        if (parent == null) {
            parent = defaultParent;
        }
        BuildOperationDescriptor descriptor = this.createDescriptor(descriptorBuilder, parent);
        DefaultBuildOperationState currentOperation = new DefaultBuildOperationState(descriptor, this.clock.getCurrentTime());
        this.assertParentRunning("Cannot start operation (%s) as parent operation (%s) has already completed.", descriptor, parent);
        currentOperation.setRunning(true);
        DefaultBuildOperationState operationBefore = this.currentOperation.get();
        this.currentOperation.set(currentOperation);
        BuildOperationIdentifierRegistry.setCurrentOperationIdentifier(this.currentOperation.get().getId());
        try {
            this.listener.started(descriptor, new OperationStartEvent(currentOperation.getStartTime()));
            ProgressLogger progressLogger = this.createProgressLogger(currentOperation);
            Throwable failure = null;
            DefaultBuildOperationContext context = new DefaultBuildOperationContext();
            LOGGER.debug("Build operation '{}' started", (Object)descriptor.getDisplayName());
            try {
                worker.execute(buildOperation, context);
            }
            catch (Throwable t) {
                context.thrown(t);
                failure = t;
            }
            LOGGER.debug("Completing Build operation '{}'", (Object)descriptor.getDisplayName());
            progressLogger.completed(context.status, context.failure != null);
            this.listener.finished(descriptor, new OperationFinishEvent(currentOperation.getStartTime(), this.clock.getCurrentTime(), context.failure, context.result));
            this.assertParentRunning("Parent operation (%2$s) completed before this operation (%1$s).", descriptor, parent);
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException(failure, true);
            }
            LOGGER.debug("Build operation '{}' completed", (Object)descriptor.getDisplayName());
        }
        finally {
            this.currentOperation.set(operationBefore);
            if (parent != null) {
                BuildOperationIdentifierRegistry.setCurrentOperationIdentifier(parent.getId());
            } else {
                BuildOperationIdentifierRegistry.clearCurrentOperationIdentifier();
            }
            currentOperation.setRunning(false);
        }
    }

    private void failIfInResourceLockTransform() {
        if (this.resourceLockCoordinationService.getCurrent() != null) {
            throw new ResourceDeadlockException("An attempt was made to execute build operations inside of a resource lock transform.  Aborting to avoid a deadlock.");
        }
    }

    private BuildOperationDescriptor createDescriptor(BuildOperationDescriptor.Builder descriptorBuilder, DefaultBuildOperationState parent) {
        OperationIdentifier id = new OperationIdentifier(this.buildOperationIdFactory.nextId());
        DefaultBuildOperationState current = this.maybeStartUnmanagedThreadOperation(parent);
        return descriptorBuilder.build(id, current == null ? null : current.getDescription().getId());
    }

    private void assertParentRunning(String message, BuildOperationDescriptor child, DefaultBuildOperationState parent) {
        if (parent != null && !parent.isRunning()) {
            String parentName = parent.getDescription().getDisplayName();
            throw new IllegalStateException(String.format(message, child.getDisplayName(), parentName));
        }
    }

    private ProgressLogger createProgressLogger(DefaultBuildOperationState currentOperation) {
        BuildOperationDescriptor descriptor = currentOperation.getDescription();
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DefaultBuildOperationExecutor.class, descriptor);
        return progressLogger.start(descriptor.getDisplayName(), descriptor.getProgressDisplayName());
    }

    private DefaultBuildOperationState maybeStartUnmanagedThreadOperation(DefaultBuildOperationState parentState) {
        if (!GradleThread.isManaged() && parentState == null) {
            parentState = UnmanagedThreadOperation.create(this.clock);
            parentState.setRunning(true);
            this.currentOperation.set(parentState);
            this.listener.started(parentState.getDescription(), new OperationStartEvent(parentState.getStartTime()));
        }
        return parentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStopUnmanagedThreadOperation() {
        DefaultBuildOperationState current = this.currentOperation.get();
        if (current instanceof UnmanagedThreadOperation) {
            try {
                this.listener.finished(current.getDescription(), new OperationFinishEvent(current.getStartTime(), this.clock.getCurrentTime(), null, null));
            }
            finally {
                this.currentOperation.set(null);
                current.setRunning(false);
            }
        }
    }

    protected void createRunningRootOperation(String displayName) {
        assert (this.currentOperation.get() == null);
        OperationIdentifier rootBuildOpId = new OperationIdentifier(1L);
        DefaultBuildOperationState operation = new DefaultBuildOperationState(BuildOperationDescriptor.displayName(displayName).build(rootBuildOpId, null), this.clock.getCurrentTime());
        operation.setRunning(true);
        this.currentOperation.set(operation);
    }

    private static String formatMultipleFailureMessage(List<GradleException> failures) {
        return StringUtils.join(CollectionUtils.collect(failures, new Transformer<String, GradleException>(){

            @Override
            public String transform(GradleException e) {
                return e.getMessage();
            }
        }), (String)(LINE_SEPARATOR + "AND" + LINE_SEPARATOR));
    }

    @Override
    public void stop() {
        this.parallelismConfigurationManager.removeListener(this);
        this.fixedSizePool.stop();
    }

    private static class UnmanagedThreadOperation
    extends DefaultBuildOperationState {
        private static final AtomicLong UNMANAGED_THREAD_OPERATION_COUNTER = new AtomicLong(-1L);

        private static UnmanagedThreadOperation create(Clock clock) {
            LOGGER.debug("WARNING No operation is currently running in unmanaged thread: {}", (Object)Thread.currentThread().getName());
            OperationIdentifier id = new OperationIdentifier(UNMANAGED_THREAD_OPERATION_COUNTER.getAndDecrement());
            String displayName = "Unmanaged thread operation #" + id + " (" + Thread.currentThread().getName() + ')';
            return new UnmanagedThreadOperation(BuildOperationDescriptor.displayName(displayName).build(id, null), null, clock.getCurrentTime());
        }

        private UnmanagedThreadOperation(BuildOperationDescriptor descriptor, BuildOperationState parent, long startTime) {
            super(descriptor, startTime);
        }
    }

    private static class DefaultBuildOperationState
    implements BuildOperationState {
        private final BuildOperationDescriptor description;
        private final AtomicBoolean running = new AtomicBoolean();
        private final long startTime;

        private DefaultBuildOperationState(BuildOperationDescriptor descriptor, long startTime) {
            this.startTime = startTime;
            this.description = descriptor;
        }

        BuildOperationDescriptor getDescription() {
            return this.description;
        }

        boolean isRunning() {
            return this.running.get();
        }

        void setRunning(boolean running) {
            this.running.set(running);
        }

        long getStartTime() {
            return this.startTime;
        }

        public Object getId() {
            return this.description.getId();
        }

        public Object getParentId() {
            return this.description.getParentId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentPreservingQueueWorker<O extends BuildOperation>
    implements BuildOperationQueue.QueueWorker<O> {
        private DefaultBuildOperationState parent;
        private BuildOperationWorker<O> worker;

        private ParentPreservingQueueWorker(BuildOperationWorker<O> worker) {
            this.parent = DefaultBuildOperationExecutor.this.maybeStartUnmanagedThreadOperation((DefaultBuildOperationState)DefaultBuildOperationExecutor.this.currentOperation.get());
            this.worker = worker;
        }

        @Override
        public String getDisplayName() {
            return "runnable worker";
        }

        @Override
        public void execute(O buildOperation) {
            DefaultBuildOperationExecutor.this.execute(buildOperation, this.worker, this.parent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CallableBuildOperationWorker<T>
    implements BuildOperationWorker<CallableBuildOperation<T>> {
        private T returnValue;

        private CallableBuildOperationWorker() {
        }

        @Override
        public String getDisplayName() {
            return "callable build operation";
        }

        @Override
        public void execute(CallableBuildOperation<T> buildOperation, BuildOperationContext context) {
            this.returnValue = buildOperation.call(context);
        }

        public T getReturnValue() {
            return this.returnValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RunnableBuildOperationWorker<O extends RunnableBuildOperation>
    implements BuildOperationWorker<O> {
        private RunnableBuildOperationWorker() {
        }

        @Override
        public String getDisplayName() {
            return "runnable build operation";
        }

        @Override
        public void execute(O buildOperation, BuildOperationContext context) {
            buildOperation.run(context);
        }
    }

    private static class DefaultBuildOperationContext
    implements BuildOperationContext {
        Throwable failure;
        Object result;
        private String status;

        private DefaultBuildOperationContext() {
        }

        public void failed(Throwable t) {
            this.failure = t;
        }

        public void thrown(Throwable t) {
            if (this.failure == null) {
                this.failure = t;
            }
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

