/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.Collection;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.changes.DiscoveredInputRecorder;
import org.gradle.api.internal.changedetection.state.FileSystemSnapshotter;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.cache.PersistentStateCache;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.DefaultSourceIncludesResolver;
import org.gradle.language.nativeplatform.internal.incremental.HeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileFilesFactory;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileProcessor;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.CSourceParser;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

@NonNullApi
public class IncrementalNativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegateCompiler;
    private final boolean importsAreIncludes;
    private final TaskInternal task;
    private final FileSystemSnapshotter fileSystemSnapshotter;
    private final CompilationStateCacheFactory compilationStateCacheFactory;
    private final CSourceParser sourceParser;
    private final HeaderDependenciesCollector headerDependenciesCollector;

    public IncrementalNativeCompiler(TaskInternal task, FileSystemSnapshotter fileSystemSnapshotter, CompilationStateCacheFactory compilationStateCacheFactory, Compiler<T> delegateCompiler, NativeToolChain toolChain, HeaderDependenciesCollector headerDependenciesCollector, CSourceParser sourceParser) {
        this.task = task;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
        this.compilationStateCacheFactory = compilationStateCacheFactory;
        this.delegateCompiler = delegateCompiler;
        this.importsAreIncludes = Clang.class.isAssignableFrom(toolChain.getClass()) || Gcc.class.isAssignableFrom(toolChain.getClass());
        this.headerDependenciesCollector = headerDependenciesCollector;
        this.sourceParser = sourceParser;
    }

    @Override
    public WorkResult execute(T spec) {
        PersistentStateCache<CompilationState> compileStateCache = this.compilationStateCacheFactory.create(this.task.getPath());
        IncrementalCompileProcessor processor = this.createProcessor(compileStateCache, this.createIncrementalCompileFilesFactory(spec));
        IncrementalCompilation compilation = processor.processSourceFiles(spec.getSourceFiles());
        spec.setSourceFileIncludeDirectives(compilation.getSourceFileIncludeDirectives());
        this.handleDiscoveredInputs(spec, compilation, spec.getDiscoveredInputRecorder());
        WorkResult workResult = spec.isIncrementalCompile() ? this.doIncrementalCompile(compilation, spec) : this.doCleanIncrementalCompile(spec);
        compileStateCache.set(compilation.getFinalState());
        return workResult;
    }

    private IncrementalCompileFilesFactory createIncrementalCompileFilesFactory(T spec) {
        DefaultSourceIncludesParser sourceIncludesParser = new DefaultSourceIncludesParser(this.sourceParser, this.importsAreIncludes);
        DefaultSourceIncludesResolver includesResolver = new DefaultSourceIncludesResolver(spec.getIncludeRoots());
        return new IncrementalCompileFilesFactory(sourceIncludesParser, includesResolver, this.fileSystemSnapshotter);
    }

    protected void handleDiscoveredInputs(T spec, IncrementalCompilation compilation, DiscoveredInputRecorder discoveredInputRecorder) {
        ImmutableSortedSet<File> headerDependencies = this.headerDependenciesCollector.collectHeaderDependencies(this.getTask().getPath(), spec.getIncludeRoots(), compilation);
        discoveredInputRecorder.newInputs((Collection<File>)headerDependencies);
    }

    protected WorkResult doIncrementalCompile(IncrementalCompilation compilation, T spec) {
        spec.setSourceFiles(compilation.getRecompile());
        spec.setRemovedSourceFiles(compilation.getRemoved());
        return this.delegateCompiler.execute(spec);
    }

    protected WorkResult doCleanIncrementalCompile(T spec) {
        boolean deleted = this.cleanPreviousOutputs((NativeCompileSpec)spec);
        WorkResult compileResult = this.delegateCompiler.execute(spec);
        if (deleted && !compileResult.getDidWork()) {
            return WorkResults.didWork(true);
        }
        return compileResult;
    }

    private boolean cleanPreviousOutputs(NativeCompileSpec spec) {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getTask().getOutputs());
        cleaner.setDestinationDir(spec.getObjectFileDir());
        cleaner.execute();
        return cleaner.getDidWork();
    }

    protected TaskInternal getTask() {
        return this.task;
    }

    private IncrementalCompileProcessor createProcessor(PersistentStateCache<CompilationState> compileStateCache, IncrementalCompileFilesFactory incrementalCompileFilesFactory) {
        return new IncrementalCompileProcessor(compileStateCache, incrementalCompileFilesFactory);
    }
}

