/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.internal.DefaultSwiftApplication;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.util.GUtil;

@Incubating
public class SwiftExecutablePlugin
implements Plugin<ProjectInternal> {
    private final FileOperations fileOperations;

    @Inject
    public SwiftExecutablePlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        TaskContainerInternal tasks = project.getTasks();
        SwiftApplication application = project.getExtensions().create(SwiftApplication.class, "executable", DefaultSwiftApplication.class, "main", project.getLayout(), project.getObjects(), this.fileOperations, configurations);
        project.getComponents().add(application);
        project.getComponents().add(application.getDebugExecutable());
        project.getComponents().add(application.getReleaseExecutable());
        application.getModule().set(GUtil.toCamelCase(project.getName()));
        tasks.getByName("assemble").dependsOn(application.getDevelopmentBinary().getInstallDirectory());
    }
}

